/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.NtfsAlternateDataStreamObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NtfsAlternateDataStreamObj", generator="Immutables")
@Immutable
public final class NtfsAlternateDataStream
implements NtfsAlternateDataStreamObj {
    private final String name;
    private final ImmutableMap<String, String> hashes;
    @Nullable
    private final Long size;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private NtfsAlternateDataStream(String name, ImmutableMap<String, String> hashes, @Nullable Long size, ImmutableMap<String, Object> customProperties) {
        this.name = name;
        this.hashes = hashes;
        this.size = size;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the alternate data stream.")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies a dictionary of hashes for the data contained in the alternate data stream.")
    public ImmutableMap<String, String> getHashes() {
        return this.hashes;
    }

    @Override
    @JsonProperty(value="size")
    @JsonPropertyDescription(value="Specifies the size of the alternate data stream, in bytes, as a non-negative integer.")
    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final NtfsAlternateDataStream withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return NtfsAlternateDataStream.validate(new NtfsAlternateDataStream(value, this.hashes, this.size, this.customProperties));
    }

    public final NtfsAlternateDataStream withHashes(Map<String, ? extends String> entries) {
        if (this.hashes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return NtfsAlternateDataStream.validate(new NtfsAlternateDataStream(this.name, (ImmutableMap<String, String>)newValue, this.size, this.customProperties));
    }

    public final NtfsAlternateDataStream withSize(long value) {
        Long newValue = value;
        if (Objects.equals(this.size, newValue)) {
            return this;
        }
        return NtfsAlternateDataStream.validate(new NtfsAlternateDataStream(this.name, this.hashes, newValue, this.customProperties));
    }

    public final NtfsAlternateDataStream withSize(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return NtfsAlternateDataStream.validate(new NtfsAlternateDataStream(this.name, this.hashes, value, this.customProperties));
    }

    public final NtfsAlternateDataStream withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return NtfsAlternateDataStream.validate(new NtfsAlternateDataStream(this.name, this.hashes, this.size, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NtfsAlternateDataStream && this.equalTo((NtfsAlternateDataStream)another);
    }

    private boolean equalTo(NtfsAlternateDataStream another) {
        return Objects.equals(this.name, another.name) && this.hashes.equals(another.hashes) && Objects.equals(this.size, another.size) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + Objects.hashCode(this.size);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NtfsAlternateDataStream").omitNullValues().add("name", (Object)this.name).add("hashes", this.hashes).add("size", (Object)this.size).add("customProperties", this.customProperties).toString();
    }

    private static NtfsAlternateDataStream validate(NtfsAlternateDataStream instance) {
        instance.validateEntity();
        return instance;
    }

    public static NtfsAlternateDataStream copyOf(NtfsAlternateDataStreamObj instance) {
        if (instance instanceof NtfsAlternateDataStream) {
            return (NtfsAlternateDataStream)instance;
        }
        return NtfsAlternateDataStream.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return NtfsAlternateDataStream.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"name", "hashes", "size"})
    @Generated(from="NtfsAlternateDataStreamObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
        @Nullable
        private Long size;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(NtfsAlternateDataStreamObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof NtfsAlternateDataStreamObj) {
                String nameValue;
                instance = (NtfsAlternateDataStreamObj)object;
                Optional<Long> sizeOptional = instance.getSize();
                if (sizeOptional.isPresent()) {
                    this.size(sizeOptional);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                this.putAllHashes(instance.getHashes());
            }
        }

        @JsonProperty(value="name")
        @JsonPropertyDescription(value="Specifies the name of the alternate data stream.")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(String key, String value) {
            this.hashes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(Map.Entry<String, ? extends String> entry) {
            this.hashes.put(entry);
            return this;
        }

        @JsonProperty(value="hashes")
        @JsonPropertyDescription(value="Specifies a dictionary of hashes for the data contained in the alternate data stream.")
        @CanIgnoreReturnValue
        public final Builder hashes(Map<String, ? extends String> entries) {
            this.hashes = ImmutableMap.builder();
            return this.putAllHashes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHashes(Map<String, ? extends String> entries) {
            this.hashes.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder size(long size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="size")
        @JsonPropertyDescription(value="Specifies the size of the alternate data stream, in bytes, as a non-negative integer.")
        @CanIgnoreReturnValue
        public final Builder size(Optional<Long> size) {
            this.size = size.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public NtfsAlternateDataStream build() {
            return NtfsAlternateDataStream.validate(new NtfsAlternateDataStream(this.name, this.hashes.build(), this.size, this.customProperties.build()));
        }
    }
}

