/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.WindowsPeOptionalHeaderObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WindowsPeOptionalHeaderObj", generator="Immutables")
@Immutable
public final class WindowsPeOptionalHeader
implements WindowsPeOptionalHeaderObj {
    @Nullable
    private final String magicHex;
    @Nullable
    private final Long majorLinkerVersion;
    @Nullable
    private final Long minorLinkerVersion;
    @Nullable
    private final Long sizeOfCode;
    @Nullable
    private final Long sizeOfInitializedData;
    @Nullable
    private final Long sizeOfUninitializedData;
    @Nullable
    private final Long addressOfEntryPoint;
    @Nullable
    private final Long baseOfCode;
    @Nullable
    private final Long baseOfData;
    @Nullable
    private final Long imageBase;
    @Nullable
    private final Long sectionAlignment;
    @Nullable
    private final Long fileAlignment;
    @Nullable
    private final Long majorOsVersion;
    @Nullable
    private final Long minorOsVersion;
    @Nullable
    private final Long majorImageVersion;
    @Nullable
    private final Long minorImageVersion;
    @Nullable
    private final Long majorSubsystemVersion;
    @Nullable
    private final Long minorSubsystemVersion;
    @Nullable
    private final String win32VersionValueHex;
    @Nullable
    private final Long sizeOfImage;
    @Nullable
    private final Long sizeOfHeaders;
    @Nullable
    private final String checksumHex;
    @Nullable
    private final String subsystemHex;
    @Nullable
    private final String dllCharacteristicsHex;
    @Nullable
    private final Long sizeOfStackReserve;
    @Nullable
    private final Long sizeOfStackCommit;
    @Nullable
    private final Long sizeOfHeapReserve;
    @Nullable
    private final Long sizeOfHeapCommit;
    @Nullable
    private final String loaderFlagsHex;
    @Nullable
    private final Long numberOfRvaAndSizes;
    private final ImmutableMap<String, String> hashes;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private WindowsPeOptionalHeader(@Nullable String magicHex, @Nullable Long majorLinkerVersion, @Nullable Long minorLinkerVersion, @Nullable Long sizeOfCode, @Nullable Long sizeOfInitializedData, @Nullable Long sizeOfUninitializedData, @Nullable Long addressOfEntryPoint, @Nullable Long baseOfCode, @Nullable Long baseOfData, @Nullable Long imageBase, @Nullable Long sectionAlignment, @Nullable Long fileAlignment, @Nullable Long majorOsVersion, @Nullable Long minorOsVersion, @Nullable Long majorImageVersion, @Nullable Long minorImageVersion, @Nullable Long majorSubsystemVersion, @Nullable Long minorSubsystemVersion, @Nullable String win32VersionValueHex, @Nullable Long sizeOfImage, @Nullable Long sizeOfHeaders, @Nullable String checksumHex, @Nullable String subsystemHex, @Nullable String dllCharacteristicsHex, @Nullable Long sizeOfStackReserve, @Nullable Long sizeOfStackCommit, @Nullable Long sizeOfHeapReserve, @Nullable Long sizeOfHeapCommit, @Nullable String loaderFlagsHex, @Nullable Long numberOfRvaAndSizes, ImmutableMap<String, String> hashes, ImmutableMap<String, Object> customProperties) {
        this.magicHex = magicHex;
        this.majorLinkerVersion = majorLinkerVersion;
        this.minorLinkerVersion = minorLinkerVersion;
        this.sizeOfCode = sizeOfCode;
        this.sizeOfInitializedData = sizeOfInitializedData;
        this.sizeOfUninitializedData = sizeOfUninitializedData;
        this.addressOfEntryPoint = addressOfEntryPoint;
        this.baseOfCode = baseOfCode;
        this.baseOfData = baseOfData;
        this.imageBase = imageBase;
        this.sectionAlignment = sectionAlignment;
        this.fileAlignment = fileAlignment;
        this.majorOsVersion = majorOsVersion;
        this.minorOsVersion = minorOsVersion;
        this.majorImageVersion = majorImageVersion;
        this.minorImageVersion = minorImageVersion;
        this.majorSubsystemVersion = majorSubsystemVersion;
        this.minorSubsystemVersion = minorSubsystemVersion;
        this.win32VersionValueHex = win32VersionValueHex;
        this.sizeOfImage = sizeOfImage;
        this.sizeOfHeaders = sizeOfHeaders;
        this.checksumHex = checksumHex;
        this.subsystemHex = subsystemHex;
        this.dllCharacteristicsHex = dllCharacteristicsHex;
        this.sizeOfStackReserve = sizeOfStackReserve;
        this.sizeOfStackCommit = sizeOfStackCommit;
        this.sizeOfHeapReserve = sizeOfHeapReserve;
        this.sizeOfHeapCommit = sizeOfHeapCommit;
        this.loaderFlagsHex = loaderFlagsHex;
        this.numberOfRvaAndSizes = numberOfRvaAndSizes;
        this.hashes = hashes;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="magic_hex")
    @JsonPropertyDescription(value="Specifies the unsigned Optional<Integer> that indicates the type of the PE binary.")
    public Optional<String> getMagicHex() {
        return Optional.ofNullable(this.magicHex);
    }

    @Override
    @JsonProperty(value="major_linker_version")
    @JsonPropertyDescription(value="Specifies the linker major version number.")
    public Optional<Long> getMajorLinkerVersion() {
        return Optional.ofNullable(this.majorLinkerVersion);
    }

    @Override
    @JsonProperty(value="minor_linker_version")
    @JsonPropertyDescription(value="Specifies the linker minor version number.")
    public Optional<Long> getMinorLinkerVersion() {
        return Optional.ofNullable(this.minorLinkerVersion);
    }

    @Override
    @JsonProperty(value="size_of_code")
    @JsonPropertyDescription(value="Specifies the size of the code (text) section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public Optional<Long> getSizeOfCode() {
        return Optional.ofNullable(this.sizeOfCode);
    }

    @Override
    @JsonProperty(value="size_of_initialized_data")
    @JsonPropertyDescription(value="Specifies the size of the initialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public Optional<Long> getSizeOfInitializedData() {
        return Optional.ofNullable(this.sizeOfInitializedData);
    }

    @Override
    @JsonProperty(value="size_of_uninitialized_data")
    @JsonPropertyDescription(value="Specifies the size of the uninitialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public Optional<Long> getSizeOfUninitializedData() {
        return Optional.ofNullable(this.sizeOfUninitializedData);
    }

    @Override
    @JsonProperty(value="address_of_entry_point")
    @JsonPropertyDescription(value="Specifies the address of the entry point relative to the image base when the executable is loaded into memory.")
    public Optional<Long> getAddressOfEntryPoint() {
        return Optional.ofNullable(this.addressOfEntryPoint);
    }

    @Override
    @JsonProperty(value="base_of_code")
    @JsonPropertyDescription(value="Specifies the address that is relative to the image base of the beginning-of-code section when it is loaded into memory.")
    public Optional<Long> getBaseOfCode() {
        return Optional.ofNullable(this.baseOfCode);
    }

    @Override
    @JsonProperty(value="base_of_data")
    @JsonPropertyDescription(value="Specifies the address that is relative to the image base of the beginning-of-data section when it is loaded into memory.")
    public Optional<Long> getBaseOfData() {
        return Optional.ofNullable(this.baseOfData);
    }

    @Override
    @JsonProperty(value="image_base")
    @JsonPropertyDescription(value="Specifies the preferred address of the first byte of the image when loaded into memory.")
    public Optional<Long> getImageBase() {
        return Optional.ofNullable(this.imageBase);
    }

    @Override
    @JsonProperty(value="section_alignment")
    @JsonPropertyDescription(value="Specifies the alignment (in bytes) of PE sections when they are loaded into memory.")
    public Optional<Long> getSectionAlignment() {
        return Optional.ofNullable(this.sectionAlignment);
    }

    @Override
    @JsonProperty(value="file_alignment")
    @JsonPropertyDescription(value="Specifies the factor (in bytes) that is used to align the raw data of sections in the image file.")
    public Optional<Long> getFileAlignment() {
        return Optional.ofNullable(this.fileAlignment);
    }

    @Override
    @JsonProperty(value="major_os_version")
    @JsonPropertyDescription(value="Specifies the major version number of the required operating system.")
    public Optional<Long> getMajorOsVersion() {
        return Optional.ofNullable(this.majorOsVersion);
    }

    @Override
    @JsonProperty(value="minor_os_version")
    @JsonPropertyDescription(value="Specifies the minor version number of the required operating system.")
    public Optional<Long> getMinorOsVersion() {
        return Optional.ofNullable(this.minorOsVersion);
    }

    @Override
    @JsonProperty(value="major_image_version")
    @JsonPropertyDescription(value="Specifies the major version number of the image.")
    public Optional<Long> getMajorImageVersion() {
        return Optional.ofNullable(this.majorImageVersion);
    }

    @Override
    @JsonProperty(value="minor_image_version")
    @JsonPropertyDescription(value="Specifies the minor version number of the image.")
    public Optional<Long> getMinorImageVersion() {
        return Optional.ofNullable(this.minorImageVersion);
    }

    @Override
    @JsonProperty(value="major_subsystem_version")
    @JsonPropertyDescription(value="Specifies the major version number of the subsystem.")
    public Optional<Long> getMajorSubsystemVersion() {
        return Optional.ofNullable(this.majorSubsystemVersion);
    }

    @Override
    @JsonProperty(value="minor_subsystem_version")
    @JsonPropertyDescription(value="Specifies the minor version number of the subsystem.")
    public Optional<Long> getMinorSubsystemVersion() {
        return Optional.ofNullable(this.minorSubsystemVersion);
    }

    @Override
    @JsonProperty(value="win32_version_value_hex")
    @JsonPropertyDescription(value="Specifies the reserved win32 version value.")
    public Optional<String> getWin32VersionValueHex() {
        return Optional.ofNullable(this.win32VersionValueHex);
    }

    @Override
    @JsonProperty(value="size_of_image")
    @JsonPropertyDescription(value="Specifies the size, in bytes, of the image, including all headers, as the image is loaded in memory.")
    public Optional<Long> getSizeOfImage() {
        return Optional.ofNullable(this.sizeOfImage);
    }

    @Override
    @JsonProperty(value="size_of_headers")
    @JsonPropertyDescription(value="Specifies the combined size of the MS-DOS, PE header, and section headers, rounded up a multiple of the value specified in the file_alignment header.")
    public Optional<Long> getSizeOfHeaders() {
        return Optional.ofNullable(this.sizeOfHeaders);
    }

    @Override
    @JsonProperty(value="checksum_hex")
    @JsonPropertyDescription(value="Specifies the checksum of the PE binary.")
    public Optional<String> getChecksumHex() {
        return Optional.ofNullable(this.checksumHex);
    }

    @Override
    @JsonProperty(value="subsystem_hex")
    @JsonPropertyDescription(value="Specifies the subsystem (e.g., GUI, device driver, etc.) that is required to run this image.")
    public Optional<String> getSubsystemHex() {
        return Optional.ofNullable(this.subsystemHex);
    }

    @Override
    @JsonProperty(value="dll_characteristics_hex")
    @JsonPropertyDescription(value="Specifies the flags that characterize the PE binary.")
    public Optional<String> getDllCharacteristicsHex() {
        return Optional.ofNullable(this.dllCharacteristicsHex);
    }

    @Override
    @JsonProperty(value="size_of_stack_reserve")
    @JsonPropertyDescription(value="Specifies the size of the stack to reserve")
    public Optional<Long> getSizeOfStackReserve() {
        return Optional.ofNullable(this.sizeOfStackReserve);
    }

    @Override
    @JsonProperty(value="size_of_stack_commit")
    @JsonPropertyDescription(value="Specifies the size of the stack to commit.")
    public Optional<Long> getSizeOfStackCommit() {
        return Optional.ofNullable(this.sizeOfStackCommit);
    }

    @Override
    @JsonProperty(value="size_of_heap_reserve")
    @JsonPropertyDescription(value="Specifies the size of the local heap space to reserve.")
    public Optional<Long> getSizeOfHeapReserve() {
        return Optional.ofNullable(this.sizeOfHeapReserve);
    }

    @Override
    @JsonProperty(value="size_of_heap_commit")
    @JsonPropertyDescription(value="Specifies the size of the local heap space to commit.")
    public Optional<Long> getSizeOfHeapCommit() {
        return Optional.ofNullable(this.sizeOfHeapCommit);
    }

    @Override
    @JsonProperty(value="loader_flags_hex")
    @JsonPropertyDescription(value="Specifies the reserved loader flags.")
    public Optional<String> getLoaderFlagsHex() {
        return Optional.ofNullable(this.loaderFlagsHex);
    }

    @Override
    @JsonProperty(value="number_of_rva_and_sizes")
    @JsonPropertyDescription(value="Specifies the number of data-directory entries in the remainder of the optional header.")
    public Optional<Long> getNumberOfRvaAndSizes() {
        return Optional.ofNullable(this.numberOfRvaAndSizes);
    }

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies any hashes that were computed for the optional header.")
    public ImmutableMap<String, String> getHashes() {
        return this.hashes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final WindowsPeOptionalHeader withMagicHex(String value) {
        String newValue = Objects.requireNonNull(value, "magicHex");
        if (Objects.equals(this.magicHex, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(newValue, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMagicHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.magicHex, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(value, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorLinkerVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.majorLinkerVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, newValue, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorLinkerVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.majorLinkerVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, value, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorLinkerVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.minorLinkerVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, newValue, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorLinkerVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.minorLinkerVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, value, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfCode(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfCode, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, newValue, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfCode(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfCode, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, value, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfInitializedData(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfInitializedData, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, newValue, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfInitializedData(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfInitializedData, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, value, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfUninitializedData(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfUninitializedData, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, newValue, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfUninitializedData(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfUninitializedData, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, value, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withAddressOfEntryPoint(long value) {
        Long newValue = value;
        if (Objects.equals(this.addressOfEntryPoint, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, newValue, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withAddressOfEntryPoint(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.addressOfEntryPoint, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, value, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withBaseOfCode(long value) {
        Long newValue = value;
        if (Objects.equals(this.baseOfCode, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, newValue, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withBaseOfCode(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.baseOfCode, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, value, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withBaseOfData(long value) {
        Long newValue = value;
        if (Objects.equals(this.baseOfData, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, newValue, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withBaseOfData(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.baseOfData, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, value, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withImageBase(long value) {
        Long newValue = value;
        if (Objects.equals(this.imageBase, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, newValue, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withImageBase(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.imageBase, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, value, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSectionAlignment(long value) {
        Long newValue = value;
        if (Objects.equals(this.sectionAlignment, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, newValue, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSectionAlignment(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sectionAlignment, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, value, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withFileAlignment(long value) {
        Long newValue = value;
        if (Objects.equals(this.fileAlignment, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, newValue, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withFileAlignment(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.fileAlignment, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, value, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorOsVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.majorOsVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, newValue, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorOsVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.majorOsVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, value, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorOsVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.minorOsVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, newValue, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorOsVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.minorOsVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, value, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorImageVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.majorImageVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, newValue, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorImageVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.majorImageVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, value, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorImageVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.minorImageVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, newValue, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorImageVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.minorImageVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, value, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorSubsystemVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.majorSubsystemVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, newValue, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMajorSubsystemVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.majorSubsystemVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, value, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorSubsystemVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.minorSubsystemVersion, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, newValue, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withMinorSubsystemVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.minorSubsystemVersion, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, value, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withWin32VersionValueHex(String value) {
        String newValue = Objects.requireNonNull(value, "win32VersionValueHex");
        if (Objects.equals(this.win32VersionValueHex, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, newValue, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withWin32VersionValueHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.win32VersionValueHex, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, value, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfImage(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfImage, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, newValue, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfImage(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfImage, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, value, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfHeaders(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfHeaders, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, newValue, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfHeaders(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfHeaders, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, value, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withChecksumHex(String value) {
        String newValue = Objects.requireNonNull(value, "checksumHex");
        if (Objects.equals(this.checksumHex, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, newValue, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withChecksumHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.checksumHex, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, value, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSubsystemHex(String value) {
        String newValue = Objects.requireNonNull(value, "subsystemHex");
        if (Objects.equals(this.subsystemHex, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, newValue, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSubsystemHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subsystemHex, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, value, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withDllCharacteristicsHex(String value) {
        String newValue = Objects.requireNonNull(value, "dllCharacteristicsHex");
        if (Objects.equals(this.dllCharacteristicsHex, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, newValue, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withDllCharacteristicsHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dllCharacteristicsHex, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, value, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfStackReserve(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfStackReserve, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, newValue, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfStackReserve(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfStackReserve, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, value, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfStackCommit(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfStackCommit, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, newValue, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfStackCommit(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfStackCommit, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, value, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfHeapReserve(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfHeapReserve, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, newValue, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfHeapReserve(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfHeapReserve, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, value, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfHeapCommit(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfHeapCommit, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, newValue, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withSizeOfHeapCommit(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfHeapCommit, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, value, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withLoaderFlagsHex(String value) {
        String newValue = Objects.requireNonNull(value, "loaderFlagsHex");
        if (Objects.equals(this.loaderFlagsHex, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, newValue, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withLoaderFlagsHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.loaderFlagsHex, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, value, this.numberOfRvaAndSizes, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withNumberOfRvaAndSizes(long value) {
        Long newValue = value;
        if (Objects.equals(this.numberOfRvaAndSizes, newValue)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, newValue, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withNumberOfRvaAndSizes(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.numberOfRvaAndSizes, value)) {
            return this;
        }
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, value, this.hashes, this.customProperties));
    }

    public final WindowsPeOptionalHeader withHashes(Map<String, ? extends String> entries) {
        if (this.hashes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, (ImmutableMap<String, String>)newValue, this.customProperties));
    }

    public final WindowsPeOptionalHeader withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WindowsPeOptionalHeader && this.equalTo((WindowsPeOptionalHeader)another);
    }

    private boolean equalTo(WindowsPeOptionalHeader another) {
        return Objects.equals(this.magicHex, another.magicHex) && Objects.equals(this.majorLinkerVersion, another.majorLinkerVersion) && Objects.equals(this.minorLinkerVersion, another.minorLinkerVersion) && Objects.equals(this.sizeOfCode, another.sizeOfCode) && Objects.equals(this.sizeOfInitializedData, another.sizeOfInitializedData) && Objects.equals(this.sizeOfUninitializedData, another.sizeOfUninitializedData) && Objects.equals(this.addressOfEntryPoint, another.addressOfEntryPoint) && Objects.equals(this.baseOfCode, another.baseOfCode) && Objects.equals(this.baseOfData, another.baseOfData) && Objects.equals(this.imageBase, another.imageBase) && Objects.equals(this.sectionAlignment, another.sectionAlignment) && Objects.equals(this.fileAlignment, another.fileAlignment) && Objects.equals(this.majorOsVersion, another.majorOsVersion) && Objects.equals(this.minorOsVersion, another.minorOsVersion) && Objects.equals(this.majorImageVersion, another.majorImageVersion) && Objects.equals(this.minorImageVersion, another.minorImageVersion) && Objects.equals(this.majorSubsystemVersion, another.majorSubsystemVersion) && Objects.equals(this.minorSubsystemVersion, another.minorSubsystemVersion) && Objects.equals(this.win32VersionValueHex, another.win32VersionValueHex) && Objects.equals(this.sizeOfImage, another.sizeOfImage) && Objects.equals(this.sizeOfHeaders, another.sizeOfHeaders) && Objects.equals(this.checksumHex, another.checksumHex) && Objects.equals(this.subsystemHex, another.subsystemHex) && Objects.equals(this.dllCharacteristicsHex, another.dllCharacteristicsHex) && Objects.equals(this.sizeOfStackReserve, another.sizeOfStackReserve) && Objects.equals(this.sizeOfStackCommit, another.sizeOfStackCommit) && Objects.equals(this.sizeOfHeapReserve, another.sizeOfHeapReserve) && Objects.equals(this.sizeOfHeapCommit, another.sizeOfHeapCommit) && Objects.equals(this.loaderFlagsHex, another.loaderFlagsHex) && Objects.equals(this.numberOfRvaAndSizes, another.numberOfRvaAndSizes) && this.hashes.equals(another.hashes) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.magicHex);
        h += (h << 5) + Objects.hashCode(this.majorLinkerVersion);
        h += (h << 5) + Objects.hashCode(this.minorLinkerVersion);
        h += (h << 5) + Objects.hashCode(this.sizeOfCode);
        h += (h << 5) + Objects.hashCode(this.sizeOfInitializedData);
        h += (h << 5) + Objects.hashCode(this.sizeOfUninitializedData);
        h += (h << 5) + Objects.hashCode(this.addressOfEntryPoint);
        h += (h << 5) + Objects.hashCode(this.baseOfCode);
        h += (h << 5) + Objects.hashCode(this.baseOfData);
        h += (h << 5) + Objects.hashCode(this.imageBase);
        h += (h << 5) + Objects.hashCode(this.sectionAlignment);
        h += (h << 5) + Objects.hashCode(this.fileAlignment);
        h += (h << 5) + Objects.hashCode(this.majorOsVersion);
        h += (h << 5) + Objects.hashCode(this.minorOsVersion);
        h += (h << 5) + Objects.hashCode(this.majorImageVersion);
        h += (h << 5) + Objects.hashCode(this.minorImageVersion);
        h += (h << 5) + Objects.hashCode(this.majorSubsystemVersion);
        h += (h << 5) + Objects.hashCode(this.minorSubsystemVersion);
        h += (h << 5) + Objects.hashCode(this.win32VersionValueHex);
        h += (h << 5) + Objects.hashCode(this.sizeOfImage);
        h += (h << 5) + Objects.hashCode(this.sizeOfHeaders);
        h += (h << 5) + Objects.hashCode(this.checksumHex);
        h += (h << 5) + Objects.hashCode(this.subsystemHex);
        h += (h << 5) + Objects.hashCode(this.dllCharacteristicsHex);
        h += (h << 5) + Objects.hashCode(this.sizeOfStackReserve);
        h += (h << 5) + Objects.hashCode(this.sizeOfStackCommit);
        h += (h << 5) + Objects.hashCode(this.sizeOfHeapReserve);
        h += (h << 5) + Objects.hashCode(this.sizeOfHeapCommit);
        h += (h << 5) + Objects.hashCode(this.loaderFlagsHex);
        h += (h << 5) + Objects.hashCode(this.numberOfRvaAndSizes);
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WindowsPeOptionalHeader").omitNullValues().add("magicHex", (Object)this.magicHex).add("majorLinkerVersion", (Object)this.majorLinkerVersion).add("minorLinkerVersion", (Object)this.minorLinkerVersion).add("sizeOfCode", (Object)this.sizeOfCode).add("sizeOfInitializedData", (Object)this.sizeOfInitializedData).add("sizeOfUninitializedData", (Object)this.sizeOfUninitializedData).add("addressOfEntryPoint", (Object)this.addressOfEntryPoint).add("baseOfCode", (Object)this.baseOfCode).add("baseOfData", (Object)this.baseOfData).add("imageBase", (Object)this.imageBase).add("sectionAlignment", (Object)this.sectionAlignment).add("fileAlignment", (Object)this.fileAlignment).add("majorOsVersion", (Object)this.majorOsVersion).add("minorOsVersion", (Object)this.minorOsVersion).add("majorImageVersion", (Object)this.majorImageVersion).add("minorImageVersion", (Object)this.minorImageVersion).add("majorSubsystemVersion", (Object)this.majorSubsystemVersion).add("minorSubsystemVersion", (Object)this.minorSubsystemVersion).add("win32VersionValueHex", (Object)this.win32VersionValueHex).add("sizeOfImage", (Object)this.sizeOfImage).add("sizeOfHeaders", (Object)this.sizeOfHeaders).add("checksumHex", (Object)this.checksumHex).add("subsystemHex", (Object)this.subsystemHex).add("dllCharacteristicsHex", (Object)this.dllCharacteristicsHex).add("sizeOfStackReserve", (Object)this.sizeOfStackReserve).add("sizeOfStackCommit", (Object)this.sizeOfStackCommit).add("sizeOfHeapReserve", (Object)this.sizeOfHeapReserve).add("sizeOfHeapCommit", (Object)this.sizeOfHeapCommit).add("loaderFlagsHex", (Object)this.loaderFlagsHex).add("numberOfRvaAndSizes", (Object)this.numberOfRvaAndSizes).add("hashes", this.hashes).add("customProperties", this.customProperties).toString();
    }

    private static WindowsPeOptionalHeader validate(WindowsPeOptionalHeader instance) {
        instance.validateEntity();
        return instance;
    }

    public static WindowsPeOptionalHeader copyOf(WindowsPeOptionalHeaderObj instance) {
        if (instance instanceof WindowsPeOptionalHeader) {
            return (WindowsPeOptionalHeader)instance;
        }
        return WindowsPeOptionalHeader.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return WindowsPeOptionalHeader.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"magic_hex", "major_linker_version", "minor_linker_version", "size_of_code", "size_of_initialized_data", "size_of_uninitialized_data", "address_of_entry_point", "base_of_code", "base_of_data", "image_base", "section_alignment", "file_alignment", "major_os_version", "minor_os_version", "major_image_version", "minor_image_version", "major_subsystem_version", "minor_subsystem_version", "win32_version_value_hex", "size_of_image", "size_of_headers", "checksum_hex", "subsystem_hex", "dll_characteristics_hex", "size_of_stack_reserve", "size_of_stack_commit", "size_of_heap_reserve", "size_of_heap_commit", "loader_flags_hex", "number_of_rva_and_sizes", "hashes"})
    @Generated(from="WindowsPeOptionalHeaderObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String magicHex;
        @Nullable
        private Long majorLinkerVersion;
        @Nullable
        private Long minorLinkerVersion;
        @Nullable
        private Long sizeOfCode;
        @Nullable
        private Long sizeOfInitializedData;
        @Nullable
        private Long sizeOfUninitializedData;
        @Nullable
        private Long addressOfEntryPoint;
        @Nullable
        private Long baseOfCode;
        @Nullable
        private Long baseOfData;
        @Nullable
        private Long imageBase;
        @Nullable
        private Long sectionAlignment;
        @Nullable
        private Long fileAlignment;
        @Nullable
        private Long majorOsVersion;
        @Nullable
        private Long minorOsVersion;
        @Nullable
        private Long majorImageVersion;
        @Nullable
        private Long minorImageVersion;
        @Nullable
        private Long majorSubsystemVersion;
        @Nullable
        private Long minorSubsystemVersion;
        @Nullable
        private String win32VersionValueHex;
        @Nullable
        private Long sizeOfImage;
        @Nullable
        private Long sizeOfHeaders;
        @Nullable
        private String checksumHex;
        @Nullable
        private String subsystemHex;
        @Nullable
        private String dllCharacteristicsHex;
        @Nullable
        private Long sizeOfStackReserve;
        @Nullable
        private Long sizeOfStackCommit;
        @Nullable
        private Long sizeOfHeapReserve;
        @Nullable
        private Long sizeOfHeapCommit;
        @Nullable
        private String loaderFlagsHex;
        @Nullable
        private Long numberOfRvaAndSizes;
        private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WindowsPeOptionalHeaderObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof WindowsPeOptionalHeaderObj) {
                Optional<Long> sizeOfStackCommitOptional;
                Optional<Long> numberOfRvaAndSizesOptional;
                Optional<Long> addressOfEntryPointOptional;
                Optional<Long> minorLinkerVersionOptional;
                Optional<Long> sizeOfUninitializedDataOptional;
                Optional<String> win32VersionValueHexOptional;
                Optional<String> checksumHexOptional;
                Optional<Long> sizeOfHeapCommitOptional;
                Optional<Long> majorOsVersionOptional;
                Optional<Long> sizeOfImageOptional;
                Optional<Long> fileAlignmentOptional;
                Optional<Long> sizeOfHeapReserveOptional;
                Optional<Long> sectionAlignmentOptional;
                Optional<String> loaderFlagsHexOptional;
                Optional<Long> imageBaseOptional;
                Optional<String> dllCharacteristicsHexOptional;
                Optional<String> subsystemHexOptional;
                Optional<Long> minorOsVersionOptional;
                Optional<Long> sizeOfInitializedDataOptional;
                Optional<Long> majorLinkerVersionOptional;
                Optional<Long> sizeOfHeadersOptional;
                Optional<Long> minorImageVersionOptional;
                Optional<Long> majorImageVersionOptional;
                Optional<Long> baseOfDataOptional;
                Optional<Long> minorSubsystemVersionOptional;
                Optional<Long> sizeOfCodeOptional;
                Optional<Long> sizeOfStackReserveOptional;
                Optional<Long> majorSubsystemVersionOptional;
                instance = (WindowsPeOptionalHeaderObj)object;
                Optional<Long> baseOfCodeOptional = instance.getBaseOfCode();
                if (baseOfCodeOptional.isPresent()) {
                    this.baseOfCode(baseOfCodeOptional);
                }
                if ((majorSubsystemVersionOptional = instance.getMajorSubsystemVersion()).isPresent()) {
                    this.majorSubsystemVersion(majorSubsystemVersionOptional);
                }
                if ((sizeOfStackReserveOptional = instance.getSizeOfStackReserve()).isPresent()) {
                    this.sizeOfStackReserve(sizeOfStackReserveOptional);
                }
                if ((sizeOfCodeOptional = instance.getSizeOfCode()).isPresent()) {
                    this.sizeOfCode(sizeOfCodeOptional);
                }
                if ((minorSubsystemVersionOptional = instance.getMinorSubsystemVersion()).isPresent()) {
                    this.minorSubsystemVersion(minorSubsystemVersionOptional);
                }
                if ((baseOfDataOptional = instance.getBaseOfData()).isPresent()) {
                    this.baseOfData(baseOfDataOptional);
                }
                if ((majorImageVersionOptional = instance.getMajorImageVersion()).isPresent()) {
                    this.majorImageVersion(majorImageVersionOptional);
                }
                if ((minorImageVersionOptional = instance.getMinorImageVersion()).isPresent()) {
                    this.minorImageVersion(minorImageVersionOptional);
                }
                if ((sizeOfHeadersOptional = instance.getSizeOfHeaders()).isPresent()) {
                    this.sizeOfHeaders(sizeOfHeadersOptional);
                }
                if ((majorLinkerVersionOptional = instance.getMajorLinkerVersion()).isPresent()) {
                    this.majorLinkerVersion(majorLinkerVersionOptional);
                }
                if ((sizeOfInitializedDataOptional = instance.getSizeOfInitializedData()).isPresent()) {
                    this.sizeOfInitializedData(sizeOfInitializedDataOptional);
                }
                if ((minorOsVersionOptional = instance.getMinorOsVersion()).isPresent()) {
                    this.minorOsVersion(minorOsVersionOptional);
                }
                if ((subsystemHexOptional = instance.getSubsystemHex()).isPresent()) {
                    this.subsystemHex(subsystemHexOptional);
                }
                if ((dllCharacteristicsHexOptional = instance.getDllCharacteristicsHex()).isPresent()) {
                    this.dllCharacteristicsHex(dllCharacteristicsHexOptional);
                }
                if ((imageBaseOptional = instance.getImageBase()).isPresent()) {
                    this.imageBase(imageBaseOptional);
                }
                if ((loaderFlagsHexOptional = instance.getLoaderFlagsHex()).isPresent()) {
                    this.loaderFlagsHex(loaderFlagsHexOptional);
                }
                if ((sectionAlignmentOptional = instance.getSectionAlignment()).isPresent()) {
                    this.sectionAlignment(sectionAlignmentOptional);
                }
                if ((sizeOfHeapReserveOptional = instance.getSizeOfHeapReserve()).isPresent()) {
                    this.sizeOfHeapReserve(sizeOfHeapReserveOptional);
                }
                if ((fileAlignmentOptional = instance.getFileAlignment()).isPresent()) {
                    this.fileAlignment(fileAlignmentOptional);
                }
                if ((sizeOfImageOptional = instance.getSizeOfImage()).isPresent()) {
                    this.sizeOfImage(sizeOfImageOptional);
                }
                if ((majorOsVersionOptional = instance.getMajorOsVersion()).isPresent()) {
                    this.majorOsVersion(majorOsVersionOptional);
                }
                if ((sizeOfHeapCommitOptional = instance.getSizeOfHeapCommit()).isPresent()) {
                    this.sizeOfHeapCommit(sizeOfHeapCommitOptional);
                }
                if ((checksumHexOptional = instance.getChecksumHex()).isPresent()) {
                    this.checksumHex(checksumHexOptional);
                }
                if ((win32VersionValueHexOptional = instance.getWin32VersionValueHex()).isPresent()) {
                    this.win32VersionValueHex(win32VersionValueHexOptional);
                }
                if ((sizeOfUninitializedDataOptional = instance.getSizeOfUninitializedData()).isPresent()) {
                    this.sizeOfUninitializedData(sizeOfUninitializedDataOptional);
                }
                if ((minorLinkerVersionOptional = instance.getMinorLinkerVersion()).isPresent()) {
                    this.minorLinkerVersion(minorLinkerVersionOptional);
                }
                this.putAllHashes(instance.getHashes());
                Optional<String> magicHexOptional = instance.getMagicHex();
                if (magicHexOptional.isPresent()) {
                    this.magicHex(magicHexOptional);
                }
                if ((addressOfEntryPointOptional = instance.getAddressOfEntryPoint()).isPresent()) {
                    this.addressOfEntryPoint(addressOfEntryPointOptional);
                }
                if ((numberOfRvaAndSizesOptional = instance.getNumberOfRvaAndSizes()).isPresent()) {
                    this.numberOfRvaAndSizes(numberOfRvaAndSizesOptional);
                }
                if ((sizeOfStackCommitOptional = instance.getSizeOfStackCommit()).isPresent()) {
                    this.sizeOfStackCommit(sizeOfStackCommitOptional);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
        }

        @CanIgnoreReturnValue
        public final Builder magicHex(String magicHex) {
            this.magicHex = Objects.requireNonNull(magicHex, "magicHex");
            return this;
        }

        @JsonProperty(value="magic_hex")
        @JsonPropertyDescription(value="Specifies the unsigned Optional<Integer> that indicates the type of the PE binary.")
        @CanIgnoreReturnValue
        public final Builder magicHex(Optional<String> magicHex) {
            this.magicHex = magicHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder majorLinkerVersion(long majorLinkerVersion) {
            this.majorLinkerVersion = majorLinkerVersion;
            return this;
        }

        @JsonProperty(value="major_linker_version")
        @JsonPropertyDescription(value="Specifies the linker major version number.")
        @CanIgnoreReturnValue
        public final Builder majorLinkerVersion(Optional<Long> majorLinkerVersion) {
            this.majorLinkerVersion = majorLinkerVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minorLinkerVersion(long minorLinkerVersion) {
            this.minorLinkerVersion = minorLinkerVersion;
            return this;
        }

        @JsonProperty(value="minor_linker_version")
        @JsonPropertyDescription(value="Specifies the linker minor version number.")
        @CanIgnoreReturnValue
        public final Builder minorLinkerVersion(Optional<Long> minorLinkerVersion) {
            this.minorLinkerVersion = minorLinkerVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfCode(long sizeOfCode) {
            this.sizeOfCode = sizeOfCode;
            return this;
        }

        @JsonProperty(value="size_of_code")
        @JsonPropertyDescription(value="Specifies the size of the code (text) section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
        @CanIgnoreReturnValue
        public final Builder sizeOfCode(Optional<Long> sizeOfCode) {
            this.sizeOfCode = sizeOfCode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfInitializedData(long sizeOfInitializedData) {
            this.sizeOfInitializedData = sizeOfInitializedData;
            return this;
        }

        @JsonProperty(value="size_of_initialized_data")
        @JsonPropertyDescription(value="Specifies the size of the initialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
        @CanIgnoreReturnValue
        public final Builder sizeOfInitializedData(Optional<Long> sizeOfInitializedData) {
            this.sizeOfInitializedData = sizeOfInitializedData.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfUninitializedData(long sizeOfUninitializedData) {
            this.sizeOfUninitializedData = sizeOfUninitializedData;
            return this;
        }

        @JsonProperty(value="size_of_uninitialized_data")
        @JsonPropertyDescription(value="Specifies the size of the uninitialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
        @CanIgnoreReturnValue
        public final Builder sizeOfUninitializedData(Optional<Long> sizeOfUninitializedData) {
            this.sizeOfUninitializedData = sizeOfUninitializedData.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addressOfEntryPoint(long addressOfEntryPoint) {
            this.addressOfEntryPoint = addressOfEntryPoint;
            return this;
        }

        @JsonProperty(value="address_of_entry_point")
        @JsonPropertyDescription(value="Specifies the address of the entry point relative to the image base when the executable is loaded into memory.")
        @CanIgnoreReturnValue
        public final Builder addressOfEntryPoint(Optional<Long> addressOfEntryPoint) {
            this.addressOfEntryPoint = addressOfEntryPoint.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseOfCode(long baseOfCode) {
            this.baseOfCode = baseOfCode;
            return this;
        }

        @JsonProperty(value="base_of_code")
        @JsonPropertyDescription(value="Specifies the address that is relative to the image base of the beginning-of-code section when it is loaded into memory.")
        @CanIgnoreReturnValue
        public final Builder baseOfCode(Optional<Long> baseOfCode) {
            this.baseOfCode = baseOfCode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseOfData(long baseOfData) {
            this.baseOfData = baseOfData;
            return this;
        }

        @JsonProperty(value="base_of_data")
        @JsonPropertyDescription(value="Specifies the address that is relative to the image base of the beginning-of-data section when it is loaded into memory.")
        @CanIgnoreReturnValue
        public final Builder baseOfData(Optional<Long> baseOfData) {
            this.baseOfData = baseOfData.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder imageBase(long imageBase) {
            this.imageBase = imageBase;
            return this;
        }

        @JsonProperty(value="image_base")
        @JsonPropertyDescription(value="Specifies the preferred address of the first byte of the image when loaded into memory.")
        @CanIgnoreReturnValue
        public final Builder imageBase(Optional<Long> imageBase) {
            this.imageBase = imageBase.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sectionAlignment(long sectionAlignment) {
            this.sectionAlignment = sectionAlignment;
            return this;
        }

        @JsonProperty(value="section_alignment")
        @JsonPropertyDescription(value="Specifies the alignment (in bytes) of PE sections when they are loaded into memory.")
        @CanIgnoreReturnValue
        public final Builder sectionAlignment(Optional<Long> sectionAlignment) {
            this.sectionAlignment = sectionAlignment.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fileAlignment(long fileAlignment) {
            this.fileAlignment = fileAlignment;
            return this;
        }

        @JsonProperty(value="file_alignment")
        @JsonPropertyDescription(value="Specifies the factor (in bytes) that is used to align the raw data of sections in the image file.")
        @CanIgnoreReturnValue
        public final Builder fileAlignment(Optional<Long> fileAlignment) {
            this.fileAlignment = fileAlignment.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder majorOsVersion(long majorOsVersion) {
            this.majorOsVersion = majorOsVersion;
            return this;
        }

        @JsonProperty(value="major_os_version")
        @JsonPropertyDescription(value="Specifies the major version number of the required operating system.")
        @CanIgnoreReturnValue
        public final Builder majorOsVersion(Optional<Long> majorOsVersion) {
            this.majorOsVersion = majorOsVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minorOsVersion(long minorOsVersion) {
            this.minorOsVersion = minorOsVersion;
            return this;
        }

        @JsonProperty(value="minor_os_version")
        @JsonPropertyDescription(value="Specifies the minor version number of the required operating system.")
        @CanIgnoreReturnValue
        public final Builder minorOsVersion(Optional<Long> minorOsVersion) {
            this.minorOsVersion = minorOsVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder majorImageVersion(long majorImageVersion) {
            this.majorImageVersion = majorImageVersion;
            return this;
        }

        @JsonProperty(value="major_image_version")
        @JsonPropertyDescription(value="Specifies the major version number of the image.")
        @CanIgnoreReturnValue
        public final Builder majorImageVersion(Optional<Long> majorImageVersion) {
            this.majorImageVersion = majorImageVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minorImageVersion(long minorImageVersion) {
            this.minorImageVersion = minorImageVersion;
            return this;
        }

        @JsonProperty(value="minor_image_version")
        @JsonPropertyDescription(value="Specifies the minor version number of the image.")
        @CanIgnoreReturnValue
        public final Builder minorImageVersion(Optional<Long> minorImageVersion) {
            this.minorImageVersion = minorImageVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder majorSubsystemVersion(long majorSubsystemVersion) {
            this.majorSubsystemVersion = majorSubsystemVersion;
            return this;
        }

        @JsonProperty(value="major_subsystem_version")
        @JsonPropertyDescription(value="Specifies the major version number of the subsystem.")
        @CanIgnoreReturnValue
        public final Builder majorSubsystemVersion(Optional<Long> majorSubsystemVersion) {
            this.majorSubsystemVersion = majorSubsystemVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minorSubsystemVersion(long minorSubsystemVersion) {
            this.minorSubsystemVersion = minorSubsystemVersion;
            return this;
        }

        @JsonProperty(value="minor_subsystem_version")
        @JsonPropertyDescription(value="Specifies the minor version number of the subsystem.")
        @CanIgnoreReturnValue
        public final Builder minorSubsystemVersion(Optional<Long> minorSubsystemVersion) {
            this.minorSubsystemVersion = minorSubsystemVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder win32VersionValueHex(String win32VersionValueHex) {
            this.win32VersionValueHex = Objects.requireNonNull(win32VersionValueHex, "win32VersionValueHex");
            return this;
        }

        @JsonProperty(value="win32_version_value_hex")
        @JsonPropertyDescription(value="Specifies the reserved win32 version value.")
        @CanIgnoreReturnValue
        public final Builder win32VersionValueHex(Optional<String> win32VersionValueHex) {
            this.win32VersionValueHex = win32VersionValueHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfImage(long sizeOfImage) {
            this.sizeOfImage = sizeOfImage;
            return this;
        }

        @JsonProperty(value="size_of_image")
        @JsonPropertyDescription(value="Specifies the size, in bytes, of the image, including all headers, as the image is loaded in memory.")
        @CanIgnoreReturnValue
        public final Builder sizeOfImage(Optional<Long> sizeOfImage) {
            this.sizeOfImage = sizeOfImage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfHeaders(long sizeOfHeaders) {
            this.sizeOfHeaders = sizeOfHeaders;
            return this;
        }

        @JsonProperty(value="size_of_headers")
        @JsonPropertyDescription(value="Specifies the combined size of the MS-DOS, PE header, and section headers, rounded up a multiple of the value specified in the file_alignment header.")
        @CanIgnoreReturnValue
        public final Builder sizeOfHeaders(Optional<Long> sizeOfHeaders) {
            this.sizeOfHeaders = sizeOfHeaders.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder checksumHex(String checksumHex) {
            this.checksumHex = Objects.requireNonNull(checksumHex, "checksumHex");
            return this;
        }

        @JsonProperty(value="checksum_hex")
        @JsonPropertyDescription(value="Specifies the checksum of the PE binary.")
        @CanIgnoreReturnValue
        public final Builder checksumHex(Optional<String> checksumHex) {
            this.checksumHex = checksumHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subsystemHex(String subsystemHex) {
            this.subsystemHex = Objects.requireNonNull(subsystemHex, "subsystemHex");
            return this;
        }

        @JsonProperty(value="subsystem_hex")
        @JsonPropertyDescription(value="Specifies the subsystem (e.g., GUI, device driver, etc.) that is required to run this image.")
        @CanIgnoreReturnValue
        public final Builder subsystemHex(Optional<String> subsystemHex) {
            this.subsystemHex = subsystemHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dllCharacteristicsHex(String dllCharacteristicsHex) {
            this.dllCharacteristicsHex = Objects.requireNonNull(dllCharacteristicsHex, "dllCharacteristicsHex");
            return this;
        }

        @JsonProperty(value="dll_characteristics_hex")
        @JsonPropertyDescription(value="Specifies the flags that characterize the PE binary.")
        @CanIgnoreReturnValue
        public final Builder dllCharacteristicsHex(Optional<String> dllCharacteristicsHex) {
            this.dllCharacteristicsHex = dllCharacteristicsHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfStackReserve(long sizeOfStackReserve) {
            this.sizeOfStackReserve = sizeOfStackReserve;
            return this;
        }

        @JsonProperty(value="size_of_stack_reserve")
        @JsonPropertyDescription(value="Specifies the size of the stack to reserve")
        @CanIgnoreReturnValue
        public final Builder sizeOfStackReserve(Optional<Long> sizeOfStackReserve) {
            this.sizeOfStackReserve = sizeOfStackReserve.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfStackCommit(long sizeOfStackCommit) {
            this.sizeOfStackCommit = sizeOfStackCommit;
            return this;
        }

        @JsonProperty(value="size_of_stack_commit")
        @JsonPropertyDescription(value="Specifies the size of the stack to commit.")
        @CanIgnoreReturnValue
        public final Builder sizeOfStackCommit(Optional<Long> sizeOfStackCommit) {
            this.sizeOfStackCommit = sizeOfStackCommit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfHeapReserve(long sizeOfHeapReserve) {
            this.sizeOfHeapReserve = sizeOfHeapReserve;
            return this;
        }

        @JsonProperty(value="size_of_heap_reserve")
        @JsonPropertyDescription(value="Specifies the size of the local heap space to reserve.")
        @CanIgnoreReturnValue
        public final Builder sizeOfHeapReserve(Optional<Long> sizeOfHeapReserve) {
            this.sizeOfHeapReserve = sizeOfHeapReserve.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfHeapCommit(long sizeOfHeapCommit) {
            this.sizeOfHeapCommit = sizeOfHeapCommit;
            return this;
        }

        @JsonProperty(value="size_of_heap_commit")
        @JsonPropertyDescription(value="Specifies the size of the local heap space to commit.")
        @CanIgnoreReturnValue
        public final Builder sizeOfHeapCommit(Optional<Long> sizeOfHeapCommit) {
            this.sizeOfHeapCommit = sizeOfHeapCommit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loaderFlagsHex(String loaderFlagsHex) {
            this.loaderFlagsHex = Objects.requireNonNull(loaderFlagsHex, "loaderFlagsHex");
            return this;
        }

        @JsonProperty(value="loader_flags_hex")
        @JsonPropertyDescription(value="Specifies the reserved loader flags.")
        @CanIgnoreReturnValue
        public final Builder loaderFlagsHex(Optional<String> loaderFlagsHex) {
            this.loaderFlagsHex = loaderFlagsHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numberOfRvaAndSizes(long numberOfRvaAndSizes) {
            this.numberOfRvaAndSizes = numberOfRvaAndSizes;
            return this;
        }

        @JsonProperty(value="number_of_rva_and_sizes")
        @JsonPropertyDescription(value="Specifies the number of data-directory entries in the remainder of the optional header.")
        @CanIgnoreReturnValue
        public final Builder numberOfRvaAndSizes(Optional<Long> numberOfRvaAndSizes) {
            this.numberOfRvaAndSizes = numberOfRvaAndSizes.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(String key, String value) {
            this.hashes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(Map.Entry<String, ? extends String> entry) {
            this.hashes.put(entry);
            return this;
        }

        @JsonProperty(value="hashes")
        @JsonPropertyDescription(value="Specifies any hashes that were computed for the optional header.")
        @CanIgnoreReturnValue
        public final Builder hashes(Map<String, ? extends String> entries) {
            this.hashes = ImmutableMap.builder();
            return this.putAllHashes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHashes(Map<String, ? extends String> entries) {
            this.hashes.putAll(entries);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public WindowsPeOptionalHeader build() {
            return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(this.magicHex, this.majorLinkerVersion, this.minorLinkerVersion, this.sizeOfCode, this.sizeOfInitializedData, this.sizeOfUninitializedData, this.addressOfEntryPoint, this.baseOfCode, this.baseOfData, this.imageBase, this.sectionAlignment, this.fileAlignment, this.majorOsVersion, this.minorOsVersion, this.majorImageVersion, this.minorImageVersion, this.majorSubsystemVersion, this.minorSubsystemVersion, this.win32VersionValueHex, this.sizeOfImage, this.sizeOfHeaders, this.checksumHex, this.subsystemHex, this.dllCharacteristicsHex, this.sizeOfStackReserve, this.sizeOfStackCommit, this.sizeOfHeapReserve, this.sizeOfHeapCommit, this.loaderFlagsHex, this.numberOfRvaAndSizes, this.hashes.build(), this.customProperties.build()));
        }
    }
}

