/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.PositiveOrZero;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.WindowsPeOptionalHeader;
import security.whisper.javastix.validation.GenericValidation;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.vocabulary.vocabularies.HashingAlgorithms;

@JsonSerialize(as=WindowsPeOptionalHeader.class)
@JsonDeserialize(builder=WindowsPeOptionalHeader.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"magic_hex", "major_linker_version", "minor_linker_version", "size_of_code", "size_of_initialized_data", "size_of_uninitialized_data", "address_of_entry_point", "base_of_code", "base_of_data", "image_base", "section_alignment", "file_alignment", "major_os_version", "minor_os_version", "major_image_version", "minor_image_version", "major_subsystem_version", "minor_subsystem_version", "win32_version_value_hex", "size_of_image", "size_of_headers", "checksum_hex", "subsystem_hex", "dll_characteristics_hex", "size_of_stack_reserve", "size_of_stack_commit", "size_of_heap_reserve", "size_of_heap_commit", "loader_flags_hex", "number_of_rva_and_sizes", "hashes"})
@BusinessRule(ifExp="true", thenExp="getMagicHex().isPresent() == true || getMajorLinkerVersion().isPresent() == true || getMinorLinkerVersion().isPresent() == true || getSizeOfCode().isPresent() == true || getSizeOfInitializedData().isPresent() == true || getSizeOfUninitializedData().isPresent() == true || getAddressOfEntryPoint().isPresent() == true || getBaseOfCode().isPresent() == true || getBaseOfData().isPresent() == true || getImageBase().isPresent() == true || getSectionAlignment().isPresent() == true || getFileAlignment().isPresent() == true || getMajorOsVersion().isPresent() == true || getMinorOsVersion().isPresent() == true || getMajorImageVersion().isPresent() == true || getMinorImageVersion().isPresent() == true || getMajorSubsystemVersion().isPresent() == true || getMinorSubsystemVersion().isPresent() == true || getWin32VersionValueHex().isPresent() == true || getSizeOfImage().isPresent() == true || getSizeOfHeaders().isPresent() == true || getChecksumHex().isPresent() == true || getSubsystemHex().isPresent() == true || getDllCharacteristicsHex().isPresent() == true || getSizeOfStackReserve().isPresent() == true || getSizeOfStackCommit().isPresent() == true || getSizeOfHeapReserve().isPresent() == true || getSizeOfHeapCommit().isPresent() == true || getLoaderFlagsHex().isPresent() == true || getNumberOfRvaAndSizes().isPresent() == true || getHashes().isEmpty() == true", errorMessage="At least 1 field must be used in Windows Pe Extension Optional Header Object.")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Obj"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true, depluralizeDictionary={"hash:hashes"})
public interface WindowsPeOptionalHeaderObj
extends GenericValidation,
StixCustomProperties,
Serializable {
    @JsonProperty(value="magic_hex")
    @JsonPropertyDescription(value="Specifies the unsigned Optional<Integer> that indicates the type of the PE binary.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getMagicHex();

    @JsonProperty(value="major_linker_version")
    @JsonPropertyDescription(value="Specifies the linker major version number.")
    public Optional<Long> getMajorLinkerVersion();

    @JsonProperty(value="minor_linker_version")
    @JsonPropertyDescription(value="Specifies the linker minor version number.")
    public Optional<Long> getMinorLinkerVersion();

    @JsonProperty(value="size_of_code")
    @JsonPropertyDescription(value="Specifies the size of the code (text) section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public Optional<@PositiveOrZero Long> getSizeOfCode();

    @JsonProperty(value="size_of_initialized_data")
    @JsonPropertyDescription(value="Specifies the size of the initialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public Optional<@PositiveOrZero Long> getSizeOfInitializedData();

    @JsonProperty(value="size_of_uninitialized_data")
    @JsonPropertyDescription(value="Specifies the size of the uninitialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public Optional<@PositiveOrZero Long> getSizeOfUninitializedData();

    @JsonProperty(value="address_of_entry_point")
    @JsonPropertyDescription(value="Specifies the address of the entry point relative to the image base when the executable is loaded into memory.")
    public Optional<Long> getAddressOfEntryPoint();

    @JsonProperty(value="base_of_code")
    @JsonPropertyDescription(value="Specifies the address that is relative to the image base of the beginning-of-code section when it is loaded into memory.")
    public Optional<Long> getBaseOfCode();

    @JsonProperty(value="base_of_data")
    @JsonPropertyDescription(value="Specifies the address that is relative to the image base of the beginning-of-data section when it is loaded into memory.")
    public Optional<Long> getBaseOfData();

    @JsonProperty(value="image_base")
    @JsonPropertyDescription(value="Specifies the preferred address of the first byte of the image when loaded into memory.")
    public Optional<Long> getImageBase();

    @JsonProperty(value="section_alignment")
    @JsonPropertyDescription(value="Specifies the alignment (in bytes) of PE sections when they are loaded into memory.")
    public Optional<Long> getSectionAlignment();

    @JsonProperty(value="file_alignment")
    @JsonPropertyDescription(value="Specifies the factor (in bytes) that is used to align the raw data of sections in the image file.")
    public Optional<Long> getFileAlignment();

    @JsonProperty(value="major_os_version")
    @JsonPropertyDescription(value="Specifies the major version number of the required operating system.")
    public Optional<Long> getMajorOsVersion();

    @JsonProperty(value="minor_os_version")
    @JsonPropertyDescription(value="Specifies the minor version number of the required operating system.")
    public Optional<Long> getMinorOsVersion();

    @JsonProperty(value="major_image_version")
    @JsonPropertyDescription(value="Specifies the major version number of the image.")
    public Optional<Long> getMajorImageVersion();

    @JsonProperty(value="minor_image_version")
    @JsonPropertyDescription(value="Specifies the minor version number of the image.")
    public Optional<Long> getMinorImageVersion();

    @JsonProperty(value="major_subsystem_version")
    @JsonPropertyDescription(value="Specifies the major version number of the subsystem.")
    public Optional<Long> getMajorSubsystemVersion();

    @JsonProperty(value="minor_subsystem_version")
    @JsonPropertyDescription(value="Specifies the minor version number of the subsystem.")
    public Optional<Long> getMinorSubsystemVersion();

    @JsonProperty(value="win32_version_value_hex")
    @JsonPropertyDescription(value="Specifies the reserved win32 version value.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getWin32VersionValueHex();

    @JsonProperty(value="size_of_image")
    @JsonPropertyDescription(value="Specifies the size, in bytes, of the image, including all headers, as the image is loaded in memory.")
    public Optional<@PositiveOrZero Long> getSizeOfImage();

    @JsonProperty(value="size_of_headers")
    @JsonPropertyDescription(value="Specifies the combined size of the MS-DOS, PE header, and section headers, rounded up a multiple of the value specified in the file_alignment header.")
    public Optional<@PositiveOrZero Long> getSizeOfHeaders();

    @JsonProperty(value="checksum_hex")
    @JsonPropertyDescription(value="Specifies the checksum of the PE binary.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getChecksumHex();

    @JsonProperty(value="subsystem_hex")
    @JsonPropertyDescription(value="Specifies the subsystem (e.g., GUI, device driver, etc.) that is required to run this image.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getSubsystemHex();

    @JsonProperty(value="dll_characteristics_hex")
    @JsonPropertyDescription(value="Specifies the flags that characterize the PE binary.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getDllCharacteristicsHex();

    @JsonProperty(value="size_of_stack_reserve")
    @JsonPropertyDescription(value="Specifies the size of the stack to reserve")
    public Optional<@PositiveOrZero Long> getSizeOfStackReserve();

    @JsonProperty(value="size_of_stack_commit")
    @JsonPropertyDescription(value="Specifies the size of the stack to commit.")
    public Optional<@PositiveOrZero Long> getSizeOfStackCommit();

    @JsonProperty(value="size_of_heap_reserve")
    @JsonPropertyDescription(value="Specifies the size of the local heap space to reserve.")
    public Optional<@PositiveOrZero Long> getSizeOfHeapReserve();

    @JsonProperty(value="size_of_heap_commit")
    @JsonPropertyDescription(value="Specifies the size of the local heap space to commit.")
    public Optional<@PositiveOrZero Long> getSizeOfHeapCommit();

    @JsonProperty(value="loader_flags_hex")
    @JsonPropertyDescription(value="Specifies the reserved loader flags.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getLoaderFlagsHex();

    @JsonProperty(value="number_of_rva_and_sizes")
    @JsonPropertyDescription(value="Specifies the number of data-directory entries in the remainder of the optional header.")
    public Optional<Long> getNumberOfRvaAndSizes();

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies any hashes that were computed for the optional header.")
    public Map<@Length(min=3, max=256) @HashingVocab(value=HashingAlgorithms.class) String, String> getHashes();
}

