/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.WindowsPeSectionObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WindowsPeSectionObj", generator="Immutables")
@Immutable
public final class WindowsPeSection
implements WindowsPeSectionObj {
    @Nullable
    private final String name;
    @Nullable
    private final Long size;
    @Nullable
    private final Float entropy;
    private final ImmutableMap<String, String> hashes;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private WindowsPeSection(@Nullable String name, @Nullable Long size, @Nullable Float entropy, ImmutableMap<String, String> hashes, ImmutableMap<String, Object> customProperties) {
        this.name = name;
        this.size = size;
        this.entropy = entropy;
        this.hashes = hashes;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the section.")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="size")
    @JsonPropertyDescription(value="Specifies the size of the section, in bytes.")
    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    @Override
    @JsonProperty(value="entropy")
    @JsonPropertyDescription(value="Specifies the calculated entropy for the section, as calculated using the Shannon algorithm.")
    public Optional<Float> getEntropy() {
        return Optional.ofNullable(this.entropy);
    }

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies any hashes computed over the section.")
    public ImmutableMap<String, String> getHashes() {
        return this.hashes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final WindowsPeSection withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return WindowsPeSection.validate(new WindowsPeSection(newValue, this.size, this.entropy, this.hashes, this.customProperties));
    }

    public final WindowsPeSection withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return WindowsPeSection.validate(new WindowsPeSection(value, this.size, this.entropy, this.hashes, this.customProperties));
    }

    public final WindowsPeSection withSize(long value) {
        Long newValue = value;
        if (Objects.equals(this.size, newValue)) {
            return this;
        }
        return WindowsPeSection.validate(new WindowsPeSection(this.name, newValue, this.entropy, this.hashes, this.customProperties));
    }

    public final WindowsPeSection withSize(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return WindowsPeSection.validate(new WindowsPeSection(this.name, value, this.entropy, this.hashes, this.customProperties));
    }

    public final WindowsPeSection withEntropy(float value) {
        Float newValue = Float.valueOf(value);
        if (Objects.equals(this.entropy, newValue)) {
            return this;
        }
        return WindowsPeSection.validate(new WindowsPeSection(this.name, this.size, newValue, this.hashes, this.customProperties));
    }

    public final WindowsPeSection withEntropy(Optional<Float> optional) {
        Float value = optional.orElse(null);
        if (Objects.equals(this.entropy, value)) {
            return this;
        }
        return WindowsPeSection.validate(new WindowsPeSection(this.name, this.size, value, this.hashes, this.customProperties));
    }

    public final WindowsPeSection withHashes(Map<String, ? extends String> entries) {
        if (this.hashes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsPeSection.validate(new WindowsPeSection(this.name, this.size, this.entropy, (ImmutableMap<String, String>)newValue, this.customProperties));
    }

    public final WindowsPeSection withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsPeSection.validate(new WindowsPeSection(this.name, this.size, this.entropy, this.hashes, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WindowsPeSection && this.equalTo((WindowsPeSection)another);
    }

    private boolean equalTo(WindowsPeSection another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.size, another.size) && Objects.equals(this.entropy, another.entropy) && this.hashes.equals(another.hashes) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.size);
        h += (h << 5) + Objects.hashCode(this.entropy);
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WindowsPeSection").omitNullValues().add("name", (Object)this.name).add("size", (Object)this.size).add("entropy", (Object)this.entropy).add("hashes", this.hashes).add("customProperties", this.customProperties).toString();
    }

    private static WindowsPeSection validate(WindowsPeSection instance) {
        instance.validateEntity();
        return instance;
    }

    public static WindowsPeSection copyOf(WindowsPeSectionObj instance) {
        if (instance instanceof WindowsPeSection) {
            return (WindowsPeSection)instance;
        }
        return WindowsPeSection.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return WindowsPeSection.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"name", "size", "entropy", "hashes"})
    @Generated(from="WindowsPeSectionObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private Long size;
        @Nullable
        private Float entropy;
        private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WindowsPeSectionObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof WindowsPeSectionObj) {
                Optional<Long> sizeOptional;
                instance = (WindowsPeSectionObj)object;
                Optional<String> nameOptional = instance.getName();
                if (nameOptional.isPresent()) {
                    this.name(nameOptional);
                }
                this.putAllHashes(instance.getHashes());
                Optional<Float> entropyOptional = instance.getEntropy();
                if (entropyOptional.isPresent()) {
                    this.entropy(entropyOptional);
                }
                if ((sizeOptional = instance.getSize()).isPresent()) {
                    this.size(sizeOptional);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="name")
        @JsonPropertyDescription(value="Specifies the name of the section.")
        @CanIgnoreReturnValue
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder size(long size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="size")
        @JsonPropertyDescription(value="Specifies the size of the section, in bytes.")
        @CanIgnoreReturnValue
        public final Builder size(Optional<Long> size) {
            this.size = size.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entropy(float entropy) {
            this.entropy = Float.valueOf(entropy);
            return this;
        }

        @JsonProperty(value="entropy")
        @JsonPropertyDescription(value="Specifies the calculated entropy for the section, as calculated using the Shannon algorithm.")
        @CanIgnoreReturnValue
        public final Builder entropy(Optional<Float> entropy) {
            this.entropy = entropy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(String key, String value) {
            this.hashes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(Map.Entry<String, ? extends String> entry) {
            this.hashes.put(entry);
            return this;
        }

        @JsonProperty(value="hashes")
        @JsonPropertyDescription(value="Specifies any hashes computed over the section.")
        @CanIgnoreReturnValue
        public final Builder hashes(Map<String, ? extends String> entries) {
            this.hashes = ImmutableMap.builder();
            return this.putAllHashes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHashes(Map<String, ? extends String> entries) {
            this.hashes.putAll(entries);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public WindowsPeSection build() {
            return WindowsPeSection.validate(new WindowsPeSection(this.name, this.size, this.entropy, this.hashes.build(), this.customProperties.build()));
        }
    }
}

