/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.WindowsPeSection;
import security.whisper.javastix.validation.GenericValidation;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.vocabulary.vocabularies.HashingAlgorithms;

@JsonSerialize(as=WindowsPeSection.class)
@JsonDeserialize(builder=WindowsPeSection.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"name", "size", "entropy", "hashes"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Obj"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true, depluralizeDictionary={"hash:hashes"})
public interface WindowsPeSectionObj
extends GenericValidation,
StixCustomProperties,
Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the section.")
    @NotNull
    public Optional<String> getName();

    @JsonProperty(value="size")
    @JsonPropertyDescription(value="Specifies the size of the section, in bytes.")
    public Optional<@PositiveOrZero Long> getSize();

    @JsonProperty(value="entropy")
    @JsonPropertyDescription(value="Specifies the calculated entropy for the section, as calculated using the Shannon algorithm.")
    public Optional<Float> getEntropy();

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies any hashes computed over the section.")
    public Map<@Length(min=3, max=256) @HashingVocab(value=HashingAlgorithms.class) String, String> getHashes();
}

