/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.WindowsRegistryValueObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WindowsRegistryValueObj", generator="Immutables")
@Immutable
public final class WindowsRegistryValue
implements WindowsRegistryValueObj {
    private final String name;
    @Nullable
    private final String data;
    @Nullable
    private final String dataType;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private WindowsRegistryValue(String name, @Nullable String data, @Nullable String dataType, ImmutableMap<String, Object> customProperties) {
        this.name = name;
        this.data = data;
        this.dataType = dataType;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the registry value. For specifying the default value in a registry key, an empty string MUST be used.")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Specifies the data contained in the registry value.")
    public Optional<String> getData() {
        return Optional.ofNullable(this.data);
    }

    @Override
    @JsonProperty(value="data_type")
    @JsonPropertyDescription(value="Specifies the registry (REG_*) data type used in the registry value.")
    public Optional<String> getDataType() {
        return Optional.ofNullable(this.dataType);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final WindowsRegistryValue withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return WindowsRegistryValue.validate(new WindowsRegistryValue(value, this.data, this.dataType, this.customProperties));
    }

    public final WindowsRegistryValue withData(String value) {
        String newValue = Objects.requireNonNull(value, "data");
        if (Objects.equals(this.data, newValue)) {
            return this;
        }
        return WindowsRegistryValue.validate(new WindowsRegistryValue(this.name, newValue, this.dataType, this.customProperties));
    }

    public final WindowsRegistryValue withData(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.data, value)) {
            return this;
        }
        return WindowsRegistryValue.validate(new WindowsRegistryValue(this.name, value, this.dataType, this.customProperties));
    }

    public final WindowsRegistryValue withDataType(String value) {
        String newValue = Objects.requireNonNull(value, "dataType");
        if (Objects.equals(this.dataType, newValue)) {
            return this;
        }
        return WindowsRegistryValue.validate(new WindowsRegistryValue(this.name, this.data, newValue, this.customProperties));
    }

    public final WindowsRegistryValue withDataType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dataType, value)) {
            return this;
        }
        return WindowsRegistryValue.validate(new WindowsRegistryValue(this.name, this.data, value, this.customProperties));
    }

    public final WindowsRegistryValue withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsRegistryValue.validate(new WindowsRegistryValue(this.name, this.data, this.dataType, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WindowsRegistryValue && this.equalTo((WindowsRegistryValue)another);
    }

    private boolean equalTo(WindowsRegistryValue another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.data, another.data) && Objects.equals(this.dataType, another.dataType) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.dataType);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WindowsRegistryValue").omitNullValues().add("name", (Object)this.name).add("data", (Object)this.data).add("dataType", (Object)this.dataType).add("customProperties", this.customProperties).toString();
    }

    private static WindowsRegistryValue validate(WindowsRegistryValue instance) {
        instance.validateEntity();
        return instance;
    }

    public static WindowsRegistryValue copyOf(WindowsRegistryValueObj instance) {
        if (instance instanceof WindowsRegistryValue) {
            return (WindowsRegistryValue)instance;
        }
        return WindowsRegistryValue.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return WindowsRegistryValue.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"name", "data", "data_type"})
    @Generated(from="WindowsRegistryValueObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String data;
        @Nullable
        private String dataType;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(WindowsRegistryValueObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof WindowsRegistryValueObj) {
                Optional<String> dataTypeOptional;
                String nameValue;
                instance = (WindowsRegistryValueObj)object;
                Optional<String> dataOptional = instance.getData();
                if (dataOptional.isPresent()) {
                    this.data(dataOptional);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((dataTypeOptional = instance.getDataType()).isPresent()) {
                    this.dataType(dataTypeOptional);
                }
            }
        }

        @JsonProperty(value="name")
        @JsonPropertyDescription(value="Specifies the name of the registry value. For specifying the default value in a registry key, an empty string MUST be used.")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(String data) {
            this.data = Objects.requireNonNull(data, "data");
            return this;
        }

        @JsonProperty(value="data")
        @JsonPropertyDescription(value="Specifies the data contained in the registry value.")
        @CanIgnoreReturnValue
        public final Builder data(Optional<String> data) {
            this.data = data.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dataType(String dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType");
            return this;
        }

        @JsonProperty(value="data_type")
        @JsonPropertyDescription(value="Specifies the registry (REG_*) data type used in the registry value.")
        @CanIgnoreReturnValue
        public final Builder dataType(Optional<String> dataType) {
            this.dataType = dataType.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public WindowsRegistryValue build() {
            return WindowsRegistryValue.validate(new WindowsRegistryValue(this.name, this.data, this.dataType, this.customProperties.build()));
        }
    }
}

