/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.WindowsRegistryValue;
import security.whisper.javastix.validation.GenericValidation;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.vocabulary.vocabularies.WindowsRegistryValueDataTypes;

@JsonSerialize(as=WindowsRegistryValue.class)
@JsonDeserialize(builder=WindowsRegistryValue.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"name", "data", "data_type"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Obj"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface WindowsRegistryValueObj
extends GenericValidation,
StixCustomProperties,
Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the registry value. For specifying the default value in a registry key, an empty string MUST be used.")
    @NotNull
    public String getName();

    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Specifies the data contained in the registry value.")
    public Optional<String> getData();

    @JsonProperty(value="data_type")
    @JsonPropertyDescription(value="Specifies the registry (REG_*) data type used in the registry value.")
    public Optional<@Vocab(value=WindowsRegistryValueDataTypes.class) String> getDataType();
}

