/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.types.X509v3ExtensionsObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="X509v3ExtensionsObj", generator="Immutables")
@Immutable
public final class X509v3Extensions
implements X509v3ExtensionsObj {
    @Nullable
    private final String basicConstraints;
    @Nullable
    private final String nameConstraints;
    @Nullable
    private final String policyConstraints;
    @Nullable
    private final String keyUsage;
    @Nullable
    private final String extendedKeyUsage;
    @Nullable
    private final String subjectKeyIdentifier;
    @Nullable
    private final String authorityKeyIdentifier;
    @Nullable
    private final String subjectAlternativeName;
    @Nullable
    private final String issuerAlternativeName;
    @Nullable
    private final String subjectDirectoryAttributes;
    @Nullable
    private final String crlDistributionPoints;
    @Nullable
    private final String inhibitAnyPolicy;
    @Nullable
    private final StixInstant privateKeyUsagePeriodNotBefore;
    @Nullable
    private final StixInstant privateKeyUsagePeriodNotAfter;
    @Nullable
    private final String certificatePolicies;
    @Nullable
    private final String policyMappings;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private X509v3Extensions(@Nullable String basicConstraints, @Nullable String nameConstraints, @Nullable String policyConstraints, @Nullable String keyUsage, @Nullable String extendedKeyUsage, @Nullable String subjectKeyIdentifier, @Nullable String authorityKeyIdentifier, @Nullable String subjectAlternativeName, @Nullable String issuerAlternativeName, @Nullable String subjectDirectoryAttributes, @Nullable String crlDistributionPoints, @Nullable String inhibitAnyPolicy, @Nullable StixInstant privateKeyUsagePeriodNotBefore, @Nullable StixInstant privateKeyUsagePeriodNotAfter, @Nullable String certificatePolicies, @Nullable String policyMappings, ImmutableMap<String, Object> customProperties) {
        this.basicConstraints = basicConstraints;
        this.nameConstraints = nameConstraints;
        this.policyConstraints = policyConstraints;
        this.keyUsage = keyUsage;
        this.extendedKeyUsage = extendedKeyUsage;
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.authorityKeyIdentifier = authorityKeyIdentifier;
        this.subjectAlternativeName = subjectAlternativeName;
        this.issuerAlternativeName = issuerAlternativeName;
        this.subjectDirectoryAttributes = subjectDirectoryAttributes;
        this.crlDistributionPoints = crlDistributionPoints;
        this.inhibitAnyPolicy = inhibitAnyPolicy;
        this.privateKeyUsagePeriodNotBefore = privateKeyUsagePeriodNotBefore;
        this.privateKeyUsagePeriodNotAfter = privateKeyUsagePeriodNotAfter;
        this.certificatePolicies = certificatePolicies;
        this.policyMappings = policyMappings;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="basic_constraints")
    @JsonPropertyDescription(value="Specifies a multi-valued extension which indicates whether a certificate is a CA certificate.")
    public Optional<String> getBasicConstraints() {
        return Optional.ofNullable(this.basicConstraints);
    }

    @Override
    @JsonProperty(value="name_constraints")
    @JsonPropertyDescription(value="Specifies a namespace within which all subject names in subsequent certificates in a certification path MUST be located.")
    public Optional<String> getNameConstraints() {
        return Optional.ofNullable(this.nameConstraints);
    }

    @Override
    @JsonProperty(value="policy_constraints")
    @JsonPropertyDescription(value="Specifies any constraints on path validation for certificates issued to CAs.")
    public Optional<String> getPolicyConstraints() {
        return Optional.ofNullable(this.policyConstraints);
    }

    @Override
    @JsonProperty(value="key_usage")
    @JsonPropertyDescription(value="Specifies a multi-valued extension consisting of a list of names of the permitted key usages.")
    public Optional<String> getKeyUsage() {
        return Optional.ofNullable(this.keyUsage);
    }

    @Override
    @JsonProperty(value="extended_key_usage")
    @JsonPropertyDescription(value="Specifies a list of usages indicating purposes for which the certificate public key can be used for.")
    public Optional<String> getExtendedKeyUsage() {
        return Optional.ofNullable(this.extendedKeyUsage);
    }

    @Override
    @JsonProperty(value="subject_key_identifier")
    @JsonPropertyDescription(value="Specifies the identifier that provides a means of identifying certificates that contain a particular public key.")
    public Optional<String> getSubjectKeyIdentifier() {
        return Optional.ofNullable(this.subjectKeyIdentifier);
    }

    @Override
    @JsonProperty(value="authority_key_identifier")
    @JsonPropertyDescription(value="Specifies the identifier that provides a means of identifying the public key corresponding to the key used to sign a certificate.")
    public Optional<String> getAuthorityKeyIdentifier() {
        return Optional.ofNullable(this.authorityKeyIdentifier);
    }

    @Override
    @JsonProperty(value="subject_alternative_name")
    @JsonPropertyDescription(value="Specifies the additional identities to be bound to the subject of the certificate.")
    public Optional<String> getSubjectAlternativeName() {
        return Optional.ofNullable(this.subjectAlternativeName);
    }

    @Override
    @JsonProperty(value="issuer_alternative_name")
    @JsonPropertyDescription(value="Specifies the additional identities to be bound to the issuer of the certificate.")
    public Optional<String> getIssuerAlternativeName() {
        return Optional.ofNullable(this.issuerAlternativeName);
    }

    @Override
    @JsonProperty(value="subject_directory_attributes")
    @JsonPropertyDescription(value="Specifies the identification attributes (e.g., nationality) of the subject.")
    public Optional<String> getSubjectDirectoryAttributes() {
        return Optional.ofNullable(this.subjectDirectoryAttributes);
    }

    @Override
    @JsonProperty(value="crl_distribution_points")
    @JsonPropertyDescription(value="Specifies how CRL information is obtained.")
    public Optional<String> getCrlDistributionPoints() {
        return Optional.ofNullable(this.crlDistributionPoints);
    }

    @Override
    @JsonProperty(value="inhibit_any_policy")
    @JsonPropertyDescription(value="Specifies the number of additional certificates that may appear in the path before anyPolicy is no longer permitted.")
    public Optional<String> getInhibitAnyPolicy() {
        return Optional.ofNullable(this.inhibitAnyPolicy);
    }

    @Override
    @JsonProperty(value="private_key_usage_period_not_before")
    @JsonPropertyDescription(value="Specifies the date on which the validity period begins for the key, if it is different from the validity period of the certificate.")
    public Optional<StixInstant> getPrivateKeyUsagePeriodNotBefore() {
        return Optional.ofNullable(this.privateKeyUsagePeriodNotBefore);
    }

    @Override
    @JsonProperty(value="private_key_usage_period_not_after")
    @JsonPropertyDescription(value="Specifies the date on which the validity period ends for the key, if it is different from the validity period of the certificate.")
    public Optional<StixInstant> getPrivateKeyUsagePeriodNotAfter() {
        return Optional.ofNullable(this.privateKeyUsagePeriodNotAfter);
    }

    @Override
    @JsonProperty(value="certificate_policies")
    @JsonPropertyDescription(value="Specifies a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.")
    public Optional<String> getCertificatePolicies() {
        return Optional.ofNullable(this.certificatePolicies);
    }

    @Override
    @JsonProperty(value="policy_mappings")
    @JsonPropertyDescription(value="Specifies one or more pairs of OIDs(); each pair includes an issuerDomainPolicy and a subjectDomainPolicy")
    public Optional<String> getPolicyMappings() {
        return Optional.ofNullable(this.policyMappings);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final X509v3Extensions withBasicConstraints(String value) {
        String newValue = Objects.requireNonNull(value, "basicConstraints");
        if (Objects.equals(this.basicConstraints, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(newValue, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withBasicConstraints(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.basicConstraints, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(value, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withNameConstraints(String value) {
        String newValue = Objects.requireNonNull(value, "nameConstraints");
        if (Objects.equals(this.nameConstraints, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, newValue, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withNameConstraints(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.nameConstraints, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, value, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withPolicyConstraints(String value) {
        String newValue = Objects.requireNonNull(value, "policyConstraints");
        if (Objects.equals(this.policyConstraints, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, newValue, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withPolicyConstraints(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.policyConstraints, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, value, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withKeyUsage(String value) {
        String newValue = Objects.requireNonNull(value, "keyUsage");
        if (Objects.equals(this.keyUsage, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, newValue, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withKeyUsage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.keyUsage, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, value, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withExtendedKeyUsage(String value) {
        String newValue = Objects.requireNonNull(value, "extendedKeyUsage");
        if (Objects.equals(this.extendedKeyUsage, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, newValue, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withExtendedKeyUsage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.extendedKeyUsage, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, value, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withSubjectKeyIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "subjectKeyIdentifier");
        if (Objects.equals(this.subjectKeyIdentifier, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, newValue, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withSubjectKeyIdentifier(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subjectKeyIdentifier, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, value, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withAuthorityKeyIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "authorityKeyIdentifier");
        if (Objects.equals(this.authorityKeyIdentifier, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, newValue, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withAuthorityKeyIdentifier(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authorityKeyIdentifier, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, value, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withSubjectAlternativeName(String value) {
        String newValue = Objects.requireNonNull(value, "subjectAlternativeName");
        if (Objects.equals(this.subjectAlternativeName, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, newValue, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withSubjectAlternativeName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subjectAlternativeName, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, value, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withIssuerAlternativeName(String value) {
        String newValue = Objects.requireNonNull(value, "issuerAlternativeName");
        if (Objects.equals(this.issuerAlternativeName, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, newValue, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withIssuerAlternativeName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.issuerAlternativeName, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, value, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withSubjectDirectoryAttributes(String value) {
        String newValue = Objects.requireNonNull(value, "subjectDirectoryAttributes");
        if (Objects.equals(this.subjectDirectoryAttributes, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, newValue, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withSubjectDirectoryAttributes(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subjectDirectoryAttributes, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, value, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withCrlDistributionPoints(String value) {
        String newValue = Objects.requireNonNull(value, "crlDistributionPoints");
        if (Objects.equals(this.crlDistributionPoints, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, newValue, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withCrlDistributionPoints(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.crlDistributionPoints, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, value, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withInhibitAnyPolicy(String value) {
        String newValue = Objects.requireNonNull(value, "inhibitAnyPolicy");
        if (Objects.equals(this.inhibitAnyPolicy, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, newValue, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withInhibitAnyPolicy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.inhibitAnyPolicy, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, value, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withPrivateKeyUsagePeriodNotBefore(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "privateKeyUsagePeriodNotBefore");
        if (this.privateKeyUsagePeriodNotBefore == newValue) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, newValue, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withPrivateKeyUsagePeriodNotBefore(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.privateKeyUsagePeriodNotBefore == value) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, value, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withPrivateKeyUsagePeriodNotAfter(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "privateKeyUsagePeriodNotAfter");
        if (this.privateKeyUsagePeriodNotAfter == newValue) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, newValue, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withPrivateKeyUsagePeriodNotAfter(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.privateKeyUsagePeriodNotAfter == value) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, value, this.certificatePolicies, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withCertificatePolicies(String value) {
        String newValue = Objects.requireNonNull(value, "certificatePolicies");
        if (Objects.equals(this.certificatePolicies, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, newValue, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withCertificatePolicies(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.certificatePolicies, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, value, this.policyMappings, this.customProperties));
    }

    public final X509v3Extensions withPolicyMappings(String value) {
        String newValue = Objects.requireNonNull(value, "policyMappings");
        if (Objects.equals(this.policyMappings, newValue)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, newValue, this.customProperties));
    }

    public final X509v3Extensions withPolicyMappings(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.policyMappings, value)) {
            return this;
        }
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, value, this.customProperties));
    }

    public final X509v3Extensions withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof X509v3Extensions && this.equalTo((X509v3Extensions)another);
    }

    private boolean equalTo(X509v3Extensions another) {
        return Objects.equals(this.basicConstraints, another.basicConstraints) && Objects.equals(this.nameConstraints, another.nameConstraints) && Objects.equals(this.policyConstraints, another.policyConstraints) && Objects.equals(this.keyUsage, another.keyUsage) && Objects.equals(this.extendedKeyUsage, another.extendedKeyUsage) && Objects.equals(this.subjectKeyIdentifier, another.subjectKeyIdentifier) && Objects.equals(this.authorityKeyIdentifier, another.authorityKeyIdentifier) && Objects.equals(this.subjectAlternativeName, another.subjectAlternativeName) && Objects.equals(this.issuerAlternativeName, another.issuerAlternativeName) && Objects.equals(this.subjectDirectoryAttributes, another.subjectDirectoryAttributes) && Objects.equals(this.crlDistributionPoints, another.crlDistributionPoints) && Objects.equals(this.inhibitAnyPolicy, another.inhibitAnyPolicy) && Objects.equals(this.privateKeyUsagePeriodNotBefore, another.privateKeyUsagePeriodNotBefore) && Objects.equals(this.privateKeyUsagePeriodNotAfter, another.privateKeyUsagePeriodNotAfter) && Objects.equals(this.certificatePolicies, another.certificatePolicies) && Objects.equals(this.policyMappings, another.policyMappings) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.basicConstraints);
        h += (h << 5) + Objects.hashCode(this.nameConstraints);
        h += (h << 5) + Objects.hashCode(this.policyConstraints);
        h += (h << 5) + Objects.hashCode(this.keyUsage);
        h += (h << 5) + Objects.hashCode(this.extendedKeyUsage);
        h += (h << 5) + Objects.hashCode(this.subjectKeyIdentifier);
        h += (h << 5) + Objects.hashCode(this.authorityKeyIdentifier);
        h += (h << 5) + Objects.hashCode(this.subjectAlternativeName);
        h += (h << 5) + Objects.hashCode(this.issuerAlternativeName);
        h += (h << 5) + Objects.hashCode(this.subjectDirectoryAttributes);
        h += (h << 5) + Objects.hashCode(this.crlDistributionPoints);
        h += (h << 5) + Objects.hashCode(this.inhibitAnyPolicy);
        h += (h << 5) + Objects.hashCode(this.privateKeyUsagePeriodNotBefore);
        h += (h << 5) + Objects.hashCode(this.privateKeyUsagePeriodNotAfter);
        h += (h << 5) + Objects.hashCode(this.certificatePolicies);
        h += (h << 5) + Objects.hashCode(this.policyMappings);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"X509v3Extensions").omitNullValues().add("basicConstraints", (Object)this.basicConstraints).add("nameConstraints", (Object)this.nameConstraints).add("policyConstraints", (Object)this.policyConstraints).add("keyUsage", (Object)this.keyUsage).add("extendedKeyUsage", (Object)this.extendedKeyUsage).add("subjectKeyIdentifier", (Object)this.subjectKeyIdentifier).add("authorityKeyIdentifier", (Object)this.authorityKeyIdentifier).add("subjectAlternativeName", (Object)this.subjectAlternativeName).add("issuerAlternativeName", (Object)this.issuerAlternativeName).add("subjectDirectoryAttributes", (Object)this.subjectDirectoryAttributes).add("crlDistributionPoints", (Object)this.crlDistributionPoints).add("inhibitAnyPolicy", (Object)this.inhibitAnyPolicy).add("privateKeyUsagePeriodNotBefore", (Object)this.privateKeyUsagePeriodNotBefore).add("privateKeyUsagePeriodNotAfter", (Object)this.privateKeyUsagePeriodNotAfter).add("certificatePolicies", (Object)this.certificatePolicies).add("policyMappings", (Object)this.policyMappings).add("customProperties", this.customProperties).toString();
    }

    private static X509v3Extensions validate(X509v3Extensions instance) {
        instance.validateEntity();
        return instance;
    }

    public static X509v3Extensions copyOf(X509v3ExtensionsObj instance) {
        if (instance instanceof X509v3Extensions) {
            return (X509v3Extensions)instance;
        }
        return X509v3Extensions.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return X509v3Extensions.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"basic_constraints", "name_constraints", "policy_constraints", "key_usage", "extended_key_usage", "subject_key_identifier", "authority_key_identifier", "subject_alternative_name", "issuer_alternative_name", "subject_directory_attributes", "crl_distribution_points", "inhibit_any_policy", "private_key_usage_period_not_before", "private_key_usage_period_not_after", "certificate_policies", "policy_mappings"})
    @Generated(from="X509v3ExtensionsObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String basicConstraints;
        @Nullable
        private String nameConstraints;
        @Nullable
        private String policyConstraints;
        @Nullable
        private String keyUsage;
        @Nullable
        private String extendedKeyUsage;
        @Nullable
        private String subjectKeyIdentifier;
        @Nullable
        private String authorityKeyIdentifier;
        @Nullable
        private String subjectAlternativeName;
        @Nullable
        private String issuerAlternativeName;
        @Nullable
        private String subjectDirectoryAttributes;
        @Nullable
        private String crlDistributionPoints;
        @Nullable
        private String inhibitAnyPolicy;
        @Nullable
        private StixInstant privateKeyUsagePeriodNotBefore;
        @Nullable
        private StixInstant privateKeyUsagePeriodNotAfter;
        @Nullable
        private String certificatePolicies;
        @Nullable
        private String policyMappings;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(X509v3ExtensionsObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof X509v3ExtensionsObj) {
                Optional<String> crlDistributionPointsOptional;
                Optional<String> nameConstraintsOptional;
                Optional<String> extendedKeyUsageOptional;
                Optional<String> basicConstraintsOptional;
                Optional<String> certificatePoliciesOptional;
                Optional<String> inhibitAnyPolicyOptional;
                Optional<String> keyUsageOptional;
                Optional<String> policyMappingsOptional;
                Optional<String> subjectKeyIdentifierOptional;
                Optional<String> issuerAlternativeNameOptional;
                Optional<StixInstant> privateKeyUsagePeriodNotAfterOptional;
                Optional<String> subjectAlternativeNameOptional;
                Optional<StixInstant> privateKeyUsagePeriodNotBeforeOptional;
                Optional<String> policyConstraintsOptional;
                Optional<String> subjectDirectoryAttributesOptional;
                instance = (X509v3ExtensionsObj)object;
                Optional<String> authorityKeyIdentifierOptional = instance.getAuthorityKeyIdentifier();
                if (authorityKeyIdentifierOptional.isPresent()) {
                    this.authorityKeyIdentifier(authorityKeyIdentifierOptional);
                }
                if ((subjectDirectoryAttributesOptional = instance.getSubjectDirectoryAttributes()).isPresent()) {
                    this.subjectDirectoryAttributes(subjectDirectoryAttributesOptional);
                }
                if ((policyConstraintsOptional = instance.getPolicyConstraints()).isPresent()) {
                    this.policyConstraints(policyConstraintsOptional);
                }
                if ((privateKeyUsagePeriodNotBeforeOptional = instance.getPrivateKeyUsagePeriodNotBefore()).isPresent()) {
                    this.privateKeyUsagePeriodNotBefore(privateKeyUsagePeriodNotBeforeOptional);
                }
                if ((subjectAlternativeNameOptional = instance.getSubjectAlternativeName()).isPresent()) {
                    this.subjectAlternativeName(subjectAlternativeNameOptional);
                }
                if ((privateKeyUsagePeriodNotAfterOptional = instance.getPrivateKeyUsagePeriodNotAfter()).isPresent()) {
                    this.privateKeyUsagePeriodNotAfter(privateKeyUsagePeriodNotAfterOptional);
                }
                if ((issuerAlternativeNameOptional = instance.getIssuerAlternativeName()).isPresent()) {
                    this.issuerAlternativeName(issuerAlternativeNameOptional);
                }
                if ((subjectKeyIdentifierOptional = instance.getSubjectKeyIdentifier()).isPresent()) {
                    this.subjectKeyIdentifier(subjectKeyIdentifierOptional);
                }
                if ((policyMappingsOptional = instance.getPolicyMappings()).isPresent()) {
                    this.policyMappings(policyMappingsOptional);
                }
                if ((keyUsageOptional = instance.getKeyUsage()).isPresent()) {
                    this.keyUsage(keyUsageOptional);
                }
                if ((inhibitAnyPolicyOptional = instance.getInhibitAnyPolicy()).isPresent()) {
                    this.inhibitAnyPolicy(inhibitAnyPolicyOptional);
                }
                if ((certificatePoliciesOptional = instance.getCertificatePolicies()).isPresent()) {
                    this.certificatePolicies(certificatePoliciesOptional);
                }
                if ((basicConstraintsOptional = instance.getBasicConstraints()).isPresent()) {
                    this.basicConstraints(basicConstraintsOptional);
                }
                if ((extendedKeyUsageOptional = instance.getExtendedKeyUsage()).isPresent()) {
                    this.extendedKeyUsage(extendedKeyUsageOptional);
                }
                if ((nameConstraintsOptional = instance.getNameConstraints()).isPresent()) {
                    this.nameConstraints(nameConstraintsOptional);
                }
                if ((crlDistributionPointsOptional = instance.getCrlDistributionPoints()).isPresent()) {
                    this.crlDistributionPoints(crlDistributionPointsOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder basicConstraints(String basicConstraints) {
            this.basicConstraints = Objects.requireNonNull(basicConstraints, "basicConstraints");
            return this;
        }

        @JsonProperty(value="basic_constraints")
        @JsonPropertyDescription(value="Specifies a multi-valued extension which indicates whether a certificate is a CA certificate.")
        @CanIgnoreReturnValue
        public final Builder basicConstraints(Optional<String> basicConstraints) {
            this.basicConstraints = basicConstraints.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nameConstraints(String nameConstraints) {
            this.nameConstraints = Objects.requireNonNull(nameConstraints, "nameConstraints");
            return this;
        }

        @JsonProperty(value="name_constraints")
        @JsonPropertyDescription(value="Specifies a namespace within which all subject names in subsequent certificates in a certification path MUST be located.")
        @CanIgnoreReturnValue
        public final Builder nameConstraints(Optional<String> nameConstraints) {
            this.nameConstraints = nameConstraints.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policyConstraints(String policyConstraints) {
            this.policyConstraints = Objects.requireNonNull(policyConstraints, "policyConstraints");
            return this;
        }

        @JsonProperty(value="policy_constraints")
        @JsonPropertyDescription(value="Specifies any constraints on path validation for certificates issued to CAs.")
        @CanIgnoreReturnValue
        public final Builder policyConstraints(Optional<String> policyConstraints) {
            this.policyConstraints = policyConstraints.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = Objects.requireNonNull(keyUsage, "keyUsage");
            return this;
        }

        @JsonProperty(value="key_usage")
        @JsonPropertyDescription(value="Specifies a multi-valued extension consisting of a list of names of the permitted key usages.")
        @CanIgnoreReturnValue
        public final Builder keyUsage(Optional<String> keyUsage) {
            this.keyUsage = keyUsage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder extendedKeyUsage(String extendedKeyUsage) {
            this.extendedKeyUsage = Objects.requireNonNull(extendedKeyUsage, "extendedKeyUsage");
            return this;
        }

        @JsonProperty(value="extended_key_usage")
        @JsonPropertyDescription(value="Specifies a list of usages indicating purposes for which the certificate public key can be used for.")
        @CanIgnoreReturnValue
        public final Builder extendedKeyUsage(Optional<String> extendedKeyUsage) {
            this.extendedKeyUsage = extendedKeyUsage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectKeyIdentifier(String subjectKeyIdentifier) {
            this.subjectKeyIdentifier = Objects.requireNonNull(subjectKeyIdentifier, "subjectKeyIdentifier");
            return this;
        }

        @JsonProperty(value="subject_key_identifier")
        @JsonPropertyDescription(value="Specifies the identifier that provides a means of identifying certificates that contain a particular public key.")
        @CanIgnoreReturnValue
        public final Builder subjectKeyIdentifier(Optional<String> subjectKeyIdentifier) {
            this.subjectKeyIdentifier = subjectKeyIdentifier.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authorityKeyIdentifier(String authorityKeyIdentifier) {
            this.authorityKeyIdentifier = Objects.requireNonNull(authorityKeyIdentifier, "authorityKeyIdentifier");
            return this;
        }

        @JsonProperty(value="authority_key_identifier")
        @JsonPropertyDescription(value="Specifies the identifier that provides a means of identifying the public key corresponding to the key used to sign a certificate.")
        @CanIgnoreReturnValue
        public final Builder authorityKeyIdentifier(Optional<String> authorityKeyIdentifier) {
            this.authorityKeyIdentifier = authorityKeyIdentifier.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectAlternativeName(String subjectAlternativeName) {
            this.subjectAlternativeName = Objects.requireNonNull(subjectAlternativeName, "subjectAlternativeName");
            return this;
        }

        @JsonProperty(value="subject_alternative_name")
        @JsonPropertyDescription(value="Specifies the additional identities to be bound to the subject of the certificate.")
        @CanIgnoreReturnValue
        public final Builder subjectAlternativeName(Optional<String> subjectAlternativeName) {
            this.subjectAlternativeName = subjectAlternativeName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuerAlternativeName(String issuerAlternativeName) {
            this.issuerAlternativeName = Objects.requireNonNull(issuerAlternativeName, "issuerAlternativeName");
            return this;
        }

        @JsonProperty(value="issuer_alternative_name")
        @JsonPropertyDescription(value="Specifies the additional identities to be bound to the issuer of the certificate.")
        @CanIgnoreReturnValue
        public final Builder issuerAlternativeName(Optional<String> issuerAlternativeName) {
            this.issuerAlternativeName = issuerAlternativeName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectDirectoryAttributes(String subjectDirectoryAttributes) {
            this.subjectDirectoryAttributes = Objects.requireNonNull(subjectDirectoryAttributes, "subjectDirectoryAttributes");
            return this;
        }

        @JsonProperty(value="subject_directory_attributes")
        @JsonPropertyDescription(value="Specifies the identification attributes (e.g., nationality) of the subject.")
        @CanIgnoreReturnValue
        public final Builder subjectDirectoryAttributes(Optional<String> subjectDirectoryAttributes) {
            this.subjectDirectoryAttributes = subjectDirectoryAttributes.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crlDistributionPoints(String crlDistributionPoints) {
            this.crlDistributionPoints = Objects.requireNonNull(crlDistributionPoints, "crlDistributionPoints");
            return this;
        }

        @JsonProperty(value="crl_distribution_points")
        @JsonPropertyDescription(value="Specifies how CRL information is obtained.")
        @CanIgnoreReturnValue
        public final Builder crlDistributionPoints(Optional<String> crlDistributionPoints) {
            this.crlDistributionPoints = crlDistributionPoints.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inhibitAnyPolicy(String inhibitAnyPolicy) {
            this.inhibitAnyPolicy = Objects.requireNonNull(inhibitAnyPolicy, "inhibitAnyPolicy");
            return this;
        }

        @JsonProperty(value="inhibit_any_policy")
        @JsonPropertyDescription(value="Specifies the number of additional certificates that may appear in the path before anyPolicy is no longer permitted.")
        @CanIgnoreReturnValue
        public final Builder inhibitAnyPolicy(Optional<String> inhibitAnyPolicy) {
            this.inhibitAnyPolicy = inhibitAnyPolicy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privateKeyUsagePeriodNotBefore(StixInstant privateKeyUsagePeriodNotBefore) {
            this.privateKeyUsagePeriodNotBefore = Objects.requireNonNull(privateKeyUsagePeriodNotBefore, "privateKeyUsagePeriodNotBefore");
            return this;
        }

        @JsonProperty(value="private_key_usage_period_not_before")
        @JsonPropertyDescription(value="Specifies the date on which the validity period begins for the key, if it is different from the validity period of the certificate.")
        @CanIgnoreReturnValue
        public final Builder privateKeyUsagePeriodNotBefore(Optional<? extends StixInstant> privateKeyUsagePeriodNotBefore) {
            this.privateKeyUsagePeriodNotBefore = privateKeyUsagePeriodNotBefore.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privateKeyUsagePeriodNotAfter(StixInstant privateKeyUsagePeriodNotAfter) {
            this.privateKeyUsagePeriodNotAfter = Objects.requireNonNull(privateKeyUsagePeriodNotAfter, "privateKeyUsagePeriodNotAfter");
            return this;
        }

        @JsonProperty(value="private_key_usage_period_not_after")
        @JsonPropertyDescription(value="Specifies the date on which the validity period ends for the key, if it is different from the validity period of the certificate.")
        @CanIgnoreReturnValue
        public final Builder privateKeyUsagePeriodNotAfter(Optional<? extends StixInstant> privateKeyUsagePeriodNotAfter) {
            this.privateKeyUsagePeriodNotAfter = privateKeyUsagePeriodNotAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder certificatePolicies(String certificatePolicies) {
            this.certificatePolicies = Objects.requireNonNull(certificatePolicies, "certificatePolicies");
            return this;
        }

        @JsonProperty(value="certificate_policies")
        @JsonPropertyDescription(value="Specifies a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.")
        @CanIgnoreReturnValue
        public final Builder certificatePolicies(Optional<String> certificatePolicies) {
            this.certificatePolicies = certificatePolicies.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policyMappings(String policyMappings) {
            this.policyMappings = Objects.requireNonNull(policyMappings, "policyMappings");
            return this;
        }

        @JsonProperty(value="policy_mappings")
        @JsonPropertyDescription(value="Specifies one or more pairs of OIDs(); each pair includes an issuerDomainPolicy and a subjectDomainPolicy")
        @CanIgnoreReturnValue
        public final Builder policyMappings(Optional<String> policyMappings) {
            this.policyMappings = policyMappings.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public X509v3Extensions build() {
            return X509v3Extensions.validate(new X509v3Extensions(this.basicConstraints, this.nameConstraints, this.policyConstraints, this.keyUsage, this.extendedKeyUsage, this.subjectKeyIdentifier, this.authorityKeyIdentifier, this.subjectAlternativeName, this.issuerAlternativeName, this.subjectDirectoryAttributes, this.crlDistributionPoints, this.inhibitAnyPolicy, this.privateKeyUsagePeriodNotBefore, this.privateKeyUsagePeriodNotAfter, this.certificatePolicies, this.policyMappings, this.customProperties.build()));
        }
    }
}

