/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Optional;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.types.X509v3Extensions;
import security.whisper.javastix.validation.GenericValidation;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;

@JsonSerialize(as=X509v3Extensions.class)
@JsonDeserialize(builder=X509v3Extensions.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"basic_constraints", "name_constraints", "policy_constraints", "key_usage", "extended_key_usage", "subject_key_identifier", "authority_key_identifier", "subject_alternative_name", "issuer_alternative_name", "subject_directory_attributes", "crl_distribution_points", "inhibit_any_policy", "private_key_usage_period_not_before", "private_key_usage_period_not_after", "certificate_policies", "policy_mappings"})
@BusinessRule(ifExp="true", thenExp="getBasicConstraints().isPresent() == true || getNameConstraints().isPresent() == true || getPolicyConstraints().isPresent() == true || getKeyUsage().isPresent() == true || getExtendedKeyUsage().isPresent() == true || getSubjectKeyIdentifier().isPresent() == true || getAuthorityKeyIdentifier().isPresent() == true || getSubjectAlternativeName().isPresent() == true || getIssuerAlternativeName().isPresent() == true || getSubjectDirectoryAttributes().isPresent() == true || getCrlDistributionPoints().isPresent() == true || getInhibitAnyPolicy().isPresent() == true || getPrivateKeyUsagePeriodNotBefore().isPresent() == true || getPrivateKeyUsagePeriodNotAfter().isPresent() == true || getCertificatePolicies().isPresent() == true || getPolicyMappings().isPresent() == true", errorMessage="At least 1 property must be provided")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Obj"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface X509v3ExtensionsObj
extends GenericValidation,
StixCustomProperties,
Serializable {
    @JsonProperty(value="basic_constraints")
    @JsonPropertyDescription(value="Specifies a multi-valued extension which indicates whether a certificate is a CA certificate.")
    public Optional<String> getBasicConstraints();

    @JsonProperty(value="name_constraints")
    @JsonPropertyDescription(value="Specifies a namespace within which all subject names in subsequent certificates in a certification path MUST be located.")
    public Optional<String> getNameConstraints();

    @JsonProperty(value="policy_constraints")
    @JsonPropertyDescription(value="Specifies any constraints on path validation for certificates issued to CAs.")
    public Optional<String> getPolicyConstraints();

    @JsonProperty(value="key_usage")
    @JsonPropertyDescription(value="Specifies a multi-valued extension consisting of a list of names of the permitted key usages.")
    public Optional<String> getKeyUsage();

    @JsonProperty(value="extended_key_usage")
    @JsonPropertyDescription(value="Specifies a list of usages indicating purposes for which the certificate public key can be used for.")
    public Optional<String> getExtendedKeyUsage();

    @JsonProperty(value="subject_key_identifier")
    @JsonPropertyDescription(value="Specifies the identifier that provides a means of identifying certificates that contain a particular public key.")
    public Optional<String> getSubjectKeyIdentifier();

    @JsonProperty(value="authority_key_identifier")
    @JsonPropertyDescription(value="Specifies the identifier that provides a means of identifying the public key corresponding to the key used to sign a certificate.")
    public Optional<String> getAuthorityKeyIdentifier();

    @JsonProperty(value="subject_alternative_name")
    @JsonPropertyDescription(value="Specifies the additional identities to be bound to the subject of the certificate.")
    public Optional<String> getSubjectAlternativeName();

    @JsonProperty(value="issuer_alternative_name")
    @JsonPropertyDescription(value="Specifies the additional identities to be bound to the issuer of the certificate.")
    public Optional<String> getIssuerAlternativeName();

    @JsonProperty(value="subject_directory_attributes")
    @JsonPropertyDescription(value="Specifies the identification attributes (e.g., nationality) of the subject.")
    public Optional<String> getSubjectDirectoryAttributes();

    @JsonProperty(value="crl_distribution_points")
    @JsonPropertyDescription(value="Specifies how CRL information is obtained.")
    public Optional<String> getCrlDistributionPoints();

    @JsonProperty(value="inhibit_any_policy")
    @JsonPropertyDescription(value="Specifies the number of additional certificates that may appear in the path before anyPolicy is no longer permitted.")
    public Optional<String> getInhibitAnyPolicy();

    @JsonProperty(value="private_key_usage_period_not_before")
    @JsonPropertyDescription(value="Specifies the date on which the validity period begins for the key, if it is different from the validity period of the certificate.")
    public Optional<StixInstant> getPrivateKeyUsagePeriodNotBefore();

    @JsonProperty(value="private_key_usage_period_not_after")
    @JsonPropertyDescription(value="Specifies the date on which the validity period ends for the key, if it is different from the validity period of the certificate.")
    public Optional<StixInstant> getPrivateKeyUsagePeriodNotAfter();

    @JsonProperty(value="certificate_policies")
    @JsonPropertyDescription(value="Specifies a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.")
    public Optional<String> getCertificatePolicies();

    @JsonProperty(value="policy_mappings")
    @JsonPropertyDescription(value="Specifies one or more pairs of OIDs(); each pair includes an issuerDomainPolicy and a subjectDomainPolicy")
    public Optional<String> getPolicyMappings();
}

