/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.custom.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.custom.StixCustomObject;
import security.whisper.javastix.custom.objects.GenericCustomObject;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.validation.constraints.startswith.StartsWith;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenericCustomObject", generator="Immutables")
@Immutable
public final class CustomObject
implements GenericCustomObject {
    private final @StartsWith(value="x-") String type;
    private final @StartsWith(value="x-") String id;
    private final ImmutableMap<String, Object> customObjectProperties;
    private final boolean hydrated;
    @Nullable
    private final IdentitySdo createdByRef;
    private final StixInstant created;
    @Nullable
    private final String lang;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final ImmutableSet<String> labels;
    private final StixInstant modified;
    private final StixBoolean revoked;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_STRING_LAZY_INIT_BIT = 1L;
    private transient String toJsonString;
    private static final long SPEC_VERSION_LAZY_INIT_BIT = 2L;
    private transient String specVersion;
    private static final long serialVersionUID = 1L;

    private CustomObject(Builder builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.customObjectProperties = builder.customObjectProperties.build();
        this.createdByRef = builder.createdByRef;
        this.lang = builder.lang;
        if (builder.hydratedIsSet()) {
            this.initShim.hydrated(builder.hydrated);
        }
        if (builder.created != null) {
            this.initShim.created(builder.created);
        }
        if (builder.externalReferencesIsSet()) {
            this.initShim.externalReferences((ImmutableSet<ExternalReferenceType>)builder.externalReferences.build());
        }
        if (builder.objectMarkingRefsIsSet()) {
            this.initShim.objectMarkingRefs((ImmutableSet<MarkingDefinitionDm>)builder.objectMarkingRefs.build());
        }
        if (builder.granularMarkingsIsSet()) {
            this.initShim.granularMarkings((ImmutableSet<GranularMarkingDm>)builder.granularMarkings.build());
        }
        if (builder.labelsIsSet()) {
            this.initShim.labels((ImmutableSet<String>)builder.labels.build());
        }
        if (builder.modified != null) {
            this.initShim.modified(builder.modified);
        }
        if (builder.revoked != null) {
            this.initShim.revoked(builder.revoked);
        }
        this.hydrated = this.initShim.getHydrated();
        this.created = this.initShim.getCreated();
        this.externalReferences = this.initShim.getExternalReferences();
        this.objectMarkingRefs = this.initShim.getObjectMarkingRefs();
        this.granularMarkings = this.initShim.getGranularMarkings();
        this.labels = this.initShim.getLabels();
        this.modified = this.initShim.getModified();
        this.revoked = this.initShim.getRevoked();
        this.initShim = null;
    }

    private CustomObject(@StartsWith(value="x-") String type, @StartsWith(value="x-") String id, ImmutableMap<String, Object> customObjectProperties, boolean hydrated, @Nullable IdentitySdo createdByRef, StixInstant created, @Nullable String lang, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, ImmutableSet<String> labels, StixInstant modified, StixBoolean revoked) {
        this.type = type;
        this.id = id;
        this.customObjectProperties = customObjectProperties;
        this.hydrated = hydrated;
        this.createdByRef = createdByRef;
        this.created = created;
        this.lang = lang;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.labels = labels;
        this.modified = modified;
        this.revoked = revoked;
        this.initShim = null;
    }

    private boolean getHydratedInitialize() {
        return GenericCustomObject.super.getHydrated();
    }

    private StixInstant getCreatedInitialize() {
        return GenericCustomObject.super.getCreated();
    }

    private Set<ExternalReferenceType> getExternalReferencesInitialize() {
        return GenericCustomObject.super.getExternalReferences();
    }

    private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
        return GenericCustomObject.super.getObjectMarkingRefs();
    }

    private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
        return GenericCustomObject.super.getGranularMarkings();
    }

    private Set<String> getLabelsInitialize() {
        return GenericCustomObject.super.getLabels();
    }

    private StixInstant getModifiedInitialize() {
        return GenericCustomObject.super.getModified();
    }

    private StixBoolean getRevokedInitialize() {
        return GenericCustomObject.super.getRevoked();
    }

    @Override
    @JsonProperty(value="type")
    public @StartsWith(value="x-") String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    public @StartsWith(value="x-") String getId() {
        return this.id;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomObjectProperties() {
        return this.customObjectProperties;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public boolean getHydrated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHydrated() : this.hydrated;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
    @Redactable(useMask=true, redactionMask="identity--__REDACTED__")
    public Optional<IdentitySdo> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreated() : this.created;
    }

    @Override
    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getLang() {
        return Optional.ofNullable(this.lang);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExternalReferences() : this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMarkingRefs() : this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGranularMarkings() : this.granularMarkings;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabels() : this.labels;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getModified() : this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixBoolean getRevoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRevoked() : this.revoked;
    }

    public final CustomObject withType(@StartsWith(value="x-") String value) {
        if (this.type == value) {
            return this;
        }
        return CustomObject.validate(new CustomObject(value, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withId(@StartsWith(value="x-") String value) {
        if (this.id == value) {
            return this;
        }
        return CustomObject.validate(new CustomObject(this.type, value, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withCustomObjectProperties(Map<String, ? extends Object> entries) {
        if (this.customObjectProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return CustomObject.validate(new CustomObject(this.type, this.id, (ImmutableMap<String, Object>)newValue, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, value, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withCreatedByRef(IdentitySdo value) {
        IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
        if (this.createdByRef == newValue) {
            return this;
        }
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, newValue, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withCreatedByRef(Optional<? extends IdentitySdo> optional) {
        IdentitySdo value = optional.orElse(null);
        if (this.createdByRef == value) {
            return this;
        }
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, value, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "created");
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, newValue, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withLang(String value) {
        String newValue = Objects.requireNonNull(value, "lang");
        if (Objects.equals(this.lang, newValue)) {
            return this;
        }
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withLang(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lang, value)) {
            return this;
        }
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.labels, this.modified, this.revoked));
    }

    public final CustomObject withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final CustomObject withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final CustomObject withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "modified");
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, newValue, this.revoked));
    }

    public final CustomObject withRevoked(StixBoolean value) {
        if (this.revoked == value) {
            return this;
        }
        StixBoolean newValue = Objects.requireNonNull(value, "revoked");
        return CustomObject.validate(new CustomObject(this.type, this.id, this.customObjectProperties, this.hydrated, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.labels, this.modified, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CustomObject && this.equalTo((CustomObject)another);
    }

    private boolean equalTo(CustomObject another) {
        return Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && this.customObjectProperties.equals(another.customObjectProperties) && this.hydrated == another.hydrated && Objects.equals(this.createdByRef, another.createdByRef) && this.created.equals(another.created) && Objects.equals(this.lang, another.lang) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.labels.equals(another.labels) && this.modified.equals(another.modified) && this.revoked.equals(another.revoked);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.customObjectProperties.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.lang);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.revoked.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomObject").omitNullValues().add("type", (Object)this.type).add("id", (Object)this.id).add("customObjectProperties", this.customObjectProperties).add("hydrated", this.hydrated).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("lang", (Object)this.lang).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("labels", this.labels).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJsonString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            CustomObject customObject = this;
            synchronized (customObject) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJsonString = Objects.requireNonNull(GenericCustomObject.super.toJsonString(), "toJsonString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSpecVersion() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            CustomObject customObject = this;
            synchronized (customObject) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.specVersion = Objects.requireNonNull(GenericCustomObject.super.getSpecVersion(), "specVersion");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.specVersion;
    }

    private static CustomObject validate(CustomObject instance) {
        instance.checkHydrationValidation();
        return instance;
    }

    public static CustomObject copyOf(GenericCustomObject instance) {
        if (instance instanceof CustomObject) {
            return (CustomObject)instance;
        }
        return CustomObject.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return CustomObject.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings"})
    @Generated(from="GenericCustomObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_HYDRATED = 1L;
        private static final long OPT_BIT_EXTERNAL_REFERENCES = 2L;
        private static final long OPT_BIT_OBJECT_MARKING_REFS = 4L;
        private static final long OPT_BIT_GRANULAR_MARKINGS = 8L;
        private static final long OPT_BIT_LABELS = 16L;
        private long optBits;
        @Nullable
        private @StartsWith(value="x-") String type;
        @Nullable
        private @StartsWith(value="x-") String id;
        private ImmutableMap.Builder<String, Object> customObjectProperties = ImmutableMap.builder();
        private boolean hydrated;
        @Nullable
        private IdentitySdo createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private String lang;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        @Nullable
        private StixInstant modified;
        @Nullable
        private StixBoolean revoked;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixRevoked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixLabels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GenericCustomObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            String idValue;
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                if ((bits & 8L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
            }
            if (object instanceof StixCommonProperties) {
                Optional<String> langOptional;
                Optional<IdentitySdo> createdByRefOptional;
                instance = (StixCommonProperties)object;
                this.addAllExternalReferences(instance.getExternalReferences());
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                this.created(instance.getCreated());
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 8L) == 0L) {
                    @StartsWith(value="x-") String idValue2 = instance.getId();
                    if (idValue2 != null) {
                        this.id(idValue2);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    @StartsWith(value="x-") String typeValue2 = instance.getType();
                    if (typeValue2 != null) {
                        this.type(typeValue2);
                    }
                    bits |= 1L;
                }
                if ((langOptional = instance.getLang()).isPresent()) {
                    this.lang(langOptional);
                }
            }
            if (object instanceof StixRevoked) {
                instance = (StixRevoked)object;
                this.revoked(instance.getRevoked());
            }
            if (object instanceof StixCustomObject) {
                instance = (StixCustomObject)object;
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                this.putAllCustomObjectProperties(instance.getCustomObjectProperties());
            }
            if (object instanceof StixLabels) {
                instance = (StixLabels)object;
                this.addAllLabels(instance.getLabels());
            }
            if (object instanceof StixModified) {
                instance = (StixModified)object;
                this.modified(instance.getModified());
            }
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(@StartsWith(value="x-") String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@StartsWith(value="x-") String id) {
            this.id = id;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomObjectProperty(String key, Object value) {
            this.customObjectProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomObjectProperty(Map.Entry<String, ? extends Object> entry) {
            this.customObjectProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customObjectProperties(Map<String, ? extends Object> entries) {
            this.customObjectProperties = ImmutableMap.builder();
            return this.putAllCustomObjectProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomObjectProperties(Map<String, ? extends Object> entries) {
            this.customObjectProperties.putAll(entries);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(IdentitySdo createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lang(String lang) {
            this.lang = Objects.requireNonNull(lang, "lang");
            return this;
        }

        @JsonProperty(value="lang")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
        @CanIgnoreReturnValue
        public final Builder lang(Optional<String> lang) {
            this.lang = lang.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(StixBoolean revoked) {
            this.revoked = Objects.requireNonNull(revoked, "revoked");
            return this;
        }

        public CustomObject build() {
            return CustomObject.validate(new CustomObject(this));
        }

        private boolean hydratedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean externalReferencesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean objectMarkingRefsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean granularMarkingsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean labelsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    @Generated(from="GenericCustomObject", generator="Immutables")
    private final class InitShim {
        private byte hydratedBuildStage = 0;
        private boolean hydrated;
        private byte createdBuildStage = 0;
        private StixInstant created;
        private byte externalReferencesBuildStage = 0;
        private ImmutableSet<ExternalReferenceType> externalReferences;
        private byte objectMarkingRefsBuildStage = 0;
        private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
        private byte granularMarkingsBuildStage = 0;
        private ImmutableSet<GranularMarkingDm> granularMarkings;
        private byte labelsBuildStage = 0;
        private ImmutableSet<String> labels;
        private byte modifiedBuildStage = 0;
        private StixInstant modified;
        private byte revokedBuildStage = 0;
        private StixBoolean revoked;

        private InitShim() {
        }

        boolean getHydrated() {
            if (this.hydratedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hydratedBuildStage == 0) {
                this.hydratedBuildStage = (byte)-1;
                this.hydrated = CustomObject.this.getHydratedInitialize();
                this.hydratedBuildStage = 1;
            }
            return this.hydrated;
        }

        void hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.hydratedBuildStage = 1;
        }

        StixInstant getCreated() {
            if (this.createdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdBuildStage == 0) {
                this.createdBuildStage = (byte)-1;
                this.created = Objects.requireNonNull(CustomObject.this.getCreatedInitialize(), "created");
                this.createdBuildStage = 1;
            }
            return this.created;
        }

        void created(StixInstant created) {
            this.created = created;
            this.createdBuildStage = 1;
        }

        ImmutableSet<ExternalReferenceType> getExternalReferences() {
            if (this.externalReferencesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.externalReferencesBuildStage == 0) {
                this.externalReferencesBuildStage = (byte)-1;
                this.externalReferences = ImmutableSet.copyOf((Collection)CustomObject.this.getExternalReferencesInitialize());
                this.externalReferencesBuildStage = 1;
            }
            return this.externalReferences;
        }

        void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
            this.externalReferences = externalReferences;
            this.externalReferencesBuildStage = 1;
        }

        ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
            if (this.objectMarkingRefsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMarkingRefsBuildStage == 0) {
                this.objectMarkingRefsBuildStage = (byte)-1;
                this.objectMarkingRefs = ImmutableSet.copyOf((Collection)CustomObject.this.getObjectMarkingRefsInitialize());
                this.objectMarkingRefsBuildStage = 1;
            }
            return this.objectMarkingRefs;
        }

        void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
            this.objectMarkingRefs = objectMarkingRefs;
            this.objectMarkingRefsBuildStage = 1;
        }

        ImmutableSet<GranularMarkingDm> getGranularMarkings() {
            if (this.granularMarkingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.granularMarkingsBuildStage == 0) {
                this.granularMarkingsBuildStage = (byte)-1;
                this.granularMarkings = ImmutableSet.copyOf((Collection)CustomObject.this.getGranularMarkingsInitialize());
                this.granularMarkingsBuildStage = 1;
            }
            return this.granularMarkings;
        }

        void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
            this.granularMarkings = granularMarkings;
            this.granularMarkingsBuildStage = 1;
        }

        ImmutableSet<String> getLabels() {
            if (this.labelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelsBuildStage == 0) {
                this.labelsBuildStage = (byte)-1;
                this.labels = ImmutableSet.copyOf((Collection)CustomObject.this.getLabelsInitialize());
                this.labelsBuildStage = 1;
            }
            return this.labels;
        }

        void labels(ImmutableSet<String> labels) {
            this.labels = labels;
            this.labelsBuildStage = 1;
        }

        StixInstant getModified() {
            if (this.modifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedBuildStage == 0) {
                this.modifiedBuildStage = (byte)-1;
                this.modified = Objects.requireNonNull(CustomObject.this.getModifiedInitialize(), "modified");
                this.modifiedBuildStage = 1;
            }
            return this.modified;
        }

        void modified(StixInstant modified) {
            this.modified = modified;
            this.modifiedBuildStage = 1;
        }

        StixBoolean getRevoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = Objects.requireNonNull(CustomObject.this.getRevokedInitialize(), "revoked");
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(StixBoolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.hydratedBuildStage == -1) {
                attributes.add("hydrated");
            }
            if (this.createdBuildStage == -1) {
                attributes.add("created");
            }
            if (this.externalReferencesBuildStage == -1) {
                attributes.add("externalReferences");
            }
            if (this.objectMarkingRefsBuildStage == -1) {
                attributes.add("objectMarkingRefs");
            }
            if (this.granularMarkingsBuildStage == -1) {
                attributes.add("granularMarkings");
            }
            if (this.labelsBuildStage == -1) {
                attributes.add("labels");
            }
            if (this.modifiedBuildStage == -1) {
                attributes.add("modified");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build CustomObject, attribute initializers form cycle " + attributes;
        }
    }
}

