/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.datamarkings.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.datamarkings.objects.StatementMarkingObject;
import security.whisper.javastix.redaction.Redactable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="statement")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="StatementMarkingObject", generator="Immutables")
@Immutable
public final class Statement
implements StatementMarkingObject {
    private final String statement;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private Statement(String statement, ImmutableMap<String, Object> customProperties) {
        this.statement = statement;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="statement")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getStatement() {
        return this.statement;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final Statement withStatement(String value) {
        if (Objects.equals(this.statement, value)) {
            return this;
        }
        return Statement.validate(new Statement(value, this.customProperties));
    }

    public final Statement withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return Statement.validate(new Statement(this.statement, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Statement && this.equalTo((Statement)another);
    }

    private boolean equalTo(Statement another) {
        return Objects.equals(this.statement, another.statement) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.statement);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StatementMarkingObject").omitNullValues().add("statement", (Object)this.statement).add("customProperties", this.customProperties).toString();
    }

    private static Statement validate(Statement instance) {
        instance.validateEntity();
        return instance;
    }

    public static Statement copyOf(StatementMarkingObject instance) {
        if (instance instanceof Statement) {
            return (Statement)instance;
        }
        return Statement.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Statement.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="statement")
    @Generated(from="StatementMarkingObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String statement;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StatementMarkingObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String statementValue;
            StixCustomProperties instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof StatementMarkingObject && (statementValue = (instance = (StatementMarkingObject)object).getStatement()) != null) {
                this.statement(statementValue);
            }
        }

        @JsonProperty(value="statement")
        @CanIgnoreReturnValue
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public Statement build() {
            return Statement.validate(new Statement(this.statement, this.customProperties.build()));
        }
    }
}

