/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.datamarkings.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.datamarkings.objects.TlpMarkingObject;
import security.whisper.javastix.redaction.Redactable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="tlp")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="TlpMarkingObject", generator="Immutables")
@Immutable
public final class Tlp
implements TlpMarkingObject {
    private final String tlp;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private Tlp(String tlp, ImmutableMap<String, Object> customProperties) {
        this.tlp = tlp;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="tlp")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getTlp() {
        return this.tlp;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final Tlp withTlp(String value) {
        if (Objects.equals(this.tlp, value)) {
            return this;
        }
        return Tlp.validate(new Tlp(value, this.customProperties));
    }

    public final Tlp withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return Tlp.validate(new Tlp(this.tlp, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Tlp && this.equalTo((Tlp)another);
    }

    private boolean equalTo(Tlp another) {
        return Objects.equals(this.tlp, another.tlp) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tlp);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TlpMarkingObject").omitNullValues().add("tlp", (Object)this.tlp).add("customProperties", this.customProperties).toString();
    }

    private static Tlp validate(Tlp instance) {
        instance.validateEntity();
        return instance;
    }

    public static Tlp copyOf(TlpMarkingObject instance) {
        if (instance instanceof Tlp) {
            return (Tlp)instance;
        }
        return Tlp.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Tlp.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="tlp")
    @Generated(from="TlpMarkingObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String tlp;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TlpMarkingObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tlpValue;
            StixCustomProperties instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof TlpMarkingObject && (tlpValue = (instance = (TlpMarkingObject)object).getTlp()) != null) {
                this.tlp(tlpValue);
            }
        }

        @JsonProperty(value="tlp")
        @CanIgnoreReturnValue
        public final Builder tlp(String tlp) {
            this.tlp = tlp;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public Tlp build() {
            return Tlp.validate(new Tlp(this.tlp, this.customProperties.build()));
        }
    }
}

