/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.bundle.BundleObject;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.bundle.BundleObjectGraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.json.StixParsers;

public class StixGraphGenerator
implements GraphGenerator {
    private final BundleObject bundle;
    private final ObjectMapper jsonMapper = StixParsers.getJsonMapper();

    public StixGraphGenerator(BundleObject bundle) {
        this.bundle = bundle;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.addAll(new BundleObjectGraphGenerator(this.bundle).process());
        return elements;
    }

    public String toJson() {
        try {
            return this.jsonMapper.writeValueAsString(this.process());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

