/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.bundle;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.sdo.DomainObjectGraphGenerator;
import security.whisper.javastix.graph.sro.RelationshipSroGraphGenerator;
import security.whisper.javastix.graph.sro.SightingSroGraphGenerator;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sro.objects.RelationshipSro;
import security.whisper.javastix.sro.objects.SightingSro;

public class BundleableObjectGraphGenerator
implements GraphGenerator {
    private final BundleableObject object;

    public BundleableObjectGraphGenerator(BundleableObject object) {
        this.object = object;
    }

    public BundleableObject getObject() {
        return this.object;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> items = new HashSet<GraphElement>();
        Class<?> objectClass = this.object.getClass();
        if (DomainObject.class.isAssignableFrom(objectClass)) {
            items.addAll(new DomainObjectGraphGenerator((DomainObject)this.object).process());
        } else if (RelationshipSro.class.isAssignableFrom(objectClass)) {
            items.addAll(new RelationshipSroGraphGenerator((RelationshipSro)this.object).process());
        } else if (SightingSro.class.isAssignableFrom(objectClass)) {
            items.addAll(new SightingSroGraphGenerator((SightingSro)this.object).process());
        }
        return items;
    }
}

