/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.objects.AttackPatternSdo;

public class AttackPatternGraphGenerator
implements GraphGenerator {
    private final AttackPatternSdo attackPattern;

    public AttackPatternGraphGenerator(AttackPatternSdo attackPattern) {
        this.attackPattern = attackPattern;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        return elements;
    }

    private Node generateNode() {
        Node node = new Node(this.attackPattern.getId(), "attack-pattern", null, this.attackPattern);
        node.getData().setNodeLabel(this.attackPattern.getName());
        node.getData().setNodeColor("#FF5722");
        node.getData().setNodeShape("diamond");
        node.getData().setNodeIcon("attack");
        node.getData().getAdditionalProperties().put("name", this.attackPattern.getName());
        if (this.attackPattern.getDescription() != null) {
            node.getData().getAdditionalProperties().put("description", this.attackPattern.getDescription().orElse(""));
        }
        if (this.attackPattern.getKillChainPhases() != null && !this.attackPattern.getKillChainPhases().isEmpty()) {
            node.getData().getAdditionalProperties().put("kill_chain_phases", this.attackPattern.getKillChainPhases());
        }
        if (this.attackPattern.getExternalReferences() != null && !this.attackPattern.getExternalReferences().isEmpty()) {
            node.getData().getAdditionalProperties().put("external_references_count", this.attackPattern.getExternalReferences().size());
        }
        if (this.attackPattern.getExternalReferences() != null) {
            this.attackPattern.getExternalReferences().stream().filter(ref -> "capec".equalsIgnoreCase(ref.getSourceName())).findFirst().ifPresent(ref -> node.getData().getAdditionalProperties().put("capec_id", ref.getExternalId()));
        }
        return node;
    }
}

