/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.objects.CampaignSdo;

public class CampaignGraphGenerator
implements GraphGenerator {
    private final CampaignSdo campaign;

    public CampaignGraphGenerator(CampaignSdo campaign) {
        this.campaign = campaign;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        return elements;
    }

    private Node generateNode() {
        Node node = new Node(this.campaign.getId(), "campaign", null, this.campaign);
        node.getData().setNodeLabel(this.campaign.getName());
        node.getData().setNodeColor("#9C27B0");
        node.getData().setNodeShape("hexagon");
        node.getData().setNodeIcon("campaign");
        node.getData().getAdditionalProperties().put("name", this.campaign.getName());
        if (this.campaign.getDescription() != null) {
            node.getData().getAdditionalProperties().put("description", this.campaign.getDescription().orElse(""));
        }
        if (this.campaign.getObjective() != null) {
            node.getData().getAdditionalProperties().put("objective", this.campaign.getObjective().orElse(""));
        }
        if (this.campaign.getAliases() != null && !this.campaign.getAliases().isEmpty()) {
            node.getData().getAdditionalProperties().put("aliases", this.campaign.getAliases());
        }
        if (this.campaign.getFirstSeen() != null) {
            node.getData().getAdditionalProperties().put("first_seen", this.campaign.getFirstSeen().orElse(null));
        }
        if (this.campaign.getLastSeen() != null) {
            node.getData().getAdditionalProperties().put("last_seen", this.campaign.getLastSeen().orElse(null));
        }
        boolean isActive = false;
        if (this.campaign.getLastSeen() != null && this.campaign.getLastSeen().isPresent()) {
            isActive = true;
        }
        node.getData().getAdditionalProperties().put("is_active", isActive);
        return node;
    }
}

