/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.graph.sdo.AttackPatternGraphGenerator;
import security.whisper.javastix.graph.sdo.CampaignGraphGenerator;
import security.whisper.javastix.graph.sdo.IndicatorGraphGenerator;
import security.whisper.javastix.graph.sdo.InfrastructureGraphGenerator;
import security.whisper.javastix.graph.sdo.IntrusionSetGraphGenerator;
import security.whisper.javastix.graph.sdo.MalwareGraphGenerator;
import security.whisper.javastix.graph.sdo.ObservedDataGraphGenerator;
import security.whisper.javastix.graph.sdo.ThreatActorGraphGenerator;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.AttackPatternSdo;
import security.whisper.javastix.sdo.objects.CampaignSdo;
import security.whisper.javastix.sdo.objects.IndicatorSdo;
import security.whisper.javastix.sdo.objects.InfrastructureSdo;
import security.whisper.javastix.sdo.objects.IntrusionSetSdo;
import security.whisper.javastix.sdo.objects.MalwareSdo;
import security.whisper.javastix.sdo.objects.ObservedDataSdo;
import security.whisper.javastix.sdo.objects.ThreatActorSdo;

public class DomainObjectGraphGenerator
implements GraphGenerator {
    private final DomainObject object;

    public DomainObjectGraphGenerator(DomainObject object) {
        this.object = object;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        if (AttackPatternSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(new AttackPatternGraphGenerator((AttackPatternSdo)this.object).process());
        } else if (CampaignSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(new CampaignGraphGenerator((CampaignSdo)this.object).process());
        } else if (ThreatActorSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(new ThreatActorGraphGenerator((ThreatActorSdo)this.object).process());
        } else if (MalwareSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(new MalwareGraphGenerator((MalwareSdo)this.object).process());
        } else if (IndicatorSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(new IndicatorGraphGenerator((IndicatorSdo)this.object).process());
        } else if (InfrastructureSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(new InfrastructureGraphGenerator((InfrastructureSdo)this.object).process());
        } else if (IntrusionSetSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(new IntrusionSetGraphGenerator((IntrusionSetSdo)this.object).process());
        } else if (ObservedDataSdo.class.isAssignableFrom(this.object.getClass())) {
            elements.addAll(this.generateObservedDataGraphElements((ObservedDataSdo)this.object));
        } else {
            elements.add(this.generateDefaultNode());
        }
        return elements;
    }

    public DomainObject getObject() {
        return this.object;
    }

    private Node generateDefaultNode() {
        String type;
        Node node = new Node(this.object.getId(), this.object.getType(), null, this.object);
        switch (type = this.object.getType()) {
            case "tool": {
                node.getData().setNodeColor("#00BCD4");
                node.getData().setNodeShape("circle");
                node.getData().setNodeIcon("tool");
                break;
            }
            case "vulnerability": {
                node.getData().setNodeColor("#FFEB3B");
                node.getData().setNodeShape("ellipse");
                node.getData().setNodeIcon("vulnerability");
                break;
            }
            case "report": {
                node.getData().setNodeColor("#795548");
                node.getData().setNodeShape("document");
                node.getData().setNodeIcon("report");
                break;
            }
            case "identity": {
                node.getData().setNodeColor("#009688");
                node.getData().setNodeShape("circle");
                node.getData().setNodeIcon("identity");
                break;
            }
            case "location": {
                node.getData().setNodeColor("#8BC34A");
                node.getData().setNodeShape("marker");
                node.getData().setNodeIcon("location");
                break;
            }
            case "course-of-action": {
                node.getData().setNodeColor("#00E676");
                node.getData().setNodeShape("shield");
                node.getData().setNodeIcon("course-of-action");
                break;
            }
            case "grouping": {
                node.getData().setNodeColor("#E0E0E0");
                node.getData().setNodeShape("folder");
                node.getData().setNodeIcon("grouping");
                break;
            }
            case "note": {
                node.getData().setNodeColor("#FFF59D");
                node.getData().setNodeShape("note");
                node.getData().setNodeIcon("note");
                break;
            }
            case "opinion": {
                node.getData().setNodeColor("#CE93D8");
                node.getData().setNodeShape("bubble");
                node.getData().setNodeIcon("opinion");
                break;
            }
            case "incident": {
                node.getData().setNodeColor("#FF6B6B");
                node.getData().setNodeShape("alert");
                node.getData().setNodeIcon("incident");
                break;
            }
            case "malware-analysis": {
                node.getData().setNodeColor("#FFB74D");
                node.getData().setNodeShape("analysis");
                node.getData().setNodeIcon("malware-analysis");
                break;
            }
            default: {
                node.getData().setNodeColor("#90A4AE");
                node.getData().setNodeShape("circle");
            }
        }
        return node;
    }

    private Set<GraphElement> generateObservedDataGraphElements(ObservedDataSdo observedDataSdo) {
        return new ObservedDataGraphGenerator(observedDataSdo).process();
    }
}

