/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.pattern.StixPattern;
import security.whisper.javastix.pattern.StixPatternParser;
import security.whisper.javastix.sdo.objects.IndicatorSdo;

public class IndicatorGraphGenerator
implements GraphGenerator {
    private final IndicatorSdo indicator;

    public IndicatorGraphGenerator(IndicatorSdo indicator) {
        this.indicator = indicator;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        return elements;
    }

    private Node generateNode() {
        Node node = new Node(this.indicator.getId(), "indicator", null, this.indicator);
        String label = this.indicator.getName() != null ? this.indicator.getName().orElse("Indicator") : "Indicator";
        node.getData().setNodeLabel(label);
        String color = this.determineColorByValidity();
        node.getData().setNodeColor(color);
        node.getData().setNodeShape("square");
        node.getData().setNodeIcon("indicator");
        if (this.indicator.getName() != null) {
            node.getData().getAdditionalProperties().put("name", this.indicator.getName().orElse(""));
        }
        if (this.indicator.getDescription() != null) {
            node.getData().getAdditionalProperties().put("description", this.indicator.getDescription().orElse(""));
        }
        node.getData().getAdditionalProperties().put("pattern", this.indicator.getPattern());
        node.getData().getAdditionalProperties().put("pattern_type", this.indicator.getPatternType());
        node.getData().getAdditionalProperties().put("valid_from", this.indicator.getValidFrom());
        if (this.indicator.getValidUntil() != null && this.indicator.getValidUntil().isPresent()) {
            node.getData().getAdditionalProperties().put("valid_until", this.indicator.getValidUntil().get());
        }
        String validityStatus = this.determineValidityStatus();
        node.getData().getAdditionalProperties().put("validity_status", validityStatus);
        if (this.indicator.getIndicatorTypes() != null && !this.indicator.getIndicatorTypes().isEmpty()) {
            node.getData().getAdditionalProperties().put("indicator_types", this.indicator.getIndicatorTypes());
        }
        if (this.indicator.getLabels() != null && !this.indicator.getLabels().isEmpty()) {
            node.getData().getAdditionalProperties().put("labels", this.indicator.getLabels());
        }
        if (this.indicator.getConfidence() != null && this.indicator.getConfidence().isPresent()) {
            int confidence = this.indicator.getConfidence().get();
            node.getData().getAdditionalProperties().put("confidence", confidence);
            String confidenceLevel = confidence >= 75 ? "high" : (confidence >= 50 ? "medium" : "low");
            node.getData().getAdditionalProperties().put("confidence_level", confidenceLevel);
        }
        if (this.indicator.getKillChainPhases() != null && !this.indicator.getKillChainPhases().isEmpty()) {
            node.getData().getAdditionalProperties().put("kill_chain_phases", this.indicator.getKillChainPhases());
        }
        try {
            StixPattern pattern = StixPatternParser.parse(this.indicator.getPattern());
            if (pattern.isValid() && !pattern.getObservableTypes().isEmpty()) {
                node.getData().getAdditionalProperties().put("observable_types", pattern.getObservableTypes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }

    private String determineColorByValidity() {
        String validityStatus;
        switch (validityStatus = this.determineValidityStatus()) {
            case "active": {
                return "#4CAF50";
            }
            case "expired": {
                return "#9E9E9E";
            }
            case "future": {
                return "#2196F3";
            }
        }
        return "#FFC107";
    }

    private String determineValidityStatus() {
        if (this.indicator.getValidUntil() != null && this.indicator.getValidUntil().isPresent()) {
            return "active";
        }
        return "active";
    }
}

