/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.objects.InfrastructureSdo;

public class InfrastructureGraphGenerator
implements GraphGenerator {
    private final InfrastructureSdo infrastructure;

    public InfrastructureGraphGenerator(InfrastructureSdo infrastructure) {
        this.infrastructure = infrastructure;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        return elements;
    }

    private Node generateNode() {
        Node node = new Node(this.infrastructure.getId(), "infrastructure", null, this.infrastructure);
        node.getData().setNodeLabel(this.infrastructure.getName());
        node.getData().setNodeColor("#607D8B");
        node.getData().setNodeShape("rectangle");
        node.getData().setNodeIcon("infrastructure");
        node.getData().getAdditionalProperties().put("name", this.infrastructure.getName());
        if (this.infrastructure.getDescription() != null) {
            node.getData().getAdditionalProperties().put("description", this.infrastructure.getDescription().orElse(""));
        }
        if (this.infrastructure.getInfrastructureTypes() != null && !this.infrastructure.getInfrastructureTypes().isEmpty()) {
            node.getData().getAdditionalProperties().put("infrastructure_types", this.infrastructure.getInfrastructureTypes());
            String category = "unknown";
            for (String type : this.infrastructure.getInfrastructureTypes()) {
                if (type.contains("command-and-control") || type.contains("c2")) {
                    category = "c2";
                    node.getData().setNodeColor("#E91E63");
                    break;
                }
                if (type.contains("hosting")) {
                    category = "hosting";
                    continue;
                }
                if (!type.contains("botnet")) continue;
                category = "botnet";
                node.getData().setNodeColor("#AB47BC");
            }
            node.getData().getAdditionalProperties().put("infrastructure_category", category);
        }
        if (this.infrastructure.getAliases() != null && !this.infrastructure.getAliases().isEmpty()) {
            node.getData().getAdditionalProperties().put("aliases", this.infrastructure.getAliases());
        }
        if (this.infrastructure.getKillChainPhases() != null && !this.infrastructure.getKillChainPhases().isEmpty()) {
            node.getData().getAdditionalProperties().put("kill_chain_phases", this.infrastructure.getKillChainPhases());
        }
        if (this.infrastructure.getFirstSeen() != null) {
            node.getData().getAdditionalProperties().put("first_seen", this.infrastructure.getFirstSeen().orElse(null));
        }
        if (this.infrastructure.getLastSeen() != null) {
            node.getData().getAdditionalProperties().put("last_seen", this.infrastructure.getLastSeen().orElse(null));
        }
        return node;
    }
}

