/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.objects.IntrusionSetSdo;

public class IntrusionSetGraphGenerator
implements GraphGenerator {
    private final IntrusionSetSdo intrusionSet;

    public IntrusionSetGraphGenerator(IntrusionSetSdo intrusionSet) {
        this.intrusionSet = intrusionSet;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        return elements;
    }

    private Node generateNode() {
        Node node = new Node(this.intrusionSet.getId(), "intrusion-set", null, this.intrusionSet);
        node.getData().setNodeLabel(this.intrusionSet.getName());
        node.getData().setNodeColor("#3F51B5");
        node.getData().setNodeShape("star");
        node.getData().setNodeIcon("intrusion-set");
        node.getData().setNodeSize("large");
        node.getData().getAdditionalProperties().put("name", this.intrusionSet.getName());
        if (this.intrusionSet.getDescription() != null) {
            node.getData().getAdditionalProperties().put("description", this.intrusionSet.getDescription().orElse(""));
        }
        if (this.intrusionSet.getAliases() != null && !this.intrusionSet.getAliases().isEmpty()) {
            node.getData().getAdditionalProperties().put("aliases", this.intrusionSet.getAliases());
            node.getData().getAdditionalProperties().put("aliases_count", this.intrusionSet.getAliases().size());
            for (String alias : this.intrusionSet.getAliases()) {
                if (!alias.toUpperCase().startsWith("APT")) continue;
                node.getData().getAdditionalProperties().put("is_apt_group", true);
                node.getData().setNodeColor("#B71C1C");
                break;
            }
        }
        if (this.intrusionSet.getGoals() != null && !this.intrusionSet.getGoals().isEmpty()) {
            node.getData().getAdditionalProperties().put("goals", this.intrusionSet.getGoals());
        }
        if (this.intrusionSet.getResourceLevel() != null) {
            node.getData().getAdditionalProperties().put("resource_level", this.intrusionSet.getResourceLevel().orElse(""));
            String resourceLevel = this.intrusionSet.getResourceLevel().orElse("");
            if (resourceLevel.contains("government") || resourceLevel.contains("organization")) {
                node.getData().setNodeSize("xlarge");
            }
        }
        if (this.intrusionSet.getPrimaryMotivation() != null) {
            node.getData().getAdditionalProperties().put("primary_motivation", this.intrusionSet.getPrimaryMotivation().orElse(""));
        }
        if (this.intrusionSet.getSecondaryMotivations() != null && !this.intrusionSet.getSecondaryMotivations().isEmpty()) {
            node.getData().getAdditionalProperties().put("secondary_motivations", this.intrusionSet.getSecondaryMotivations());
        }
        if (this.intrusionSet.getFirstSeen() != null) {
            node.getData().getAdditionalProperties().put("first_seen", this.intrusionSet.getFirstSeen().orElse(null));
        }
        if (this.intrusionSet.getLastSeen() != null) {
            node.getData().getAdditionalProperties().put("last_seen", this.intrusionSet.getLastSeen().orElse(null));
        }
        return node;
    }
}

