/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.objects.MalwareSdo;

public class MalwareGraphGenerator
implements GraphGenerator {
    private final MalwareSdo malware;

    public MalwareGraphGenerator(MalwareSdo malware) {
        this.malware = malware;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        return elements;
    }

    private Node generateNode() {
        Node node = new Node(this.malware.getId(), "malware", null, this.malware);
        node.getData().setNodeLabel(this.malware.getName());
        node.getData().setNodeColor("#FF9800");
        node.getData().setNodeShape("triangle");
        node.getData().setNodeIcon("malware");
        node.getData().getAdditionalProperties().put("name", this.malware.getName());
        if (this.malware.getDescription() != null) {
            node.getData().getAdditionalProperties().put("description", this.malware.getDescription().orElse(""));
        }
        if (this.malware.getLabels() != null && !this.malware.getLabels().isEmpty()) {
            node.getData().getAdditionalProperties().put("labels", this.malware.getLabels());
            String category = "unknown";
            for (String label : this.malware.getLabels()) {
                if (label.contains("ransomware")) {
                    category = "ransomware";
                    node.getData().setNodeColor("#D32F2F");
                    break;
                }
                if (label.contains("trojan")) {
                    category = "trojan";
                    continue;
                }
                if (label.contains("worm")) {
                    category = "worm";
                    continue;
                }
                if (label.contains("rootkit")) {
                    category = "rootkit";
                    continue;
                }
                if (!label.contains("backdoor")) continue;
                category = "backdoor";
            }
            node.getData().getAdditionalProperties().put("malware_category", category);
        }
        if (this.malware.getKillChainPhases() != null && !this.malware.getKillChainPhases().isEmpty()) {
            node.getData().getAdditionalProperties().put("kill_chain_phases", this.malware.getKillChainPhases());
        }
        return node;
    }
}

