/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.coo.CyberObservableGraphGenerator;
import security.whisper.javastix.graph.elements.Edge;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.objects.ObservedDataSdo;

public class ObservedDataGraphGenerator
implements GraphGenerator {
    private final ObservedDataSdo object;

    public ObservedDataGraphGenerator(ObservedDataSdo object) {
        this.object = object;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        elements.addAll(this.generateCooElements());
        return elements;
    }

    private Node generateNode() {
        return new Node(this.object.getId(), this.object.getType(), null, this.object);
    }

    public ObservedDataSdo getObject() {
        return this.object;
    }

    private Set<GraphElement> generateCooElements() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        String observedDataId = this.object.getId();
        this.object.getObjects().forEach(coo -> {
            Node cooGraphNode = new CyberObservableGraphGenerator(observedDataId, (CyberObservableObject)coo).generateNode();
            elements.add(cooGraphNode);
            String uuidPrefix = "ref";
            String uuid = uuidPrefix + "-" + UUID.randomUUID().toString();
            Edge edge = new Edge(uuid, uuidPrefix, observedDataId, cooGraphNode.getData().getId(), null);
            edge.getData().setEdgeLabel(coo.getType());
            edge.getData().getAdditionalProperties().put("ref_type", "cyber_observable");
            elements.add(edge);
        });
        return elements;
    }
}

