/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sdo;

import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.objects.ThreatActorSdo;

public class ThreatActorGraphGenerator
implements GraphGenerator {
    private final ThreatActorSdo threatActor;

    public ThreatActorGraphGenerator(ThreatActorSdo threatActor) {
        this.threatActor = threatActor;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        return elements;
    }

    private Node generateNode() {
        Node node = new Node(this.threatActor.getId(), "threat-actor", null, this.threatActor);
        node.getData().setNodeLabel(this.threatActor.getName());
        node.getData().setNodeColor("#F44336");
        node.getData().setNodeShape("octagon");
        node.getData().setNodeIcon("threat-actor");
        node.getData().setNodeSize("large");
        node.getData().getAdditionalProperties().put("name", this.threatActor.getName());
        if (this.threatActor.getDescription() != null) {
            node.getData().getAdditionalProperties().put("description", this.threatActor.getDescription().orElse(""));
        }
        if (this.threatActor.getLabels() != null && !this.threatActor.getLabels().isEmpty()) {
            node.getData().getAdditionalProperties().put("labels", this.threatActor.getLabels());
            String threatLevel = "unknown";
            if (this.threatActor.getLabels().contains("nation-state")) {
                threatLevel = "critical";
            } else if (this.threatActor.getLabels().contains("crime-syndicate")) {
                threatLevel = "high";
            } else if (this.threatActor.getLabels().contains("hacktivist")) {
                threatLevel = "medium";
            }
            node.getData().getAdditionalProperties().put("threat_level", threatLevel);
        }
        if (this.threatActor.getAliases() != null && !this.threatActor.getAliases().isEmpty()) {
            node.getData().getAdditionalProperties().put("aliases", this.threatActor.getAliases());
            node.getData().getAdditionalProperties().put("aliases_count", this.threatActor.getAliases().size());
        }
        if (this.threatActor.getRoles() != null && !this.threatActor.getRoles().isEmpty()) {
            node.getData().getAdditionalProperties().put("roles", this.threatActor.getRoles());
        }
        if (this.threatActor.getGoals() != null && !this.threatActor.getGoals().isEmpty()) {
            node.getData().getAdditionalProperties().put("goals", this.threatActor.getGoals());
        }
        if (this.threatActor.getSophistication() != null) {
            node.getData().getAdditionalProperties().put("sophistication", this.threatActor.getSophistication().orElse(""));
        }
        if (this.threatActor.getResourceLevel() != null) {
            node.getData().getAdditionalProperties().put("resource_level", this.threatActor.getResourceLevel().orElse(""));
        }
        if (this.threatActor.getPrimaryMotivation() != null) {
            node.getData().getAdditionalProperties().put("primary_motivation", this.threatActor.getPrimaryMotivation().orElse(""));
        }
        return node;
    }
}

