/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.graph.sro;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import security.whisper.javastix.graph.GraphGenerator;
import security.whisper.javastix.graph.elements.Edge;
import security.whisper.javastix.graph.elements.GraphElement;
import security.whisper.javastix.graph.elements.Node;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.ObservedDataSdo;
import security.whisper.javastix.sro.objects.SightingSro;

public class SightingSroGraphGenerator
implements GraphGenerator {
    private final SightingSro object;

    public SightingSroGraphGenerator(SightingSro object) {
        this.object = object;
    }

    public SightingSro getObject() {
        return this.object;
    }

    @Override
    public Set<GraphElement> process() {
        HashSet<GraphElement> elements = new HashSet<GraphElement>();
        elements.add(this.generateNode());
        elements.addAll(this.generateEdges());
        return elements;
    }

    private Node generateNode() {
        return new Node(this.object.getId(), this.object.getType(), null, this.object);
    }

    private Set<Edge> generateEdges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        edges.add(this.generateSightingOfRefEdge(this.object.getSightingOfRef()));
        edges.addAll(this.generateObservedDataEdges(this.object.getId(), this.object.getObservedDataRefs()));
        return edges;
    }

    private Edge generateSightingOfRefEdge(DomainObject sightingOfRefDomainObject) {
        String uuidPrefix = "ref";
        DomainObject sor = this.object.getSightingOfRef();
        String sorUuid = uuidPrefix + "-" + UUID.randomUUID().toString();
        Edge edge = new Edge(sorUuid, uuidPrefix, this.object.getId(), sor.getId(), null);
        edge.getData().setEdgeLabel("sighting-of");
        edge.getData().getAdditionalProperties().put("ref_type", "sighting_of_ref");
        return edge;
    }

    private Set<Edge> generateObservedDataEdges(String sourceId, Set<ObservedDataSdo> observedDataSdoSet) {
        HashSet<Edge> edges = new HashSet<Edge>();
        observedDataSdoSet.forEach(od -> {
            String uuidPrefix = "ref";
            String odUuid = uuidPrefix + "-" + UUID.randomUUID().toString();
            Edge edge = new Edge(odUuid, uuidPrefix, sourceId, od.getId(), null);
            edge.getData().setEdgeLabel("observed-data");
            edge.getData().getAdditionalProperties().put("ref_type", "observed_data");
            edges.add(edge);
        });
        return edges;
    }
}

