/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.json;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import javax.validation.ValidationException;
import security.whisper.javastix.bundle.Bundle;
import security.whisper.javastix.bundle.BundleObject;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.Stix;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.extension.types.ArchiveFileExtension;
import security.whisper.javastix.coo.extension.types.HttpRequestExtension;
import security.whisper.javastix.coo.extension.types.IcmpExtension;
import security.whisper.javastix.coo.extension.types.NetworkSocketExtension;
import security.whisper.javastix.coo.extension.types.NtfsFileExtenstion;
import security.whisper.javastix.coo.extension.types.PdfFileExtension;
import security.whisper.javastix.coo.extension.types.RasterImageFileExtension;
import security.whisper.javastix.coo.extension.types.TcpExtension;
import security.whisper.javastix.coo.extension.types.UnixAccountExtension;
import security.whisper.javastix.coo.extension.types.WindowsPeBinaryFileExtension;
import security.whisper.javastix.coo.extension.types.WindowsProcessExtension;
import security.whisper.javastix.coo.extension.types.WindowsServiceExtension;
import security.whisper.javastix.coo.objects.Artifact;
import security.whisper.javastix.coo.objects.AutonomousSystem;
import security.whisper.javastix.coo.objects.Directory;
import security.whisper.javastix.coo.objects.DomainName;
import security.whisper.javastix.coo.objects.EmailAddress;
import security.whisper.javastix.coo.objects.EmailMessage;
import security.whisper.javastix.coo.objects.File;
import security.whisper.javastix.coo.objects.Ipv4Address;
import security.whisper.javastix.coo.objects.Ipv6Address;
import security.whisper.javastix.coo.objects.MacAddress;
import security.whisper.javastix.coo.objects.Mutex;
import security.whisper.javastix.coo.objects.NetworkTraffic;
import security.whisper.javastix.coo.objects.Process;
import security.whisper.javastix.coo.objects.Software;
import security.whisper.javastix.coo.objects.Url;
import security.whisper.javastix.coo.objects.UserAccount;
import security.whisper.javastix.coo.objects.WindowsRegistryKey;
import security.whisper.javastix.coo.objects.X509Certificate;
import security.whisper.javastix.datamarkings.MarkingDefinition;
import security.whisper.javastix.datamarkings.objects.Statement;
import security.whisper.javastix.datamarkings.objects.Tlp;
import security.whisper.javastix.json.StixBooleanDeserializer;
import security.whisper.javastix.json.StixBooleanSerializer;
import security.whisper.javastix.json.StixInstantDeserializer;
import security.whisper.javastix.json.StixInstantSerializer;
import security.whisper.javastix.json.StixParserValidationException;
import security.whisper.javastix.sdo.objects.AttackPattern;
import security.whisper.javastix.sdo.objects.Campaign;
import security.whisper.javastix.sdo.objects.CourseOfAction;
import security.whisper.javastix.sdo.objects.Identity;
import security.whisper.javastix.sdo.objects.Indicator;
import security.whisper.javastix.sdo.objects.IntrusionSet;
import security.whisper.javastix.sdo.objects.Malware;
import security.whisper.javastix.sdo.objects.ObservedData;
import security.whisper.javastix.sdo.objects.Report;
import security.whisper.javastix.sdo.objects.ThreatActor;
import security.whisper.javastix.sdo.objects.Tool;
import security.whisper.javastix.sdo.objects.Vulnerability;
import security.whisper.javastix.sro.objects.Relationship;
import security.whisper.javastix.sro.objects.Sighting;

public class StixParsers {
    private static ObjectMapper jsonMapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule()).registerModule((Module)StixParsers.generateStixSubTypesModule()).registerModule((Module)StixParsers.generateStixInstantModule()).registerModule((Module)StixParsers.generateStixBooleanModule());

    public static ObjectMapper generateJsonMapperBase() {
        return new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule());
    }

    public static ObjectMapper getJsonMapper() {
        return jsonMapper;
    }

    public static void setJsonMapper(ObjectMapper objectMapper) {
        jsonMapper = objectMapper;
    }

    public static SimpleModule generateStixSubTypesModule() {
        SimpleModule module = new SimpleModule();
        Class[] sdoClasses = new Class[]{AttackPattern.class, Campaign.class, CourseOfAction.class, Identity.class, Indicator.class, IntrusionSet.class, Malware.class, ObservedData.class, Report.class, ThreatActor.class, Tool.class, Vulnerability.class};
        Class[] sroClasses = new Class[]{Relationship.class, Sighting.class};
        Class[] dataMarkingClasses = new Class[]{MarkingDefinition.class, Statement.class, Tlp.class};
        Class[] bundleClasses = new Class[]{Bundle.class};
        Class[] cyberObservableClasses = new Class[]{Artifact.class, AutonomousSystem.class, Directory.class, DomainName.class, EmailAddress.class, EmailMessage.class, File.class, Ipv4Address.class, Ipv6Address.class, MacAddress.class, Mutex.class, NetworkTraffic.class, Process.class, Software.class, Url.class, UserAccount.class, WindowsRegistryKey.class, X509Certificate.class};
        Class[] cyberObservableExtensionClasses = new Class[]{ArchiveFileExtension.class, HttpRequestExtension.class, IcmpExtension.class, NetworkSocketExtension.class, NtfsFileExtenstion.class, PdfFileExtension.class, RasterImageFileExtension.class, TcpExtension.class, UnixAccountExtension.class, WindowsPeBinaryFileExtension.class, WindowsProcessExtension.class, WindowsServiceExtension.class};
        module.registerSubtypes(sdoClasses);
        module.registerSubtypes(sroClasses);
        module.registerSubtypes(dataMarkingClasses);
        module.registerSubtypes(bundleClasses);
        module.registerSubtypes(cyberObservableClasses);
        module.registerSubtypes(cyberObservableExtensionClasses);
        return module;
    }

    public static SimpleModule generateStixInstantModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(StixInstant.class, (JsonSerializer)new StixInstantSerializer());
        module.addDeserializer(StixInstant.class, (JsonDeserializer)new StixInstantDeserializer());
        return module;
    }

    public static SimpleModule generateStixBooleanModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(StixBoolean.class, (JsonSerializer)new StixBooleanSerializer());
        module.addDeserializer(StixBoolean.class, (JsonDeserializer)new StixBooleanDeserializer());
        return module;
    }

    public static BundleObject parseBundle(String bundleJsonString) throws IOException, StixParserValidationException {
        try {
            return (BundleObject)StixParsers.getJsonMapper().readValue(bundleJsonString, BundleObject.class);
        }
        catch (IOException ex) {
            if (ValidationException.class.isAssignableFrom(ex.getCause().getClass())) {
                throw new StixParserValidationException((ValidationException)ex.getCause());
            }
            throw ex;
        }
    }

    public static BundleableObject parseObject(String objectJsonString) throws IOException, StixParserValidationException {
        try {
            return (BundleableObject)StixParsers.getJsonMapper().readValue(objectJsonString, BundleableObject.class);
        }
        catch (IOException ex) {
            if (ValidationException.class.isAssignableFrom(ex.getCause().getClass())) {
                throw new StixParserValidationException((ValidationException)ex.getCause());
            }
            throw ex;
        }
    }

    public static <T extends Stix> T parse(String bundleJsonString, Class<T> stixClass) throws IOException, StixParserValidationException {
        try {
            return (T)((Stix)StixParsers.getJsonMapper().readValue(bundleJsonString, stixClass));
        }
        catch (IOException ex) {
            if (ValidationException.class.isAssignableFrom(ex.getCause().getClass())) {
                throw new StixParserValidationException((ValidationException)ex.getCause());
            }
            throw ex;
        }
    }
}

