/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.json.converters.dehydrated;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdConverter;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.json.StixParsers;

public class BundleableObjectConverter
extends StdConverter<String, BundleableObject> {
    public BundleableObject convert(String value) {
        String[] parsedValue = value.split("--");
        if (parsedValue.length == 2) {
            ObjectMapper mapper = StixParsers.getJsonMapper();
            ObjectNode node = mapper.createObjectNode();
            node.put("type", parsedValue[0]);
            node.put("id", value);
            node.put("hydrated", false);
            try {
                BundleableObject bundleableObject = (BundleableObject)mapper.treeToValue((TreeNode)node, BundleableObject.class);
                return bundleableObject;
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Cannot Parse Json: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("Id is not valid format, Cannot Parse Value: " + value);
    }
}

