/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.json.converters.dehydrated;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.json.StixParsers;

public class BundleableObjectSetConverter
extends StdConverter<Set<String>, Set<BundleableObject>> {
    public Set<BundleableObject> convert(Set<String> values) {
        HashSet<BundleableObject> bundleableObjectSet = new HashSet<BundleableObject>();
        values.forEach(v -> {
            String[] parsedValue = v.split("--");
            if (parsedValue.length == 2) {
                ObjectMapper mapper = StixParsers.getJsonMapper();
                ObjectNode node = mapper.createObjectNode();
                node.put("type", parsedValue[0]);
                node.put("id", v);
                node.put("hydrated", false);
                try {
                    BundleableObject bundleableObject = (BundleableObject)mapper.treeToValue((TreeNode)node, BundleableObject.class);
                    bundleableObjectSet.add(bundleableObject);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Cannot Parse Json: " + e.getMessage());
                }
            } else {
                throw new IllegalArgumentException("Id is not valid format, Cannot Parse Value: " + v);
            }
        });
        return bundleableObjectSet;
    }
}

