/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.json.converters.dehydrated;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.Optional;
import security.whisper.javastix.json.StixParsers;
import security.whisper.javastix.sdo.DomainObject;

public class DomainObjectOptionalConverter
extends StdConverter<String, Optional<DomainObject>> {
    public Optional<DomainObject> convert(String value) {
        String[] parsedValue = value.split("--");
        if (parsedValue.length == 2) {
            ObjectMapper mapper = StixParsers.getJsonMapper();
            ObjectNode node = mapper.createObjectNode();
            node.put("type", parsedValue[0]);
            node.put("id", value);
            node.put("hydrated", false);
            try {
                return Optional.ofNullable((DomainObject)mapper.treeToValue((TreeNode)node, DomainObject.class));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Cannot Parse Json: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("Id is not valid format, Cannot Parse Value: " + value);
    }
}

