/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.json.converters.dehydrated;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.HashSet;
import java.util.Set;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.StixParsers;

public class MarkingDefinitionSetConverter
extends StdConverter<Set<String>, Set<MarkingDefinitionDm>> {
    public Set<MarkingDefinitionDm> convert(Set<String> values) {
        HashSet<MarkingDefinitionDm> markDefSet = new HashSet<MarkingDefinitionDm>();
        values.forEach(v -> {
            String[] parsedValue = v.split("--");
            if (parsedValue.length == 2) {
                ObjectMapper mapper = StixParsers.getJsonMapper();
                ObjectNode node = mapper.createObjectNode();
                node.put("type", parsedValue[0]);
                node.put("id", v);
                node.put("hydrated", false);
                try {
                    MarkingDefinitionDm markingDef = (MarkingDefinitionDm)mapper.treeToValue((TreeNode)node, MarkingDefinitionDm.class);
                    markDefSet.add(markingDef);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Cannot Parse Json: " + e.getMessage());
                }
            } else {
                throw new IllegalArgumentException("Id is not valid format, Cannot Parse Value: " + v);
            }
        });
        return markDefSet;
    }
}

