/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.meta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.meta.ExtensionDefinition;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.types.ExternalReferenceType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="extension-definition")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="ExtensionDefinition", generator="Immutables")
@Immutable
public final class ExtensionDefinitionObject
implements ExtensionDefinition {
    private final String id;
    private final String specVersion;
    @Nullable
    private final String createdByRef;
    private final StixInstant created;
    private final StixInstant modified;
    @Nullable
    private final Boolean revoked;
    private final ImmutableSet<String> labels;
    @Nullable
    private final Integer confidence;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final String name;
    @Nullable
    private final String description;
    private final ImmutableMap<String, Object> schema;
    private final String version;
    private final ImmutableSet<String> extensionTypes;
    private final ImmutableSet<String> extensionProperties;
    private final boolean hydrated;
    private final String toJsonString;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private ExtensionDefinitionObject(Builder builder) {
        this.id = builder.id;
        this.createdByRef = builder.createdByRef;
        this.created = builder.created;
        this.modified = builder.modified;
        this.revoked = builder.revoked;
        this.labels = builder.labels.build();
        this.confidence = builder.confidence;
        this.externalReferences = builder.externalReferences.build();
        this.objectMarkingRefs = builder.objectMarkingRefs.build();
        this.granularMarkings = builder.granularMarkings.build();
        this.name = builder.name;
        this.description = builder.description;
        this.schema = builder.schema.build();
        this.version = builder.version;
        this.extensionTypes = builder.extensionTypes.build();
        this.extensionProperties = builder.extensionProperties.build();
        this.hydrated = builder.hydrated;
        this.toJsonString = builder.toJsonString;
        this.customProperties = builder.customProperties.build();
        this.specVersion = builder.specVersion != null ? builder.specVersion : Objects.requireNonNull(ExtensionDefinition.super.getSpecVersion(), "specVersion");
    }

    private ExtensionDefinitionObject(String id, String specVersion, @Nullable String createdByRef, StixInstant created, StixInstant modified, @Nullable Boolean revoked, ImmutableSet<String> labels, @Nullable Integer confidence, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, String name, @Nullable String description, ImmutableMap<String, Object> schema, String version, ImmutableSet<String> extensionTypes, ImmutableSet<String> extensionProperties, boolean hydrated, String toJsonString, ImmutableMap<String, Object> customProperties) {
        this.id = id;
        this.specVersion = specVersion;
        this.createdByRef = createdByRef;
        this.created = created;
        this.modified = modified;
        this.revoked = revoked;
        this.labels = labels;
        this.confidence = confidence;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.name = name;
        this.description = description;
        this.schema = schema;
        this.version = version;
        this.extensionTypes = extensionTypes;
        this.extensionProperties = extensionProperties;
        this.hydrated = hydrated;
        this.toJsonString = toJsonString;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Specifies the identifier for this Extension Definition object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="spec_version")
    @JsonPropertyDescription(value="The version of the STIX specification used to represent this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The ID of the identity that created this extension definition.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which this object was originally created.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        return this.created;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time at which this object was last modified.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        return this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property is a boolean that indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Boolean> getRevoked() {
        return Optional.ofNullable(this.revoked);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The labels property specifies a set of categorization labels.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="confidence")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The confidence property identifies the confidence that the creator has in the correctness of their data.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(this.confidence);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refer to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        return this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        return this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        return this.granularMarkings;
    }

    @Override
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of this extension.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A detailed description of this extension.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="schema")
    @JsonPropertyDescription(value="The JSON schema for this extension.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableMap<String, Object> getSchema() {
        return this.schema;
    }

    @Override
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="The version of this extension.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="extension_types")
    @JsonPropertyDescription(value="A list of the types of STIX Objects that this extension can be applied to.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getExtensionTypes() {
        return this.extensionTypes;
    }

    @JsonProperty(value="extension_properties")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of properties that this extension adds to the objects it extends.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getExtensionProperties() {
        return this.extensionProperties;
    }

    @Override
    @JsonProperty(value="hydrated")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public boolean getHydrated() {
        return this.hydrated;
    }

    @Override
    @JsonProperty(value="toJsonString")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String toJsonString() {
        return this.toJsonString;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final ExtensionDefinitionObject withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(value, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withSpecVersion(String value) {
        String newValue = Objects.requireNonNull(value, "specVersion");
        if (this.specVersion.equals(newValue)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, newValue, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withCreatedByRef(String value) {
        String newValue = Objects.requireNonNull(value, "createdByRef");
        if (Objects.equals(this.createdByRef, newValue)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, newValue, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withCreatedByRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.createdByRef, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, value, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, value, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, value, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withRevoked(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.revoked, newValue)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, newValue, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withRevoked(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.revoked, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, value, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, (ImmutableSet<String>)newValue, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, (ImmutableSet<String>)newValue, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withConfidence(int value) {
        Integer newValue = value;
        if (Objects.equals(this.confidence, newValue)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withConfidence(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.confidence, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, value, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, newValue, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, value, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withSchema(Map<String, ? extends Object> entries) {
        if (this.schema == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, (ImmutableMap<String, Object>)newValue, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withVersion(String value) {
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, value, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withExtensionTypes(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, (ImmutableSet<String>)newValue, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withExtensionTypes(Iterable<String> elements) {
        if (this.extensionTypes == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, (ImmutableSet<String>)newValue, this.extensionProperties, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withExtensionProperties(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, (ImmutableSet<String>)newValue, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withExtensionProperties(Iterable<String> elements) {
        if (this.extensionProperties == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, (ImmutableSet<String>)newValue, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, value, this.toJsonString, this.customProperties);
    }

    public final ExtensionDefinitionObject withToJsonString(String value) {
        if (Objects.equals(this.toJsonString, value)) {
            return this;
        }
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, value, this.customProperties);
    }

    public final ExtensionDefinitionObject withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ExtensionDefinitionObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.name, this.description, this.schema, this.version, this.extensionTypes, this.extensionProperties, this.hydrated, this.toJsonString, (ImmutableMap<String, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExtensionDefinitionObject && this.equalTo((ExtensionDefinitionObject)another);
    }

    private boolean equalTo(ExtensionDefinitionObject another) {
        return Objects.equals(this.id, another.id) && this.specVersion.equals(another.specVersion) && Objects.equals(this.createdByRef, another.createdByRef) && Objects.equals(this.created, another.created) && Objects.equals(this.modified, another.modified) && Objects.equals(this.revoked, another.revoked) && this.labels.equals(another.labels) && Objects.equals(this.confidence, another.confidence) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.schema.equals(another.schema) && Objects.equals(this.version, another.version) && this.extensionTypes.equals(another.extensionTypes) && this.extensionProperties.equals(another.extensionProperties) && this.hydrated == another.hydrated && Objects.equals(this.toJsonString, another.toJsonString) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.specVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.modified);
        h += (h << 5) + Objects.hashCode(this.revoked);
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + Objects.hashCode(this.confidence);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.schema.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + this.extensionTypes.hashCode();
        h += (h << 5) + this.extensionProperties.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.toJsonString);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExtensionDefinition").omitNullValues().add("id", (Object)this.id).add("specVersion", (Object)this.specVersion).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).add("labels", this.labels).add("confidence", (Object)this.confidence).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("name", (Object)this.name).add("description", (Object)this.description).add("schema", this.schema).add("version", (Object)this.version).add("extensionTypes", this.extensionTypes).add("extensionProperties", this.extensionProperties).add("hydrated", this.hydrated).add("toJsonString", (Object)this.toJsonString).add("customProperties", this.customProperties).toString();
    }

    public static ExtensionDefinitionObject copyOf(ExtensionDefinition instance) {
        if (instance instanceof ExtensionDefinitionObject) {
            return (ExtensionDefinitionObject)instance;
        }
        return ExtensionDefinitionObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="extension-definition")
    @JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "name", "description", "schema", "version", "extension_types", "extension_properties"})
    @Generated(from="ExtensionDefinition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String specVersion;
        @Nullable
        private String createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private StixInstant modified;
        @Nullable
        private Boolean revoked;
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        @Nullable
        private Integer confidence;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        @Nullable
        private String name;
        @Nullable
        private String description;
        private ImmutableMap.Builder<String, Object> schema = ImmutableMap.builder();
        @Nullable
        private String version;
        private ImmutableSet.Builder<String> extensionTypes = ImmutableSet.builder();
        private ImmutableSet.Builder<String> extensionProperties = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String toJsonString;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExtensionDefinition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                String toJsonStringValue;
                instance = (BundleableObject)object;
                if ((bits & 2L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 4L;
                }
                this.hydrated(instance.getHydrated());
                if ((bits & 1L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 1L;
                }
                if ((toJsonStringValue = instance.toJsonString()) != null) {
                    this.toJsonString(toJsonStringValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof ExtensionDefinition) {
                Optional<String> createdByRefOptional;
                StixInstant modifiedValue;
                String nameValue;
                String versionValue;
                Optional<Boolean> revokedOptional;
                Optional<String> descriptionOptional;
                Optional<Integer> confidenceOptional;
                instance = (ExtensionDefinition)object;
                this.putAllSchema(instance.getSchema());
                this.specVersion(instance.getSpecVersion());
                this.addAllExternalReferences(instance.getExternalReferences());
                this.addAllExtensionProperties(instance.getExtensionProperties());
                StixInstant createdValue = instance.getCreated();
                if (createdValue != null) {
                    this.created(createdValue);
                }
                if ((confidenceOptional = instance.getConfidence()).isPresent()) {
                    this.confidence(confidenceOptional);
                }
                if ((descriptionOptional = instance.getDescription()).isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((revokedOptional = instance.getRevoked()).isPresent()) {
                    this.revoked(revokedOptional);
                }
                if ((versionValue = instance.getVersion()) != null) {
                    this.version(versionValue);
                }
                this.addAllLabels(instance.getLabels());
                this.addAllExtensionTypes(instance.getExtensionTypes());
                if ((bits & 1L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 1L;
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((modifiedValue = instance.getModified()) != null) {
                    this.modified(modifiedValue);
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 2L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 4L;
                }
            }
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Specifies the identifier for this Extension Definition object.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="spec_version")
        @JsonPropertyDescription(value="The version of the STIX specification used to represent this object.")
        @CanIgnoreReturnValue
        public final Builder specVersion(String specVersion) {
            this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(String createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The ID of the identity that created this extension definition.")
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<String> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which this object was originally created.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = created;
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time at which this object was last modified.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = modified;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property is a boolean that indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(Optional<Boolean> revoked) {
            this.revoked = revoked.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The labels property specifies a set of categorization labels.")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder confidence(int confidence) {
            this.confidence = confidence;
            return this;
        }

        @JsonProperty(value="confidence")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The confidence property identifies the confidence that the creator has in the correctness of their data.")
        @CanIgnoreReturnValue
        public final Builder confidence(Optional<Integer> confidence) {
            this.confidence = confidence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refer to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            return this;
        }

        @JsonProperty(value="name")
        @JsonPropertyDescription(value="The name of this extension.")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A detailed description of this extension.")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSchema(String key, Object value) {
            this.schema.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSchema(Map.Entry<String, ? extends Object> entry) {
            this.schema.put(entry);
            return this;
        }

        @JsonProperty(value="schema")
        @JsonPropertyDescription(value="The JSON schema for this extension.")
        @CanIgnoreReturnValue
        public final Builder schema(Map<String, ? extends Object> entries) {
            this.schema = ImmutableMap.builder();
            return this.putAllSchema(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSchema(Map<String, ? extends Object> entries) {
            this.schema.putAll(entries);
            return this;
        }

        @JsonProperty(value="version")
        @JsonPropertyDescription(value="The version of this extension.")
        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensionType(@Nullable String element) {
            this.extensionTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensionTypes(String ... elements) {
            this.extensionTypes.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="extension_types")
        @JsonPropertyDescription(value="A list of the types of STIX Objects that this extension can be applied to.")
        @CanIgnoreReturnValue
        public final Builder extensionTypes(Iterable<String> elements) {
            this.extensionTypes = ImmutableSet.builder();
            return this.addAllExtensionTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensionTypes(Iterable<String> elements) {
            this.extensionTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensionProperty(@Nullable String element) {
            this.extensionProperties.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensionProperties(String ... elements) {
            this.extensionProperties.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="extension_properties")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of properties that this extension adds to the objects it extends.")
        @CanIgnoreReturnValue
        public final Builder extensionProperties(Iterable<String> elements) {
            this.extensionProperties = ImmutableSet.builder();
            return this.addAllExtensionProperties(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensionProperties(Iterable<String> elements) {
            this.extensionProperties.addAll(elements);
            return this;
        }

        @JsonProperty(value="hydrated")
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            return this;
        }

        @JsonProperty(value="toJsonString")
        @CanIgnoreReturnValue
        public final Builder toJsonString(String toJsonString) {
            this.toJsonString = toJsonString;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public ExtensionDefinitionObject build() {
            return new ExtensionDefinitionObject(this);
        }
    }
}

