/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.meta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.Stix;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.meta.LanguageContentObject;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@JsonTypeName(value="language-content")
@DefaultTypeValue(value="language-content", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=LanguageContentObject.class)
@JsonDeserialize(builder=LanguageContentObject.Builder.class)
@JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "object_ref", "object_modified", "contents"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"LanguageContent"}, typeImmutable="LanguageContentObject", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface LanguageContent
extends Serializable,
BundleableObject,
StixCustomProperties,
Stix {
    @Override
    @NotBlank
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object. The value must be 'language-content'.")
    @Pattern(regexp="^language-content$")
    default public @NotBlank @Pattern(regexp="^language-content$") String getType() {
        return "language-content";
    }

    @Override
    @NotBlank
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Specifies the identifier for this Language Content object.")
    @Pattern(regexp="^language-content--")
    public @NotBlank @Pattern(regexp="^language-content--") String getId();

    @JsonProperty(value="spec_version")
    @JsonPropertyDescription(value="The version of the STIX specification used to represent this object.")
    @NotNull
    @Value.Default
    default public String getSpecVersion() {
        return "2.1";
    }

    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The ID of the identity that created this language content object.")
    public Optional<String> getCreatedByRef();

    @NotNull
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which this object was originally created.")
    public StixInstant getCreated();

    @NotNull
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time at which this object was last modified.")
    public StixInstant getModified();

    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property is a boolean that indicates whether the object has been revoked.")
    public Optional<Boolean> getRevoked();

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The labels property specifies a set of categorization labels.")
    public Set<String> getLabels();

    @JsonProperty(value="confidence")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The confidence property identifies the confidence that the creator has in the correctness of their data.")
    public Optional<Integer> getConfidence();

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refer to non-STIX information.")
    public Set<ExternalReferenceType> getExternalReferences();

    @Override
    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    public Set<MarkingDefinitionDm> getObjectMarkingRefs();

    @Override
    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    public Set<GranularMarkingDm> getGranularMarkings();

    @NotBlank
    @JsonProperty(value="object_ref")
    @JsonPropertyDescription(value="Specifies the identifier of the object that this language content applies to.")
    public String getObjectRef();

    @NotNull
    @JsonProperty(value="object_modified")
    @JsonPropertyDescription(value="Specifies the modified time of the object that this language content applies to.")
    public StixInstant getObjectModified();

    @NotNull
    @JsonProperty(value="contents")
    @JsonPropertyDescription(value="A dictionary that captures the text content in different languages. The key is the language code and the value is a dictionary containing the translated content.")
    public Map<String, Map<String, String>> getContents();
}

