/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.meta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.meta.LanguageContent;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.types.ExternalReferenceType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="language-content")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="LanguageContent", generator="Immutables")
@Immutable
public final class LanguageContentObject
implements LanguageContent {
    private final String id;
    private final String specVersion;
    @Nullable
    private final String createdByRef;
    private final StixInstant created;
    private final StixInstant modified;
    @Nullable
    private final Boolean revoked;
    private final ImmutableSet<String> labels;
    @Nullable
    private final Integer confidence;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final String objectRef;
    private final StixInstant objectModified;
    private final ImmutableMap<String, Map<String, String>> contents;
    private final boolean hydrated;
    private final String toJsonString;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private LanguageContentObject(Builder builder) {
        this.id = builder.id;
        this.createdByRef = builder.createdByRef;
        this.created = builder.created;
        this.modified = builder.modified;
        this.revoked = builder.revoked;
        this.labels = builder.labels.build();
        this.confidence = builder.confidence;
        this.externalReferences = builder.externalReferences.build();
        this.objectMarkingRefs = builder.objectMarkingRefs.build();
        this.granularMarkings = builder.granularMarkings.build();
        this.objectRef = builder.objectRef;
        this.objectModified = builder.objectModified;
        this.contents = builder.contents.build();
        this.hydrated = builder.hydrated;
        this.toJsonString = builder.toJsonString;
        this.customProperties = builder.customProperties.build();
        this.specVersion = builder.specVersion != null ? builder.specVersion : Objects.requireNonNull(LanguageContent.super.getSpecVersion(), "specVersion");
    }

    private LanguageContentObject(String id, String specVersion, @Nullable String createdByRef, StixInstant created, StixInstant modified, @Nullable Boolean revoked, ImmutableSet<String> labels, @Nullable Integer confidence, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, String objectRef, StixInstant objectModified, ImmutableMap<String, Map<String, String>> contents, boolean hydrated, String toJsonString, ImmutableMap<String, Object> customProperties) {
        this.id = id;
        this.specVersion = specVersion;
        this.createdByRef = createdByRef;
        this.created = created;
        this.modified = modified;
        this.revoked = revoked;
        this.labels = labels;
        this.confidence = confidence;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.objectRef = objectRef;
        this.objectModified = objectModified;
        this.contents = contents;
        this.hydrated = hydrated;
        this.toJsonString = toJsonString;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Specifies the identifier for this Language Content object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="spec_version")
    @JsonPropertyDescription(value="The version of the STIX specification used to represent this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The ID of the identity that created this language content object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which this object was originally created.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        return this.created;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time at which this object was last modified.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        return this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property is a boolean that indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Boolean> getRevoked() {
        return Optional.ofNullable(this.revoked);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The labels property specifies a set of categorization labels.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="confidence")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The confidence property identifies the confidence that the creator has in the correctness of their data.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(this.confidence);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refer to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        return this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        return this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        return this.granularMarkings;
    }

    @Override
    @JsonProperty(value="object_ref")
    @JsonPropertyDescription(value="Specifies the identifier of the object that this language content applies to.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getObjectRef() {
        return this.objectRef;
    }

    @Override
    @JsonProperty(value="object_modified")
    @JsonPropertyDescription(value="Specifies the modified time of the object that this language content applies to.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getObjectModified() {
        return this.objectModified;
    }

    @JsonProperty(value="contents")
    @JsonPropertyDescription(value="A dictionary that captures the text content in different languages. The key is the language code and the value is a dictionary containing the translated content.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableMap<String, Map<String, String>> getContents() {
        return this.contents;
    }

    @Override
    @JsonProperty(value="hydrated")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public boolean getHydrated() {
        return this.hydrated;
    }

    @Override
    @JsonProperty(value="toJsonString")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String toJsonString() {
        return this.toJsonString;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final LanguageContentObject withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new LanguageContentObject(value, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withSpecVersion(String value) {
        String newValue = Objects.requireNonNull(value, "specVersion");
        if (this.specVersion.equals(newValue)) {
            return this;
        }
        return new LanguageContentObject(this.id, newValue, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withCreatedByRef(String value) {
        String newValue = Objects.requireNonNull(value, "createdByRef");
        if (Objects.equals(this.createdByRef, newValue)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, newValue, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withCreatedByRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.createdByRef, value)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, value, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, value, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, value, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withRevoked(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.revoked, newValue)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, newValue, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withRevoked(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.revoked, value)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, value, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, (ImmutableSet<String>)newValue, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, (ImmutableSet<String>)newValue, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withConfidence(int value) {
        Integer newValue = value;
        if (Objects.equals(this.confidence, newValue)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withConfidence(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.confidence, value)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withObjectRef(String value) {
        if (Objects.equals(this.objectRef, value)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, value, this.objectModified, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withObjectModified(StixInstant value) {
        if (this.objectModified == value) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, value, this.contents, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withContents(Map<String, ? extends Map<String, String>> entries) {
        if (this.contents == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, (ImmutableMap<String, Map<String, String>>)newValue, this.hydrated, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, value, this.toJsonString, this.customProperties);
    }

    public final LanguageContentObject withToJsonString(String value) {
        if (Objects.equals(this.toJsonString, value)) {
            return this;
        }
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, value, this.customProperties);
    }

    public final LanguageContentObject withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new LanguageContentObject(this.id, this.specVersion, this.createdByRef, this.created, this.modified, this.revoked, this.labels, this.confidence, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.objectRef, this.objectModified, this.contents, this.hydrated, this.toJsonString, (ImmutableMap<String, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LanguageContentObject && this.equalTo((LanguageContentObject)another);
    }

    private boolean equalTo(LanguageContentObject another) {
        return Objects.equals(this.id, another.id) && this.specVersion.equals(another.specVersion) && Objects.equals(this.createdByRef, another.createdByRef) && Objects.equals(this.created, another.created) && Objects.equals(this.modified, another.modified) && Objects.equals(this.revoked, another.revoked) && this.labels.equals(another.labels) && Objects.equals(this.confidence, another.confidence) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && Objects.equals(this.objectRef, another.objectRef) && Objects.equals(this.objectModified, another.objectModified) && this.contents.equals(another.contents) && this.hydrated == another.hydrated && Objects.equals(this.toJsonString, another.toJsonString) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.specVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.modified);
        h += (h << 5) + Objects.hashCode(this.revoked);
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + Objects.hashCode(this.confidence);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + Objects.hashCode(this.objectRef);
        h += (h << 5) + Objects.hashCode(this.objectModified);
        h += (h << 5) + this.contents.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.toJsonString);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LanguageContent").omitNullValues().add("id", (Object)this.id).add("specVersion", (Object)this.specVersion).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).add("labels", this.labels).add("confidence", (Object)this.confidence).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("objectRef", (Object)this.objectRef).add("objectModified", (Object)this.objectModified).add("contents", this.contents).add("hydrated", this.hydrated).add("toJsonString", (Object)this.toJsonString).add("customProperties", this.customProperties).toString();
    }

    public static LanguageContentObject copyOf(LanguageContent instance) {
        if (instance instanceof LanguageContentObject) {
            return (LanguageContentObject)instance;
        }
        return LanguageContentObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="language-content")
    @JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "object_ref", "object_modified", "contents"})
    @Generated(from="LanguageContent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String specVersion;
        @Nullable
        private String createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private StixInstant modified;
        @Nullable
        private Boolean revoked;
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        @Nullable
        private Integer confidence;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        @Nullable
        private String objectRef;
        @Nullable
        private StixInstant objectModified;
        private ImmutableMap.Builder<String, Map<String, String>> contents = ImmutableMap.builder();
        private boolean hydrated;
        @Nullable
        private String toJsonString;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(LanguageContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                String toJsonStringValue;
                instance = (BundleableObject)object;
                if ((bits & 2L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 4L;
                }
                this.hydrated(instance.getHydrated());
                if ((bits & 1L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 1L;
                }
                if ((toJsonStringValue = instance.toJsonString()) != null) {
                    this.toJsonString(toJsonStringValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof LanguageContent) {
                Optional<String> createdByRefOptional;
                StixInstant modifiedValue;
                Optional<Boolean> revokedOptional;
                StixInstant objectModifiedValue;
                Optional<Integer> confidenceOptional;
                StixInstant createdValue;
                instance = (LanguageContent)object;
                this.specVersion(instance.getSpecVersion());
                this.addAllExternalReferences(instance.getExternalReferences());
                String objectRefValue = instance.getObjectRef();
                if (objectRefValue != null) {
                    this.objectRef(objectRefValue);
                }
                if ((createdValue = instance.getCreated()) != null) {
                    this.created(createdValue);
                }
                if ((confidenceOptional = instance.getConfidence()).isPresent()) {
                    this.confidence(confidenceOptional);
                }
                if ((objectModifiedValue = instance.getObjectModified()) != null) {
                    this.objectModified(objectModifiedValue);
                }
                if ((revokedOptional = instance.getRevoked()).isPresent()) {
                    this.revoked(revokedOptional);
                }
                this.addAllLabels(instance.getLabels());
                this.putAllContents(instance.getContents());
                if ((bits & 1L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 1L;
                }
                if ((modifiedValue = instance.getModified()) != null) {
                    this.modified(modifiedValue);
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 2L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 4L;
                }
            }
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Specifies the identifier for this Language Content object.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="spec_version")
        @JsonPropertyDescription(value="The version of the STIX specification used to represent this object.")
        @CanIgnoreReturnValue
        public final Builder specVersion(String specVersion) {
            this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(String createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The ID of the identity that created this language content object.")
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<String> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which this object was originally created.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = created;
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time at which this object was last modified.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = modified;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property is a boolean that indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(Optional<Boolean> revoked) {
            this.revoked = revoked.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The labels property specifies a set of categorization labels.")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder confidence(int confidence) {
            this.confidence = confidence;
            return this;
        }

        @JsonProperty(value="confidence")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The confidence property identifies the confidence that the creator has in the correctness of their data.")
        @CanIgnoreReturnValue
        public final Builder confidence(Optional<Integer> confidence) {
            this.confidence = confidence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refer to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            return this;
        }

        @JsonProperty(value="object_ref")
        @JsonPropertyDescription(value="Specifies the identifier of the object that this language content applies to.")
        @CanIgnoreReturnValue
        public final Builder objectRef(String objectRef) {
            this.objectRef = objectRef;
            return this;
        }

        @JsonProperty(value="object_modified")
        @JsonPropertyDescription(value="Specifies the modified time of the object that this language content applies to.")
        @CanIgnoreReturnValue
        public final Builder objectModified(StixInstant objectModified) {
            this.objectModified = objectModified;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putContent(String key, Map<String, String> value) {
            this.contents.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putContent(Map.Entry<String, ? extends Map<String, String>> entry) {
            this.contents.put(entry);
            return this;
        }

        @JsonProperty(value="contents")
        @JsonPropertyDescription(value="A dictionary that captures the text content in different languages. The key is the language code and the value is a dictionary containing the translated content.")
        @CanIgnoreReturnValue
        public final Builder contents(Map<String, ? extends Map<String, String>> entries) {
            this.contents = ImmutableMap.builder();
            return this.putAllContents(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllContents(Map<String, ? extends Map<String, String>> entries) {
            this.contents.putAll(entries);
            return this;
        }

        @JsonProperty(value="hydrated")
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            return this;
        }

        @JsonProperty(value="toJsonString")
        @CanIgnoreReturnValue
        public final Builder toJsonString(String toJsonString) {
            this.toJsonString = toJsonString;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public LanguageContentObject build() {
            return new LanguageContentObject(this);
        }
    }
}

