/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import security.whisper.javastix.pattern.PatternExpression;
import security.whisper.javastix.pattern.StixPattern;
import security.whisper.javastix.pattern.expressions.ComparisonExpression;
import security.whisper.javastix.pattern.expressions.CompoundExpression;
import security.whisper.javastix.pattern.expressions.ListExpression;
import security.whisper.javastix.pattern.expressions.LiteralExpression;
import security.whisper.javastix.pattern.expressions.ObjectPathExpression;
import security.whisper.javastix.pattern.expressions.ObservationExpression;
import security.whisper.javastix.pattern.expressions.QualifiedExpression;

public class StixPatternParser {
    private static final Pattern OBSERVATION_PATTERN = Pattern.compile("\\[([^\\]]+)\\]");
    private static final Pattern COMPARISON_PATTERN = Pattern.compile("([\\w:._\\[\\]]+)\\s*(=|!=|>|<|>=|<=|IN|LIKE|MATCHES|ISSUBSET|ISSUPERSET)\\s*(.+)");
    private static final Pattern OBJECT_PATH_PATTERN = Pattern.compile("([a-z-]+):([\\w._\\[\\]]+)");
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("'([^']*)'");
    private static final Pattern LIST_PATTERN = Pattern.compile("\\(([^)]+)\\)");

    public static StixPattern parse(String patternString) {
        if (patternString == null || patternString.trim().isEmpty()) {
            return new StixPattern(patternString, null, Collections.emptyList(), false, Optional.of("Pattern string cannot be null or empty"));
        }
        try {
            String trimmed = patternString.trim();
            PatternExpression expression = StixPatternParser.parseExpression(trimmed);
            List<String> observableTypes = StixPatternParser.extractObservableTypes(expression);
            return new StixPattern(patternString, expression, observableTypes, true, Optional.empty());
        }
        catch (Exception e) {
            return new StixPattern(patternString, null, Collections.emptyList(), false, Optional.of("Failed to parse pattern: " + e.getMessage()));
        }
    }

    private static PatternExpression parseExpression(String expr) {
        if ((expr = expr.trim()).startsWith("[") && expr.endsWith("]")) {
            String inner = expr.substring(1, expr.length() - 1);
            return StixPatternParser.parseObservation(inner);
        }
        if (StixPatternParser.containsLogicalOperator(expr)) {
            return StixPatternParser.parseCompound(expr);
        }
        if (StixPatternParser.containsQualifier(expr)) {
            return StixPatternParser.parseQualified(expr);
        }
        return StixPatternParser.parseComparison(expr);
    }

    private static ObservationExpression parseObservation(String obs) {
        ComparisonExpression comparison = StixPatternParser.parseComparison(obs);
        return new ObservationExpression(comparison);
    }

    private static ComparisonExpression parseComparison(String comp) {
        Matcher matcher = COMPARISON_PATTERN.matcher(comp.trim());
        if (matcher.matches()) {
            String leftPath = matcher.group(1);
            String operator = matcher.group(2);
            String rightValue = matcher.group(3).trim();
            ObjectPathExpression left = StixPatternParser.parseObjectPath(leftPath);
            PatternExpression right = StixPatternParser.parseValue(rightValue);
            return new ComparisonExpression(left, operator, right);
        }
        throw new IllegalArgumentException("Invalid comparison expression: " + comp);
    }

    private static ObjectPathExpression parseObjectPath(String path) {
        Matcher matcher = OBJECT_PATH_PATTERN.matcher(path.trim());
        if (matcher.matches()) {
            String objectType = matcher.group(1);
            String propertyPath = matcher.group(2);
            return new ObjectPathExpression(objectType, propertyPath);
        }
        return new ObjectPathExpression(null, path.trim());
    }

    private static PatternExpression parseValue(String value) {
        Matcher stringMatcher = STRING_LITERAL_PATTERN.matcher(value = value.trim());
        if (stringMatcher.matches()) {
            return new LiteralExpression(stringMatcher.group(1), LiteralExpression.LiteralType.STRING);
        }
        if (value.startsWith("(") && value.endsWith(")")) {
            return StixPatternParser.parseList(value);
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return new LiteralExpression(value, LiteralExpression.LiteralType.BOOLEAN);
        }
        try {
            if (value.contains(".")) {
                Double.parseDouble(value);
                return new LiteralExpression(value, LiteralExpression.LiteralType.FLOAT);
            }
            Long.parseLong(value);
            return new LiteralExpression(value, LiteralExpression.LiteralType.INTEGER);
        }
        catch (NumberFormatException numberFormatException) {
            return new LiteralExpression(value, LiteralExpression.LiteralType.STRING);
        }
    }

    private static ListExpression parseList(String list) {
        String inner = list.substring(1, list.length() - 1);
        String[] items = inner.split(",");
        ArrayList<PatternExpression> values = new ArrayList<PatternExpression>();
        for (String item : items) {
            values.add(StixPatternParser.parseValue(item.trim()));
        }
        return new ListExpression(values);
    }

    private static CompoundExpression parseCompound(String expr) {
        if (expr.contains(" AND ")) {
            String[] parts = expr.split(" AND ", 2);
            PatternExpression left = StixPatternParser.parseExpression(parts[0]);
            PatternExpression right = StixPatternParser.parseExpression(parts[1]);
            return new CompoundExpression(CompoundExpression.Operator.AND, left, right);
        }
        if (expr.contains(" OR ")) {
            String[] parts = expr.split(" OR ", 2);
            PatternExpression left = StixPatternParser.parseExpression(parts[0]);
            PatternExpression right = StixPatternParser.parseExpression(parts[1]);
            return new CompoundExpression(CompoundExpression.Operator.OR, left, right);
        }
        throw new IllegalArgumentException("Invalid compound expression: " + expr);
    }

    private static QualifiedExpression parseQualified(String expr) {
        if (expr.contains(" WITHIN ")) {
            String[] parts = expr.split(" WITHIN ");
            PatternExpression observation = StixPatternParser.parseExpression(parts[0]);
            String timeWindow = parts[1].trim();
            return new QualifiedExpression(observation, QualifiedExpression.Qualifier.WITHIN, timeWindow);
        }
        throw new IllegalArgumentException("Qualified expression parsing not fully implemented: " + expr);
    }

    private static boolean containsLogicalOperator(String expr) {
        return expr.contains(" AND ") || expr.contains(" OR ");
    }

    private static boolean containsQualifier(String expr) {
        return expr.contains(" WITHIN ") || expr.contains(" START ") || expr.contains(" STOP ") || expr.contains(" REPEATS ");
    }

    private static List<String> extractObservableTypes(PatternExpression expression) {
        HashSet<String> types = new HashSet<String>();
        StixPatternParser.extractObservableTypesRecursive(expression, types);
        return new ArrayList<String>(types);
    }

    private static void extractObservableTypesRecursive(PatternExpression expr, Set<String> types) {
        if (expr == null) {
            return;
        }
        if (expr instanceof ObjectPathExpression) {
            ObjectPathExpression path = (ObjectPathExpression)expr;
            if (path.getObjectType() != null) {
                types.add(path.getObjectType());
            }
        } else if (expr instanceof ComparisonExpression) {
            ComparisonExpression comp = (ComparisonExpression)expr;
            StixPatternParser.extractObservableTypesRecursive(comp.getLeft(), types);
            StixPatternParser.extractObservableTypesRecursive(comp.getRight(), types);
        } else if (expr instanceof CompoundExpression) {
            CompoundExpression compound = (CompoundExpression)expr;
            StixPatternParser.extractObservableTypesRecursive(compound.getLeft(), types);
            StixPatternParser.extractObservableTypesRecursive(compound.getRight(), types);
        } else if (expr instanceof ObservationExpression) {
            ObservationExpression obs = (ObservationExpression)expr;
            StixPatternParser.extractObservableTypesRecursive(obs.getComparison(), types);
        } else if (expr instanceof QualifiedExpression) {
            QualifiedExpression qual = (QualifiedExpression)expr;
            StixPatternParser.extractObservableTypesRecursive(qual.getObservation(), types);
        }
    }
}

