/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.pattern.expressions;

import java.util.List;
import java.util.stream.Collectors;
import security.whisper.javastix.pattern.PatternExpression;
import security.whisper.javastix.pattern.PatternVisitor;

public class ListExpression
implements PatternExpression {
    private final List<PatternExpression> values;

    public ListExpression(List<PatternExpression> values) {
        this.values = values;
    }

    public List<PatternExpression> getValues() {
        return this.values;
    }

    @Override
    public <T> T accept(PatternVisitor<T> visitor) {
        return visitor.visitList(this);
    }

    @Override
    public PatternExpression.ExpressionType getType() {
        return PatternExpression.ExpressionType.LIST;
    }

    public String toString() {
        String items = this.values.stream().map(Object::toString).collect(Collectors.joining(", "));
        return "(" + items + ")";
    }
}

