/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.pattern.expressions;

import security.whisper.javastix.pattern.PatternExpression;
import security.whisper.javastix.pattern.PatternVisitor;

public class LiteralExpression
implements PatternExpression {
    private final String value;
    private final LiteralType literalType;

    public LiteralExpression(String value, LiteralType literalType) {
        this.value = value;
        this.literalType = literalType;
    }

    public String getValue() {
        return this.value;
    }

    public LiteralType getLiteralType() {
        return this.literalType;
    }

    @Override
    public <T> T accept(PatternVisitor<T> visitor) {
        return visitor.visitLiteral(this);
    }

    @Override
    public PatternExpression.ExpressionType getType() {
        return PatternExpression.ExpressionType.LITERAL;
    }

    public String toString() {
        if (this.literalType == LiteralType.STRING) {
            return "'" + this.value + "'";
        }
        return this.value;
    }

    public static enum LiteralType {
        STRING,
        INTEGER,
        FLOAT,
        BOOLEAN,
        TIMESTAMP,
        HEX;

    }
}

