/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Grouping;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.GroupingContext;

@JsonTypeName(value="grouping")
@DefaultTypeValue(value="grouping", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Grouping.class)
@JsonDeserialize(builder=Grouping.Builder.class)
@JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "name", "description", "context", "object_refs"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface GroupingSdo
extends DomainObject {
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A name used to identify the Grouping.")
    @Redactable
    public Optional<String> getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about the Grouping, potentially including a justification for the selection of the objects within the grouping.")
    @Redactable
    public Optional<String> getDescription();

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A short descriptor of the particular context shared by the content referenced by the Grouping. Open Vocabulary - grouping-context-ov")
    @Vocab(value=GroupingContext.class)
    @Redactable
    public Optional<String> getContext();

    @NotNull
    @Size(min=1)
    @JsonProperty(value="object_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies the list of STIX Objects that are referred to by this Grouping.")
    @Redactable
    public @NotNull @Size(min=1) Set<BundleableObject> getObjectRefs();
}

