/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Identity;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.IdentityClasses;
import security.whisper.javastix.vocabulary.vocabularies.IndustrySectors;

@JsonTypeName(value="identity")
@DefaultTypeValue(value="identity", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Identity.class)
@JsonDeserialize(builder=Identity.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "identity_class", "sectors", "contact_information"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface IdentitySdo
extends DomainObject {
    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of this Identity.")
    @Redactable(useMask=true)
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about the Identity.")
    @Redactable
    public Optional<String> getDescription();

    @NotBlank
    @Vocab(value=IdentityClasses.class)
    @JsonProperty(value="identity_class")
    @JsonPropertyDescription(value="The type of entity that this Identity describes, e.g., an individual or organization. Open Vocab - identity-class-ov")
    @Redactable(useMask=true)
    public String getIdentityClass();

    @NotNull
    @Vocab(value=IndustrySectors.class)
    @JsonProperty(value="sectors")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of sectors that this Identity belongs to. Open Vocab - industry-sector-ov")
    @Redactable
    @Value.Default
    default public Set<String> getSectors() {
        return Collections.emptySet();
    }

    @JsonProperty(value="contact_information")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The contact information (e-mail, phone number, etc.) for this Identity.")
    @Redactable
    public Optional<String> getContactInformation();
}

