/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Incident;
import security.whisper.javastix.sdo.types.KillChainPhaseType;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@JsonTypeName(value="incident")
@DefaultTypeValue(value="incident", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Incident.class)
@JsonDeserialize(builder=Incident.Builder.class)
@JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "name", "description", "kill_chain_phases", "first_seen", "last_seen", "impact"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface IncidentSdo
extends DomainObject {
    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="A name used to identify the Incident.")
    @Redactable
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about the Incident, potentially including its impact and handling.")
    @Redactable
    public Optional<String> getDescription();

    @JsonProperty(value="kill_chain_phases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of kill chain phases for which this Incident is used.")
    @Size(min=1)
    @Redactable
    public @Size(min=1) Set<KillChainPhaseType> getKillChainPhases();

    @JsonProperty(value="first_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Incident was first seen.")
    @Redactable
    public Optional<StixInstant> getFirstSeen();

    @JsonProperty(value="last_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Incident was last seen.")
    @Redactable
    public Optional<StixInstant> getLastSeen();

    @JsonProperty(value="impact")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description of the impact or potential impact of the Incident.")
    @Redactable
    public Optional<String> getImpact();
}

