/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.objects.IndicatorSdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sdo.types.KillChainPhaseType;
import security.whisper.javastix.sro.objects.RelationshipSro;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="indicator")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="IndicatorSdo", generator="Immutables")
@Immutable
public final class Indicator
implements IndicatorSdo {
    private final ImmutableSet<String> labels;
    private final ImmutableSet<String> indicatorTypes;
    @Nullable
    private final Integer confidence;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    private final String pattern;
    private final String patternType;
    private final StixInstant validFrom;
    @Nullable
    private final StixInstant validUntil;
    private final ImmutableSet<KillChainPhaseType> killChainPhases;
    private final ImmutableSet<RelationshipSro> relationships;
    private final boolean hydrated;
    private final String type;
    private final String id;
    @Nullable
    private final IdentitySdo createdByRef;
    private final StixInstant created;
    @Nullable
    private final String lang;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final ImmutableMap<String, Object> customProperties;
    private final StixInstant modified;
    private final StixBoolean revoked;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_STRING_LAZY_INIT_BIT = 1L;
    private transient String toJsonString;
    private static final long SPEC_VERSION_LAZY_INIT_BIT = 2L;
    private transient String specVersion;
    private static final long serialVersionUID = 1L;

    private Indicator(Builder builder) {
        this.labels = builder.labels.build();
        this.indicatorTypes = builder.indicatorTypes.build();
        this.confidence = builder.confidence;
        this.name = builder.name;
        this.description = builder.description;
        this.pattern = builder.pattern;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.killChainPhases = builder.killChainPhases.build();
        this.type = builder.type;
        this.id = builder.id;
        this.createdByRef = builder.createdByRef;
        this.lang = builder.lang;
        this.customProperties = builder.customProperties.build();
        if (builder.patternType != null) {
            this.initShim.patternType(builder.patternType);
        }
        if (builder.relationshipsIsSet()) {
            this.initShim.relationships((ImmutableSet<RelationshipSro>)builder.relationships.build());
        }
        if (builder.hydratedIsSet()) {
            this.initShim.hydrated(builder.hydrated);
        }
        if (builder.created != null) {
            this.initShim.created(builder.created);
        }
        if (builder.externalReferencesIsSet()) {
            this.initShim.externalReferences((ImmutableSet<ExternalReferenceType>)builder.externalReferences.build());
        }
        if (builder.objectMarkingRefsIsSet()) {
            this.initShim.objectMarkingRefs((ImmutableSet<MarkingDefinitionDm>)builder.objectMarkingRefs.build());
        }
        if (builder.granularMarkingsIsSet()) {
            this.initShim.granularMarkings((ImmutableSet<GranularMarkingDm>)builder.granularMarkings.build());
        }
        if (builder.modified != null) {
            this.initShim.modified(builder.modified);
        }
        if (builder.revoked != null) {
            this.initShim.revoked(builder.revoked);
        }
        this.patternType = this.initShim.getPatternType();
        this.relationships = this.initShim.getRelationships();
        this.hydrated = this.initShim.getHydrated();
        this.created = this.initShim.getCreated();
        this.externalReferences = this.initShim.getExternalReferences();
        this.objectMarkingRefs = this.initShim.getObjectMarkingRefs();
        this.granularMarkings = this.initShim.getGranularMarkings();
        this.modified = this.initShim.getModified();
        this.revoked = this.initShim.getRevoked();
        this.initShim = null;
    }

    private Indicator(ImmutableSet<String> labels, ImmutableSet<String> indicatorTypes, @Nullable Integer confidence, @Nullable String name, @Nullable String description, String pattern, String patternType, StixInstant validFrom, @Nullable StixInstant validUntil, ImmutableSet<KillChainPhaseType> killChainPhases, ImmutableSet<RelationshipSro> relationships, boolean hydrated, String type, String id, @Nullable IdentitySdo createdByRef, StixInstant created, @Nullable String lang, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, ImmutableMap<String, Object> customProperties, StixInstant modified, StixBoolean revoked) {
        this.labels = labels;
        this.indicatorTypes = indicatorTypes;
        this.confidence = confidence;
        this.name = name;
        this.description = description;
        this.pattern = pattern;
        this.patternType = patternType;
        this.validFrom = validFrom;
        this.validUntil = validUntil;
        this.killChainPhases = killChainPhases;
        this.relationships = relationships;
        this.hydrated = hydrated;
        this.type = type;
        this.id = id;
        this.createdByRef = createdByRef;
        this.created = created;
        this.lang = lang;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.customProperties = customProperties;
        this.modified = modified;
        this.revoked = revoked;
        this.initShim = null;
    }

    private String getPatternTypeInitialize() {
        return IndicatorSdo.super.getPatternType();
    }

    private Set<RelationshipSro> getRelationshipsInitialize() {
        return IndicatorSdo.super.getRelationships();
    }

    private boolean getHydratedInitialize() {
        return IndicatorSdo.super.getHydrated();
    }

    private StixInstant getCreatedInitialize() {
        return IndicatorSdo.super.getCreated();
    }

    private Set<ExternalReferenceType> getExternalReferencesInitialize() {
        return IndicatorSdo.super.getExternalReferences();
    }

    private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
        return IndicatorSdo.super.getObjectMarkingRefs();
    }

    private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
        return IndicatorSdo.super.getGranularMarkings();
    }

    private StixInstant getModifiedInitialize() {
        return IndicatorSdo.super.getModified();
    }

    private StixBoolean getRevokedInitialize() {
        return IndicatorSdo.super.getRevoked();
    }

    @JsonProperty(value="labels")
    @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the type of indicator. Open vocab - indicator-label-ov")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="indicator_types")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the type of indicator. Open vocab - indicator-type-ov")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getIndicatorTypes() {
        return this.indicatorTypes;
    }

    @Override
    @JsonProperty(value="confidence")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This field identifies the confidence that the creator has in the correctness of their data. The value ranges from 0 (no confidence) to 100 (complete confidence).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(this.confidence);
    }

    @Override
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The name used to identify the Indicator.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about this Indicator, potentially including its purpose and its key characteristics.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="pattern")
    @JsonPropertyDescription(value="The detection pattern for this indicator. The default language is STIX Patterning.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getPattern() {
        return this.pattern;
    }

    @Override
    @JsonProperty(value="pattern_type")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The pattern language used in this indicator. The default is 'stix' which represents STIX Patterning.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getPatternType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPatternType() : this.patternType;
    }

    @Override
    @JsonProperty(value="valid_from")
    @JsonPropertyDescription(value="The time from which this indicator should be considered valuable intelligence.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getValidFrom() {
        return this.validFrom;
    }

    @Override
    @JsonProperty(value="valid_until")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time at which this indicator should no longer be considered valuable intelligence.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<StixInstant> getValidUntil() {
        return Optional.ofNullable(this.validUntil);
    }

    @JsonProperty(value="kill_chain_phases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of kill chain phases for which this attack pattern is used.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<KillChainPhaseType> getKillChainPhases() {
        return this.killChainPhases;
    }

    @JsonProperty(value="relationships")
    @JsonIgnore
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<RelationshipSro> getRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRelationships() : this.relationships;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public boolean getHydrated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHydrated() : this.hydrated;
    }

    @Override
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
    @Redactable(useMask=true, redactionMask="identity--__REDACTED__")
    public Optional<IdentitySdo> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreated() : this.created;
    }

    @Override
    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getLang() {
        return Optional.ofNullable(this.lang);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExternalReferences() : this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMarkingRefs() : this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGranularMarkings() : this.granularMarkings;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getModified() : this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixBoolean getRevoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRevoked() : this.revoked;
    }

    public final Indicator withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Indicator.validate(new Indicator((ImmutableSet<String>)newValue, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Indicator.validate(new Indicator((ImmutableSet<String>)newValue, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withIndicatorTypes(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Indicator.validate(new Indicator(this.labels, (ImmutableSet<String>)newValue, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withIndicatorTypes(Iterable<String> elements) {
        if (this.indicatorTypes == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Indicator.validate(new Indicator(this.labels, (ImmutableSet<String>)newValue, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withConfidence(int value) {
        Integer newValue = value;
        if (Objects.equals(this.confidence, newValue)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, newValue, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withConfidence(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.confidence, value)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, value, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, newValue, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, value, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, newValue, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, value, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withPattern(String value) {
        if (Objects.equals(this.pattern, value)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, value, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withPatternType(String value) {
        String newValue = Objects.requireNonNull(value, "patternType");
        if (this.patternType.equals(newValue)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, newValue, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withValidFrom(StixInstant value) {
        if (this.validFrom == value) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, value, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withValidUntil(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "validUntil");
        if (this.validUntil == newValue) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, newValue, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withValidUntil(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.validUntil == value) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, value, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withKillChainPhases(KillChainPhaseType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, (ImmutableSet<KillChainPhaseType>)newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withKillChainPhases(Iterable<? extends KillChainPhaseType> elements) {
        if (this.killChainPhases == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, (ImmutableSet<KillChainPhaseType>)newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withRelationships(RelationshipSro ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withRelationships(Iterable<? extends RelationshipSro> elements) {
        if (this.relationships == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, value, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, value, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, value, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withCreatedByRef(IdentitySdo value) {
        IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
        if (this.createdByRef == newValue) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, newValue, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withCreatedByRef(Optional<? extends IdentitySdo> optional) {
        IdentitySdo value = optional.orElse(null);
        if (this.createdByRef == value) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, value, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "created");
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, newValue, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withLang(String value) {
        String newValue = Objects.requireNonNull(value, "lang");
        if (Objects.equals(this.lang, newValue)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withLang(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lang, value)) {
            return this;
        }
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.modified, this.revoked));
    }

    public final Indicator withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, (ImmutableMap<String, Object>)newValue, this.modified, this.revoked));
    }

    public final Indicator withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "modified");
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, newValue, this.revoked));
    }

    public final Indicator withRevoked(StixBoolean value) {
        if (this.revoked == value) {
            return this;
        }
        StixBoolean newValue = Objects.requireNonNull(value, "revoked");
        return Indicator.validate(new Indicator(this.labels, this.indicatorTypes, this.confidence, this.name, this.description, this.pattern, this.patternType, this.validFrom, this.validUntil, this.killChainPhases, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.modified, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Indicator && this.equalTo((Indicator)another);
    }

    private boolean equalTo(Indicator another) {
        return this.labels.equals(another.labels) && this.indicatorTypes.equals(another.indicatorTypes) && Objects.equals(this.confidence, another.confidence) && Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.pattern, another.pattern) && this.patternType.equals(another.patternType) && Objects.equals(this.validFrom, another.validFrom) && Objects.equals(this.validUntil, another.validUntil) && this.killChainPhases.equals(another.killChainPhases) && this.relationships.equals(another.relationships) && this.hydrated == another.hydrated && Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.createdByRef, another.createdByRef) && this.created.equals(another.created) && Objects.equals(this.lang, another.lang) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.customProperties.equals(another.customProperties) && this.modified.equals(another.modified) && this.revoked.equals(another.revoked);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.indicatorTypes.hashCode();
        h += (h << 5) + Objects.hashCode(this.confidence);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.pattern);
        h += (h << 5) + this.patternType.hashCode();
        h += (h << 5) + Objects.hashCode(this.validFrom);
        h += (h << 5) + Objects.hashCode(this.validUntil);
        h += (h << 5) + this.killChainPhases.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.lang);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.revoked.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Indicator").omitNullValues().add("labels", this.labels).add("indicatorTypes", this.indicatorTypes).add("confidence", (Object)this.confidence).add("name", (Object)this.name).add("description", (Object)this.description).add("pattern", (Object)this.pattern).add("patternType", (Object)this.patternType).add("validFrom", (Object)this.validFrom).add("validUntil", (Object)this.validUntil).add("killChainPhases", this.killChainPhases).add("relationships", this.relationships).add("hydrated", this.hydrated).add("type", (Object)this.type).add("id", (Object)this.id).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("lang", (Object)this.lang).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("customProperties", this.customProperties).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String toJsonString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Indicator indicator = this;
            synchronized (indicator) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJsonString = Objects.requireNonNull(IndicatorSdo.super.toJsonString(), "toJsonString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getSpecVersion() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Indicator indicator = this;
            synchronized (indicator) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.specVersion = Objects.requireNonNull(IndicatorSdo.super.getSpecVersion(), "specVersion");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.specVersion;
    }

    private static Indicator validate(Indicator instance) {
        instance.checkHydrationValidation();
        return instance;
    }

    public static Indicator copyOf(IndicatorSdo instance) {
        if (instance instanceof Indicator) {
            return (Indicator)instance;
        }
        return Indicator.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Indicator.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="indicator")
    @JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "indicator_types", "name", "description", "pattern", "pattern_type", "valid_from", "valid_until", "kill_chain_phases"})
    @Generated(from="IndicatorSdo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_RELATIONSHIPS = 1L;
        private static final long OPT_BIT_HYDRATED = 2L;
        private static final long OPT_BIT_EXTERNAL_REFERENCES = 4L;
        private static final long OPT_BIT_OBJECT_MARKING_REFS = 8L;
        private static final long OPT_BIT_GRANULAR_MARKINGS = 16L;
        private long optBits;
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        private ImmutableSet.Builder<String> indicatorTypes = ImmutableSet.builder();
        @Nullable
        private Integer confidence;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String pattern;
        @Nullable
        private String patternType;
        @Nullable
        private StixInstant validFrom;
        @Nullable
        private StixInstant validUntil;
        private ImmutableSet.Builder<KillChainPhaseType> killChainPhases = ImmutableSet.builder();
        private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private IdentitySdo createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private String lang;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        @Nullable
        private StixInstant modified;
        @Nullable
        private StixBoolean revoked;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixRevoked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(IndicatorSdo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixLabels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DomainObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                if ((bits & 0x10L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 8L;
                }
            }
            if (object instanceof StixCommonProperties) {
                Optional<String> langOptional;
                Optional<IdentitySdo> createdByRefOptional;
                instance = (StixCommonProperties)object;
                this.addAllExternalReferences(instance.getExternalReferences());
                if ((bits & 4L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 4L;
                }
                this.created(instance.getCreated());
                if ((bits & 8L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 8L;
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 0x10L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((langOptional = instance.getLang()).isPresent()) {
                    this.lang(langOptional);
                }
            }
            if (object instanceof StixRevoked) {
                instance = (StixRevoked)object;
                this.revoked(instance.getRevoked());
            }
            if (object instanceof IndicatorSdo) {
                Optional<StixInstant> validUntilOptional;
                Optional<String> descriptionOptional;
                Optional<String> nameOptional;
                String patternValue;
                instance = (IndicatorSdo)object;
                this.addAllIndicatorTypes(instance.getIndicatorTypes());
                this.addAllKillChainPhases(instance.getKillChainPhases());
                Optional<Integer> confidenceOptional = instance.getConfidence();
                if (confidenceOptional.isPresent()) {
                    this.confidence(confidenceOptional);
                }
                if ((patternValue = instance.getPattern()) != null) {
                    this.pattern(patternValue);
                }
                if ((nameOptional = instance.getName()).isPresent()) {
                    this.name(nameOptional);
                }
                if ((descriptionOptional = instance.getDescription()).isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((validUntilOptional = instance.getValidUntil()).isPresent()) {
                    this.validUntil(validUntilOptional);
                }
                this.patternType(instance.getPatternType());
                StixInstant validFromValue = instance.getValidFrom();
                if (validFromValue != null) {
                    this.validFrom(validFromValue);
                }
                if ((bits & 2L) == 0L) {
                    this.addAllLabels(instance.getLabels());
                    bits |= 2L;
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof StixLabels) {
                instance = (StixLabels)object;
                if ((bits & 2L) == 0L) {
                    this.addAllLabels(instance.getLabels());
                    bits |= 2L;
                }
            }
            if (object instanceof StixModified) {
                instance = (StixModified)object;
                this.modified(instance.getModified());
            }
            if (object instanceof DomainObject) {
                instance = (DomainObject)object;
                this.addAllRelationships(instance.getRelationships());
            }
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the type of indicator. Open vocab - indicator-label-ov")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIndicatorType(@Nullable String element) {
            this.indicatorTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIndicatorTypes(String ... elements) {
            this.indicatorTypes.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="indicator_types")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the type of indicator. Open vocab - indicator-type-ov")
        @CanIgnoreReturnValue
        public final Builder indicatorTypes(Iterable<String> elements) {
            this.indicatorTypes = ImmutableSet.builder();
            return this.addAllIndicatorTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllIndicatorTypes(Iterable<String> elements) {
            this.indicatorTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder confidence(int confidence) {
            this.confidence = confidence;
            return this;
        }

        @JsonProperty(value="confidence")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="This field identifies the confidence that the creator has in the correctness of their data. The value ranges from 0 (no confidence) to 100 (complete confidence).")
        @CanIgnoreReturnValue
        public final Builder confidence(Optional<Integer> confidence) {
            this.confidence = confidence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="name")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The name used to identify the Indicator.")
        @CanIgnoreReturnValue
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A description that provides more details and context about this Indicator, potentially including its purpose and its key characteristics.")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="pattern")
        @JsonPropertyDescription(value="The detection pattern for this indicator. The default language is STIX Patterning.")
        @CanIgnoreReturnValue
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @JsonProperty(value="pattern_type")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The pattern language used in this indicator. The default is 'stix' which represents STIX Patterning.")
        @CanIgnoreReturnValue
        public final Builder patternType(String patternType) {
            this.patternType = Objects.requireNonNull(patternType, "patternType");
            return this;
        }

        @JsonProperty(value="valid_from")
        @JsonPropertyDescription(value="The time from which this indicator should be considered valuable intelligence.")
        @CanIgnoreReturnValue
        public final Builder validFrom(StixInstant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validUntil(StixInstant validUntil) {
            this.validUntil = Objects.requireNonNull(validUntil, "validUntil");
            return this;
        }

        @JsonProperty(value="valid_until")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The time at which this indicator should no longer be considered valuable intelligence.")
        @CanIgnoreReturnValue
        public final Builder validUntil(Optional<? extends StixInstant> validUntil) {
            this.validUntil = validUntil.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKillChainPhase(@Nullable KillChainPhaseType element) {
            this.killChainPhases.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKillChainPhases(KillChainPhaseType ... elements) {
            this.killChainPhases.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="kill_chain_phases")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of kill chain phases for which this attack pattern is used.")
        @CanIgnoreReturnValue
        public final Builder killChainPhases(Iterable<? extends KillChainPhaseType> elements) {
            this.killChainPhases = ImmutableSet.builder();
            return this.addAllKillChainPhases(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKillChainPhases(Iterable<? extends KillChainPhaseType> elements) {
            this.killChainPhases.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationship(@Nullable RelationshipSro element) {
            this.relationships.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationships(RelationshipSro ... elements) {
            this.relationships.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="relationships")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships = ImmutableSet.builder();
            return this.addAllRelationships(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="type")
        @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(IdentitySdo createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lang(String lang) {
            this.lang = Objects.requireNonNull(lang, "lang");
            return this;
        }

        @JsonProperty(value="lang")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
        @CanIgnoreReturnValue
        public final Builder lang(Optional<String> lang) {
            this.lang = lang.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(StixBoolean revoked) {
            this.revoked = Objects.requireNonNull(revoked, "revoked");
            return this;
        }

        public Indicator build() {
            return Indicator.validate(new Indicator(this));
        }

        private boolean relationshipsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean hydratedIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean externalReferencesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean objectMarkingRefsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean granularMarkingsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    @Generated(from="IndicatorSdo", generator="Immutables")
    private final class InitShim {
        private byte patternTypeBuildStage = 0;
        private String patternType;
        private byte relationshipsBuildStage = 0;
        private ImmutableSet<RelationshipSro> relationships;
        private byte hydratedBuildStage = 0;
        private boolean hydrated;
        private byte createdBuildStage = 0;
        private StixInstant created;
        private byte externalReferencesBuildStage = 0;
        private ImmutableSet<ExternalReferenceType> externalReferences;
        private byte objectMarkingRefsBuildStage = 0;
        private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
        private byte granularMarkingsBuildStage = 0;
        private ImmutableSet<GranularMarkingDm> granularMarkings;
        private byte modifiedBuildStage = 0;
        private StixInstant modified;
        private byte revokedBuildStage = 0;
        private StixBoolean revoked;

        private InitShim() {
        }

        String getPatternType() {
            if (this.patternTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.patternTypeBuildStage == 0) {
                this.patternTypeBuildStage = (byte)-1;
                this.patternType = Objects.requireNonNull(Indicator.this.getPatternTypeInitialize(), "patternType");
                this.patternTypeBuildStage = 1;
            }
            return this.patternType;
        }

        void patternType(String patternType) {
            this.patternType = patternType;
            this.patternTypeBuildStage = 1;
        }

        ImmutableSet<RelationshipSro> getRelationships() {
            if (this.relationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipsBuildStage == 0) {
                this.relationshipsBuildStage = (byte)-1;
                this.relationships = ImmutableSet.copyOf((Collection)Indicator.this.getRelationshipsInitialize());
                this.relationshipsBuildStage = 1;
            }
            return this.relationships;
        }

        void relationships(ImmutableSet<RelationshipSro> relationships) {
            this.relationships = relationships;
            this.relationshipsBuildStage = 1;
        }

        boolean getHydrated() {
            if (this.hydratedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hydratedBuildStage == 0) {
                this.hydratedBuildStage = (byte)-1;
                this.hydrated = Indicator.this.getHydratedInitialize();
                this.hydratedBuildStage = 1;
            }
            return this.hydrated;
        }

        void hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.hydratedBuildStage = 1;
        }

        StixInstant getCreated() {
            if (this.createdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdBuildStage == 0) {
                this.createdBuildStage = (byte)-1;
                this.created = Objects.requireNonNull(Indicator.this.getCreatedInitialize(), "created");
                this.createdBuildStage = 1;
            }
            return this.created;
        }

        void created(StixInstant created) {
            this.created = created;
            this.createdBuildStage = 1;
        }

        ImmutableSet<ExternalReferenceType> getExternalReferences() {
            if (this.externalReferencesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.externalReferencesBuildStage == 0) {
                this.externalReferencesBuildStage = (byte)-1;
                this.externalReferences = ImmutableSet.copyOf((Collection)Indicator.this.getExternalReferencesInitialize());
                this.externalReferencesBuildStage = 1;
            }
            return this.externalReferences;
        }

        void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
            this.externalReferences = externalReferences;
            this.externalReferencesBuildStage = 1;
        }

        ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
            if (this.objectMarkingRefsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMarkingRefsBuildStage == 0) {
                this.objectMarkingRefsBuildStage = (byte)-1;
                this.objectMarkingRefs = ImmutableSet.copyOf((Collection)Indicator.this.getObjectMarkingRefsInitialize());
                this.objectMarkingRefsBuildStage = 1;
            }
            return this.objectMarkingRefs;
        }

        void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
            this.objectMarkingRefs = objectMarkingRefs;
            this.objectMarkingRefsBuildStage = 1;
        }

        ImmutableSet<GranularMarkingDm> getGranularMarkings() {
            if (this.granularMarkingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.granularMarkingsBuildStage == 0) {
                this.granularMarkingsBuildStage = (byte)-1;
                this.granularMarkings = ImmutableSet.copyOf((Collection)Indicator.this.getGranularMarkingsInitialize());
                this.granularMarkingsBuildStage = 1;
            }
            return this.granularMarkings;
        }

        void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
            this.granularMarkings = granularMarkings;
            this.granularMarkingsBuildStage = 1;
        }

        StixInstant getModified() {
            if (this.modifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedBuildStage == 0) {
                this.modifiedBuildStage = (byte)-1;
                this.modified = Objects.requireNonNull(Indicator.this.getModifiedInitialize(), "modified");
                this.modifiedBuildStage = 1;
            }
            return this.modified;
        }

        void modified(StixInstant modified) {
            this.modified = modified;
            this.modifiedBuildStage = 1;
        }

        StixBoolean getRevoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = Objects.requireNonNull(Indicator.this.getRevokedInitialize(), "revoked");
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(StixBoolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.patternTypeBuildStage == -1) {
                attributes.add("patternType");
            }
            if (this.relationshipsBuildStage == -1) {
                attributes.add("relationships");
            }
            if (this.hydratedBuildStage == -1) {
                attributes.add("hydrated");
            }
            if (this.createdBuildStage == -1) {
                attributes.add("created");
            }
            if (this.externalReferencesBuildStage == -1) {
                attributes.add("externalReferences");
            }
            if (this.objectMarkingRefsBuildStage == -1) {
                attributes.add("objectMarkingRefs");
            }
            if (this.granularMarkingsBuildStage == -1) {
                attributes.add("granularMarkings");
            }
            if (this.modifiedBuildStage == -1) {
                attributes.add("modified");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build Indicator, attribute initializers form cycle " + attributes;
        }
    }
}

