/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Indicator;
import security.whisper.javastix.sdo.types.KillChainPhaseType;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.IndicatorLabels;
import security.whisper.javastix.vocabulary.vocabularies.IndicatorTypes;

@JsonTypeName(value="indicator")
@DefaultTypeValue(value="indicator", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Indicator.class)
@JsonDeserialize(builder=Indicator.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "indicator_types", "name", "description", "pattern", "pattern_type", "valid_from", "valid_until", "kill_chain_phases"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface IndicatorSdo
extends DomainObject {
    @Override
    @NotNull
    @Size(min=1)
    @Vocab(value=IndicatorLabels.class)
    @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the type of indicator. Open vocab - indicator-label-ov")
    @Redactable(useMask=true)
    public @NotNull @Size(min=1) @Vocab(value=IndicatorLabels.class) Set<@Length(min=1) String> getLabels();

    @JsonProperty(value="indicator_types")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @Vocab(value=IndicatorTypes.class)
    @JsonPropertyDescription(value="This field is an Open Vocabulary that specifies the type of indicator. Open vocab - indicator-type-ov")
    @Redactable
    public Set<String> getIndicatorTypes();

    @JsonProperty(value="confidence")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This field identifies the confidence that the creator has in the correctness of their data. The value ranges from 0 (no confidence) to 100 (complete confidence).")
    @Redactable
    public Optional<Integer> getConfidence();

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The name used to identify the Indicator.")
    @Redactable
    public Optional<String> getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about this Indicator, potentially including its purpose and its key characteristics.")
    @Redactable
    public Optional<String> getDescription();

    @NotBlank
    @JsonProperty(value="pattern")
    @JsonPropertyDescription(value="The detection pattern for this indicator. The default language is STIX Patterning.")
    @Redactable(useMask=true)
    public String getPattern();

    @JsonProperty(value="pattern_type")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The pattern language used in this indicator. The default is 'stix' which represents STIX Patterning.")
    @Redactable
    @Value.Default
    default public String getPatternType() {
        return "stix";
    }

    @NotNull
    @JsonProperty(value="valid_from")
    @JsonPropertyDescription(value="The time from which this indicator should be considered valuable intelligence.")
    @Redactable(useMask=true)
    public StixInstant getValidFrom();

    @JsonProperty(value="valid_until")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time at which this indicator should no longer be considered valuable intelligence.")
    @Redactable
    public Optional<StixInstant> getValidUntil();

    @NotNull
    @JsonProperty(value="kill_chain_phases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of kill chain phases for which this attack pattern is used.")
    @Redactable
    public Set<KillChainPhaseType> getKillChainPhases();
}

