/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Infrastructure;
import security.whisper.javastix.sdo.types.KillChainPhaseType;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.InfrastructureTypes;

@JsonTypeName(value="infrastructure")
@DefaultTypeValue(value="infrastructure", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Infrastructure.class)
@JsonDeserialize(builder=Infrastructure.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "infrastructure_types", "aliases", "kill_chain_phases", "first_seen", "last_seen"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface InfrastructureSdo
extends DomainObject {
    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name used to identify the Infrastructure.")
    @Redactable
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A description that provides more details and context about the Infrastructure, potentially including its purpose and its key characteristics.")
    @Redactable
    public Optional<String> getDescription();

    @NotNull
    @Size(min=1)
    @Vocab(value=InfrastructureTypes.class)
    @JsonProperty(value="infrastructure_types")
    @JsonPropertyDescription(value="The type of infrastructure being described. Open Vocabulary: infrastructure-type-ov")
    @Redactable(useMask=true)
    public @NotNull @Size(min=1) @Vocab(value=InfrastructureTypes.class) Set<@Length(min=1) String> getInfrastructureTypes();

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Alternative names used to identify this Infrastructure.")
    @Redactable
    @Value.Default
    default public Set<String> getAliases() {
        return Collections.emptySet();
    }

    @JsonProperty(value="kill_chain_phases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of kill chain phases for which this Infrastructure is used.")
    @Redactable
    @Value.Default
    default public Set<KillChainPhaseType> getKillChainPhases() {
        return Collections.emptySet();
    }

    @JsonProperty(value="first_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Infrastructure was first seen performing malicious activities.")
    @Redactable
    public Optional<StixInstant> getFirstSeen();

    @JsonProperty(value="last_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Infrastructure was last seen performing malicious activities.")
    @Redactable
    public Optional<StixInstant> getLastSeen();
}

