/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.objects.IntrusionSetSdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sro.objects.RelationshipSro;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="intrusion-set")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="IntrusionSetSdo", generator="Immutables")
@Immutable
public final class IntrusionSet
implements IntrusionSetSdo {
    private final String name;
    @Nullable
    private final String description;
    private final ImmutableSet<String> aliases;
    @Nullable
    private final StixInstant firstSeen;
    @Nullable
    private final StixInstant lastSeen;
    private final ImmutableSet<String> goals;
    @Nullable
    private final String resourceLevel;
    @Nullable
    private final String primaryMotivation;
    private final ImmutableSet<String> secondaryMotivations;
    private final ImmutableSet<RelationshipSro> relationships;
    private final boolean hydrated;
    private final String type;
    private final String id;
    @Nullable
    private final IdentitySdo createdByRef;
    private final StixInstant created;
    @Nullable
    private final String lang;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<String> labels;
    private final StixInstant modified;
    private final StixBoolean revoked;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_STRING_LAZY_INIT_BIT = 1L;
    private transient String toJsonString;
    private static final long SPEC_VERSION_LAZY_INIT_BIT = 2L;
    private transient String specVersion;
    private static final long serialVersionUID = 1L;

    private IntrusionSet(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
        this.resourceLevel = builder.resourceLevel;
        this.primaryMotivation = builder.primaryMotivation;
        this.type = builder.type;
        this.id = builder.id;
        this.createdByRef = builder.createdByRef;
        this.lang = builder.lang;
        this.customProperties = builder.customProperties.build();
        if (builder.aliasesIsSet()) {
            this.initShim.aliases((ImmutableSet<String>)builder.aliases.build());
        }
        if (builder.goalsIsSet()) {
            this.initShim.goals((ImmutableSet<String>)builder.goals.build());
        }
        if (builder.secondaryMotivationsIsSet()) {
            this.initShim.secondaryMotivations((ImmutableSet<String>)builder.secondaryMotivations.build());
        }
        if (builder.relationshipsIsSet()) {
            this.initShim.relationships((ImmutableSet<RelationshipSro>)builder.relationships.build());
        }
        if (builder.hydratedIsSet()) {
            this.initShim.hydrated(builder.hydrated);
        }
        if (builder.created != null) {
            this.initShim.created(builder.created);
        }
        if (builder.externalReferencesIsSet()) {
            this.initShim.externalReferences((ImmutableSet<ExternalReferenceType>)builder.externalReferences.build());
        }
        if (builder.objectMarkingRefsIsSet()) {
            this.initShim.objectMarkingRefs((ImmutableSet<MarkingDefinitionDm>)builder.objectMarkingRefs.build());
        }
        if (builder.granularMarkingsIsSet()) {
            this.initShim.granularMarkings((ImmutableSet<GranularMarkingDm>)builder.granularMarkings.build());
        }
        if (builder.labelsIsSet()) {
            this.initShim.labels((ImmutableSet<String>)builder.labels.build());
        }
        if (builder.modified != null) {
            this.initShim.modified(builder.modified);
        }
        if (builder.revoked != null) {
            this.initShim.revoked(builder.revoked);
        }
        this.aliases = this.initShim.getAliases();
        this.goals = this.initShim.getGoals();
        this.secondaryMotivations = this.initShim.getSecondaryMotivations();
        this.relationships = this.initShim.getRelationships();
        this.hydrated = this.initShim.getHydrated();
        this.created = this.initShim.getCreated();
        this.externalReferences = this.initShim.getExternalReferences();
        this.objectMarkingRefs = this.initShim.getObjectMarkingRefs();
        this.granularMarkings = this.initShim.getGranularMarkings();
        this.labels = this.initShim.getLabels();
        this.modified = this.initShim.getModified();
        this.revoked = this.initShim.getRevoked();
        this.initShim = null;
    }

    private IntrusionSet(String name, @Nullable String description, ImmutableSet<String> aliases, @Nullable StixInstant firstSeen, @Nullable StixInstant lastSeen, ImmutableSet<String> goals, @Nullable String resourceLevel, @Nullable String primaryMotivation, ImmutableSet<String> secondaryMotivations, ImmutableSet<RelationshipSro> relationships, boolean hydrated, String type, String id, @Nullable IdentitySdo createdByRef, StixInstant created, @Nullable String lang, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, ImmutableMap<String, Object> customProperties, ImmutableSet<String> labels, StixInstant modified, StixBoolean revoked) {
        this.name = name;
        this.description = description;
        this.aliases = aliases;
        this.firstSeen = firstSeen;
        this.lastSeen = lastSeen;
        this.goals = goals;
        this.resourceLevel = resourceLevel;
        this.primaryMotivation = primaryMotivation;
        this.secondaryMotivations = secondaryMotivations;
        this.relationships = relationships;
        this.hydrated = hydrated;
        this.type = type;
        this.id = id;
        this.createdByRef = createdByRef;
        this.created = created;
        this.lang = lang;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.customProperties = customProperties;
        this.labels = labels;
        this.modified = modified;
        this.revoked = revoked;
        this.initShim = null;
    }

    private Set<String> getAliasesInitialize() {
        return IntrusionSetSdo.super.getAliases();
    }

    private Set<String> getGoalsInitialize() {
        return IntrusionSetSdo.super.getGoals();
    }

    private Set<String> getSecondaryMotivationsInitialize() {
        return IntrusionSetSdo.super.getSecondaryMotivations();
    }

    private Set<RelationshipSro> getRelationshipsInitialize() {
        return IntrusionSetSdo.super.getRelationships();
    }

    private boolean getHydratedInitialize() {
        return IntrusionSetSdo.super.getHydrated();
    }

    private StixInstant getCreatedInitialize() {
        return IntrusionSetSdo.super.getCreated();
    }

    private Set<ExternalReferenceType> getExternalReferencesInitialize() {
        return IntrusionSetSdo.super.getExternalReferences();
    }

    private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
        return IntrusionSetSdo.super.getObjectMarkingRefs();
    }

    private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
        return IntrusionSetSdo.super.getGranularMarkings();
    }

    private Set<String> getLabelsInitialize() {
        return IntrusionSetSdo.super.getLabels();
    }

    private StixInstant getModifiedInitialize() {
        return IntrusionSetSdo.super.getModified();
    }

    private StixBoolean getRevokedInitialize() {
        return IntrusionSetSdo.super.getRevoked();
    }

    @Override
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name used to identify the Intrusion Set.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Provides more context and details about the Intrusion Set object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Alternative names used to identify this Intrusion Set.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getAliases() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAliases() : this.aliases;
    }

    @Override
    @JsonProperty(value="first_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Intrusion Set was first seen.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<StixInstant> getFirstSeen() {
        return Optional.ofNullable(this.firstSeen);
    }

    @Override
    @JsonProperty(value="last_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Intrusion Set was last seen.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<StixInstant> getLastSeen() {
        return Optional.ofNullable(this.lastSeen);
    }

    @JsonProperty(value="goals")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The high level goals of this Intrusion Set, namely, what are they trying to do.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getGoals() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGoals() : this.goals;
    }

    @Override
    @JsonProperty(value="resource_level")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This defines the organizational level at which this Intrusion Set typically works. Open Vocab - attack-resource-level-ov")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getResourceLevel() {
        return Optional.ofNullable(this.resourceLevel);
    }

    @Override
    @JsonProperty(value="primary_motivation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The primary reason, motivation, or purpose behind this Intrusion Set. Open Vocab - attack-motivation-ov")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getPrimaryMotivation() {
        return Optional.ofNullable(this.primaryMotivation);
    }

    @JsonProperty(value="secondary_motivations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The secondary reasons, motivations, or purposes behind this Intrusion Set. Open Vocab - attack-motivation-ov")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getSecondaryMotivations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSecondaryMotivations() : this.secondaryMotivations;
    }

    @JsonProperty(value="relationships")
    @JsonIgnore
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<RelationshipSro> getRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRelationships() : this.relationships;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public boolean getHydrated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHydrated() : this.hydrated;
    }

    @Override
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
    @Redactable(useMask=true, redactionMask="identity--__REDACTED__")
    public Optional<IdentitySdo> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreated() : this.created;
    }

    @Override
    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getLang() {
        return Optional.ofNullable(this.lang);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExternalReferences() : this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMarkingRefs() : this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGranularMarkings() : this.granularMarkings;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabels() : this.labels;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getModified() : this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixBoolean getRevoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRevoked() : this.revoked;
    }

    public final IntrusionSet withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(value, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, newValue, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, value, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withAliases(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, (ImmutableSet<String>)newValue, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withAliases(Iterable<String> elements) {
        if (this.aliases == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, (ImmutableSet<String>)newValue, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withFirstSeen(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "firstSeen");
        if (this.firstSeen == newValue) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, newValue, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withFirstSeen(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.firstSeen == value) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, value, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withLastSeen(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "lastSeen");
        if (this.lastSeen == newValue) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, newValue, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withLastSeen(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.lastSeen == value) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, value, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withGoals(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, (ImmutableSet<String>)newValue, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withGoals(Iterable<String> elements) {
        if (this.goals == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, (ImmutableSet<String>)newValue, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withResourceLevel(String value) {
        String newValue = Objects.requireNonNull(value, "resourceLevel");
        if (Objects.equals(this.resourceLevel, newValue)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, newValue, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withResourceLevel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.resourceLevel, value)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, value, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withPrimaryMotivation(String value) {
        String newValue = Objects.requireNonNull(value, "primaryMotivation");
        if (Objects.equals(this.primaryMotivation, newValue)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, newValue, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withPrimaryMotivation(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.primaryMotivation, value)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, value, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withSecondaryMotivations(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, (ImmutableSet<String>)newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withSecondaryMotivations(Iterable<String> elements) {
        if (this.secondaryMotivations == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, (ImmutableSet<String>)newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withRelationships(RelationshipSro ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withRelationships(Iterable<? extends RelationshipSro> elements) {
        if (this.relationships == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, value, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, value, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, value, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withCreatedByRef(IdentitySdo value) {
        IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
        if (this.createdByRef == newValue) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, newValue, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withCreatedByRef(Optional<? extends IdentitySdo> optional) {
        IdentitySdo value = optional.orElse(null);
        if (this.createdByRef == value) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, value, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "created");
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, newValue, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withLang(String value) {
        String newValue = Objects.requireNonNull(value, "lang");
        if (Objects.equals(this.lang, newValue)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withLang(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lang, value)) {
            return this;
        }
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, (ImmutableMap<String, Object>)newValue, this.labels, this.modified, this.revoked));
    }

    public final IntrusionSet withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final IntrusionSet withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final IntrusionSet withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "modified");
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, newValue, this.revoked));
    }

    public final IntrusionSet withRevoked(StixBoolean value) {
        if (this.revoked == value) {
            return this;
        }
        StixBoolean newValue = Objects.requireNonNull(value, "revoked");
        return IntrusionSet.validate(new IntrusionSet(this.name, this.description, this.aliases, this.firstSeen, this.lastSeen, this.goals, this.resourceLevel, this.primaryMotivation, this.secondaryMotivations, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof IntrusionSet && this.equalTo((IntrusionSet)another);
    }

    private boolean equalTo(IntrusionSet another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && this.aliases.equals(another.aliases) && Objects.equals(this.firstSeen, another.firstSeen) && Objects.equals(this.lastSeen, another.lastSeen) && this.goals.equals(another.goals) && Objects.equals(this.resourceLevel, another.resourceLevel) && Objects.equals(this.primaryMotivation, another.primaryMotivation) && this.secondaryMotivations.equals(another.secondaryMotivations) && this.relationships.equals(another.relationships) && this.hydrated == another.hydrated && Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.createdByRef, another.createdByRef) && this.created.equals(another.created) && Objects.equals(this.lang, another.lang) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.customProperties.equals(another.customProperties) && this.labels.equals(another.labels) && this.modified.equals(another.modified) && this.revoked.equals(another.revoked);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.aliases.hashCode();
        h += (h << 5) + Objects.hashCode(this.firstSeen);
        h += (h << 5) + Objects.hashCode(this.lastSeen);
        h += (h << 5) + this.goals.hashCode();
        h += (h << 5) + Objects.hashCode(this.resourceLevel);
        h += (h << 5) + Objects.hashCode(this.primaryMotivation);
        h += (h << 5) + this.secondaryMotivations.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.lang);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.revoked.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IntrusionSet").omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("aliases", this.aliases).add("firstSeen", (Object)this.firstSeen).add("lastSeen", (Object)this.lastSeen).add("goals", this.goals).add("resourceLevel", (Object)this.resourceLevel).add("primaryMotivation", (Object)this.primaryMotivation).add("secondaryMotivations", this.secondaryMotivations).add("relationships", this.relationships).add("hydrated", this.hydrated).add("type", (Object)this.type).add("id", (Object)this.id).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("lang", (Object)this.lang).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("customProperties", this.customProperties).add("labels", this.labels).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String toJsonString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            IntrusionSet intrusionSet = this;
            synchronized (intrusionSet) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJsonString = Objects.requireNonNull(IntrusionSetSdo.super.toJsonString(), "toJsonString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getSpecVersion() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            IntrusionSet intrusionSet = this;
            synchronized (intrusionSet) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.specVersion = Objects.requireNonNull(IntrusionSetSdo.super.getSpecVersion(), "specVersion");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.specVersion;
    }

    private static IntrusionSet validate(IntrusionSet instance) {
        instance.checkHydrationValidation();
        return instance;
    }

    public static IntrusionSet copyOf(IntrusionSetSdo instance) {
        if (instance instanceof IntrusionSet) {
            return (IntrusionSet)instance;
        }
        return IntrusionSet.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return IntrusionSet.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="intrusion-set")
    @JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "aliases", "first_seen", "last_seen", "goals", "resource_level", "primary_motivation", "secondary_motivation"})
    @Generated(from="IntrusionSetSdo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_ALIASES = 1L;
        private static final long OPT_BIT_GOALS = 2L;
        private static final long OPT_BIT_SECONDARY_MOTIVATIONS = 4L;
        private static final long OPT_BIT_RELATIONSHIPS = 8L;
        private static final long OPT_BIT_HYDRATED = 16L;
        private static final long OPT_BIT_EXTERNAL_REFERENCES = 32L;
        private static final long OPT_BIT_OBJECT_MARKING_REFS = 64L;
        private static final long OPT_BIT_GRANULAR_MARKINGS = 128L;
        private static final long OPT_BIT_LABELS = 256L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private String description;
        private ImmutableSet.Builder<String> aliases = ImmutableSet.builder();
        @Nullable
        private StixInstant firstSeen;
        @Nullable
        private StixInstant lastSeen;
        private ImmutableSet.Builder<String> goals = ImmutableSet.builder();
        @Nullable
        private String resourceLevel;
        @Nullable
        private String primaryMotivation;
        private ImmutableSet.Builder<String> secondaryMotivations = ImmutableSet.builder();
        private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private IdentitySdo createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private String lang;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        @Nullable
        private StixInstant modified;
        @Nullable
        private StixBoolean revoked;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(IntrusionSetSdo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixRevoked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixLabels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DomainObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                if ((bits & 8L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
            }
            if (object instanceof StixCommonProperties) {
                Optional<String> langOptional;
                Optional<IdentitySdo> createdByRefOptional;
                instance = (StixCommonProperties)object;
                this.addAllExternalReferences(instance.getExternalReferences());
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                this.created(instance.getCreated());
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 8L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((langOptional = instance.getLang()).isPresent()) {
                    this.lang(langOptional);
                }
            }
            if (object instanceof IntrusionSetSdo) {
                Optional<String> descriptionOptional;
                String nameValue;
                Optional<String> primaryMotivationOptional;
                Optional<String> resourceLevelOptional;
                Optional<StixInstant> firstSeenOptional;
                instance = (IntrusionSetSdo)object;
                this.addAllAliases(instance.getAliases());
                Optional<StixInstant> lastSeenOptional = instance.getLastSeen();
                if (lastSeenOptional.isPresent()) {
                    this.lastSeen(lastSeenOptional);
                }
                if ((firstSeenOptional = instance.getFirstSeen()).isPresent()) {
                    this.firstSeen(firstSeenOptional);
                }
                if ((resourceLevelOptional = instance.getResourceLevel()).isPresent()) {
                    this.resourceLevel(resourceLevelOptional);
                }
                if ((primaryMotivationOptional = instance.getPrimaryMotivation()).isPresent()) {
                    this.primaryMotivation(primaryMotivationOptional);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((descriptionOptional = instance.getDescription()).isPresent()) {
                    this.description(descriptionOptional);
                }
                this.addAllSecondaryMotivations(instance.getSecondaryMotivations());
                this.addAllGoals(instance.getGoals());
            }
            if (object instanceof StixRevoked) {
                instance = (StixRevoked)object;
                this.revoked(instance.getRevoked());
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof StixLabels) {
                instance = (StixLabels)object;
                this.addAllLabels(instance.getLabels());
            }
            if (object instanceof StixModified) {
                instance = (StixModified)object;
                this.modified(instance.getModified());
            }
            if (object instanceof DomainObject) {
                instance = (DomainObject)object;
                this.addAllRelationships(instance.getRelationships());
            }
        }

        @JsonProperty(value="name")
        @JsonPropertyDescription(value="The name used to identify the Intrusion Set.")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Provides more context and details about the Intrusion Set object.")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAliase(@Nullable String element) {
            this.aliases.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAliases(String ... elements) {
            this.aliases.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="aliases")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Alternative names used to identify this Intrusion Set.")
        @CanIgnoreReturnValue
        public final Builder aliases(Iterable<String> elements) {
            this.aliases = ImmutableSet.builder();
            return this.addAllAliases(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAliases(Iterable<String> elements) {
            this.aliases.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder firstSeen(StixInstant firstSeen) {
            this.firstSeen = Objects.requireNonNull(firstSeen, "firstSeen");
            return this;
        }

        @JsonProperty(value="first_seen")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The time that this Intrusion Set was first seen.")
        @CanIgnoreReturnValue
        public final Builder firstSeen(Optional<? extends StixInstant> firstSeen) {
            this.firstSeen = firstSeen.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastSeen(StixInstant lastSeen) {
            this.lastSeen = Objects.requireNonNull(lastSeen, "lastSeen");
            return this;
        }

        @JsonProperty(value="last_seen")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The time that this Intrusion Set was last seen.")
        @CanIgnoreReturnValue
        public final Builder lastSeen(Optional<? extends StixInstant> lastSeen) {
            this.lastSeen = lastSeen.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGoal(@Nullable String element) {
            this.goals.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGoals(String ... elements) {
            this.goals.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="goals")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The high level goals of this Intrusion Set, namely, what are they trying to do.")
        @CanIgnoreReturnValue
        public final Builder goals(Iterable<String> elements) {
            this.goals = ImmutableSet.builder();
            return this.addAllGoals(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGoals(Iterable<String> elements) {
            this.goals.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resourceLevel(String resourceLevel) {
            this.resourceLevel = Objects.requireNonNull(resourceLevel, "resourceLevel");
            return this;
        }

        @JsonProperty(value="resource_level")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="This defines the organizational level at which this Intrusion Set typically works. Open Vocab - attack-resource-level-ov")
        @CanIgnoreReturnValue
        public final Builder resourceLevel(Optional<String> resourceLevel) {
            this.resourceLevel = resourceLevel.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder primaryMotivation(String primaryMotivation) {
            this.primaryMotivation = Objects.requireNonNull(primaryMotivation, "primaryMotivation");
            return this;
        }

        @JsonProperty(value="primary_motivation")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The primary reason, motivation, or purpose behind this Intrusion Set. Open Vocab - attack-motivation-ov")
        @CanIgnoreReturnValue
        public final Builder primaryMotivation(Optional<String> primaryMotivation) {
            this.primaryMotivation = primaryMotivation.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSecondaryMotivation(@Nullable String element) {
            this.secondaryMotivations.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSecondaryMotivations(String ... elements) {
            this.secondaryMotivations.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="secondary_motivations")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The secondary reasons, motivations, or purposes behind this Intrusion Set. Open Vocab - attack-motivation-ov")
        @CanIgnoreReturnValue
        public final Builder secondaryMotivations(Iterable<String> elements) {
            this.secondaryMotivations = ImmutableSet.builder();
            return this.addAllSecondaryMotivations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSecondaryMotivations(Iterable<String> elements) {
            this.secondaryMotivations.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationship(@Nullable RelationshipSro element) {
            this.relationships.add((Object)element);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationships(RelationshipSro ... elements) {
            this.relationships.add((Object[])elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="relationships")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships = ImmutableSet.builder();
            return this.addAllRelationships(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships.addAll(elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="type")
        @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(IdentitySdo createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lang(String lang) {
            this.lang = Objects.requireNonNull(lang, "lang");
            return this;
        }

        @JsonProperty(value="lang")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
        @CanIgnoreReturnValue
        public final Builder lang(Optional<String> lang) {
            this.lang = lang.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            this.optBits |= 0x40L;
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            this.optBits |= 0x80L;
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            this.optBits |= 0x80L;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            this.optBits |= 0x100L;
            return this;
        }

        @JsonProperty(value="labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            this.optBits |= 0x100L;
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(StixBoolean revoked) {
            this.revoked = Objects.requireNonNull(revoked, "revoked");
            return this;
        }

        public IntrusionSet build() {
            return IntrusionSet.validate(new IntrusionSet(this));
        }

        private boolean aliasesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean goalsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean secondaryMotivationsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean relationshipsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean hydratedIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean externalReferencesIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean objectMarkingRefsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean granularMarkingsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean labelsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }
    }

    @Generated(from="IntrusionSetSdo", generator="Immutables")
    private final class InitShim {
        private byte aliasesBuildStage = 0;
        private ImmutableSet<String> aliases;
        private byte goalsBuildStage = 0;
        private ImmutableSet<String> goals;
        private byte secondaryMotivationsBuildStage = 0;
        private ImmutableSet<String> secondaryMotivations;
        private byte relationshipsBuildStage = 0;
        private ImmutableSet<RelationshipSro> relationships;
        private byte hydratedBuildStage = 0;
        private boolean hydrated;
        private byte createdBuildStage = 0;
        private StixInstant created;
        private byte externalReferencesBuildStage = 0;
        private ImmutableSet<ExternalReferenceType> externalReferences;
        private byte objectMarkingRefsBuildStage = 0;
        private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
        private byte granularMarkingsBuildStage = 0;
        private ImmutableSet<GranularMarkingDm> granularMarkings;
        private byte labelsBuildStage = 0;
        private ImmutableSet<String> labels;
        private byte modifiedBuildStage = 0;
        private StixInstant modified;
        private byte revokedBuildStage = 0;
        private StixBoolean revoked;

        private InitShim() {
        }

        ImmutableSet<String> getAliases() {
            if (this.aliasesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aliasesBuildStage == 0) {
                this.aliasesBuildStage = (byte)-1;
                this.aliases = ImmutableSet.copyOf((Collection)IntrusionSet.this.getAliasesInitialize());
                this.aliasesBuildStage = 1;
            }
            return this.aliases;
        }

        void aliases(ImmutableSet<String> aliases) {
            this.aliases = aliases;
            this.aliasesBuildStage = 1;
        }

        ImmutableSet<String> getGoals() {
            if (this.goalsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.goalsBuildStage == 0) {
                this.goalsBuildStage = (byte)-1;
                this.goals = ImmutableSet.copyOf((Collection)IntrusionSet.this.getGoalsInitialize());
                this.goalsBuildStage = 1;
            }
            return this.goals;
        }

        void goals(ImmutableSet<String> goals) {
            this.goals = goals;
            this.goalsBuildStage = 1;
        }

        ImmutableSet<String> getSecondaryMotivations() {
            if (this.secondaryMotivationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.secondaryMotivationsBuildStage == 0) {
                this.secondaryMotivationsBuildStage = (byte)-1;
                this.secondaryMotivations = ImmutableSet.copyOf((Collection)IntrusionSet.this.getSecondaryMotivationsInitialize());
                this.secondaryMotivationsBuildStage = 1;
            }
            return this.secondaryMotivations;
        }

        void secondaryMotivations(ImmutableSet<String> secondaryMotivations) {
            this.secondaryMotivations = secondaryMotivations;
            this.secondaryMotivationsBuildStage = 1;
        }

        ImmutableSet<RelationshipSro> getRelationships() {
            if (this.relationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipsBuildStage == 0) {
                this.relationshipsBuildStage = (byte)-1;
                this.relationships = ImmutableSet.copyOf((Collection)IntrusionSet.this.getRelationshipsInitialize());
                this.relationshipsBuildStage = 1;
            }
            return this.relationships;
        }

        void relationships(ImmutableSet<RelationshipSro> relationships) {
            this.relationships = relationships;
            this.relationshipsBuildStage = 1;
        }

        boolean getHydrated() {
            if (this.hydratedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hydratedBuildStage == 0) {
                this.hydratedBuildStage = (byte)-1;
                this.hydrated = IntrusionSet.this.getHydratedInitialize();
                this.hydratedBuildStage = 1;
            }
            return this.hydrated;
        }

        void hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.hydratedBuildStage = 1;
        }

        StixInstant getCreated() {
            if (this.createdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdBuildStage == 0) {
                this.createdBuildStage = (byte)-1;
                this.created = Objects.requireNonNull(IntrusionSet.this.getCreatedInitialize(), "created");
                this.createdBuildStage = 1;
            }
            return this.created;
        }

        void created(StixInstant created) {
            this.created = created;
            this.createdBuildStage = 1;
        }

        ImmutableSet<ExternalReferenceType> getExternalReferences() {
            if (this.externalReferencesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.externalReferencesBuildStage == 0) {
                this.externalReferencesBuildStage = (byte)-1;
                this.externalReferences = ImmutableSet.copyOf((Collection)IntrusionSet.this.getExternalReferencesInitialize());
                this.externalReferencesBuildStage = 1;
            }
            return this.externalReferences;
        }

        void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
            this.externalReferences = externalReferences;
            this.externalReferencesBuildStage = 1;
        }

        ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
            if (this.objectMarkingRefsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMarkingRefsBuildStage == 0) {
                this.objectMarkingRefsBuildStage = (byte)-1;
                this.objectMarkingRefs = ImmutableSet.copyOf((Collection)IntrusionSet.this.getObjectMarkingRefsInitialize());
                this.objectMarkingRefsBuildStage = 1;
            }
            return this.objectMarkingRefs;
        }

        void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
            this.objectMarkingRefs = objectMarkingRefs;
            this.objectMarkingRefsBuildStage = 1;
        }

        ImmutableSet<GranularMarkingDm> getGranularMarkings() {
            if (this.granularMarkingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.granularMarkingsBuildStage == 0) {
                this.granularMarkingsBuildStage = (byte)-1;
                this.granularMarkings = ImmutableSet.copyOf((Collection)IntrusionSet.this.getGranularMarkingsInitialize());
                this.granularMarkingsBuildStage = 1;
            }
            return this.granularMarkings;
        }

        void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
            this.granularMarkings = granularMarkings;
            this.granularMarkingsBuildStage = 1;
        }

        ImmutableSet<String> getLabels() {
            if (this.labelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelsBuildStage == 0) {
                this.labelsBuildStage = (byte)-1;
                this.labels = ImmutableSet.copyOf((Collection)IntrusionSet.this.getLabelsInitialize());
                this.labelsBuildStage = 1;
            }
            return this.labels;
        }

        void labels(ImmutableSet<String> labels) {
            this.labels = labels;
            this.labelsBuildStage = 1;
        }

        StixInstant getModified() {
            if (this.modifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedBuildStage == 0) {
                this.modifiedBuildStage = (byte)-1;
                this.modified = Objects.requireNonNull(IntrusionSet.this.getModifiedInitialize(), "modified");
                this.modifiedBuildStage = 1;
            }
            return this.modified;
        }

        void modified(StixInstant modified) {
            this.modified = modified;
            this.modifiedBuildStage = 1;
        }

        StixBoolean getRevoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = Objects.requireNonNull(IntrusionSet.this.getRevokedInitialize(), "revoked");
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(StixBoolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.aliasesBuildStage == -1) {
                attributes.add("aliases");
            }
            if (this.goalsBuildStage == -1) {
                attributes.add("goals");
            }
            if (this.secondaryMotivationsBuildStage == -1) {
                attributes.add("secondaryMotivations");
            }
            if (this.relationshipsBuildStage == -1) {
                attributes.add("relationships");
            }
            if (this.hydratedBuildStage == -1) {
                attributes.add("hydrated");
            }
            if (this.createdBuildStage == -1) {
                attributes.add("created");
            }
            if (this.externalReferencesBuildStage == -1) {
                attributes.add("externalReferences");
            }
            if (this.objectMarkingRefsBuildStage == -1) {
                attributes.add("objectMarkingRefs");
            }
            if (this.granularMarkingsBuildStage == -1) {
                attributes.add("granularMarkings");
            }
            if (this.labelsBuildStage == -1) {
                attributes.add("labels");
            }
            if (this.modifiedBuildStage == -1) {
                attributes.add("modified");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build IntrusionSet, attribute initializers form cycle " + attributes;
        }
    }
}

