/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.IntrusionSet;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.AttackMotivations;
import security.whisper.javastix.vocabulary.vocabularies.AttackResourceLevels;

@JsonTypeName(value="intrusion-set")
@DefaultTypeValue(value="intrusion-set", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=IntrusionSet.class)
@JsonDeserialize(builder=IntrusionSet.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "aliases", "first_seen", "last_seen", "goals", "resource_level", "primary_motivation", "secondary_motivation"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface IntrusionSetSdo
extends DomainObject {
    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name used to identify the Intrusion Set.")
    @Redactable(useMask=true)
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Provides more context and details about the Intrusion Set object.")
    @Redactable
    public Optional<String> getDescription();

    @NotNull
    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Alternative names used to identify this Intrusion Set.")
    @Redactable
    @Value.Default
    default public Set<String> getAliases() {
        return Collections.emptySet();
    }

    @JsonProperty(value="first_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Intrusion Set was first seen.")
    @Redactable
    public Optional<StixInstant> getFirstSeen();

    @JsonProperty(value="last_seen")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The time that this Intrusion Set was last seen.")
    @Redactable
    public Optional<StixInstant> getLastSeen();

    @NotNull
    @JsonProperty(value="goals")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The high level goals of this Intrusion Set, namely, what are they trying to do.")
    @Redactable
    @Value.Default
    default public Set<String> getGoals() {
        return Collections.emptySet();
    }

    @JsonProperty(value="resource_level")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="This defines the organizational level at which this Intrusion Set typically works. Open Vocab - attack-resource-level-ov")
    @Redactable
    public Optional<@Vocab(value=AttackResourceLevels.class) String> getResourceLevel();

    @JsonProperty(value="primary_motivation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The primary reason, motivation, or purpose behind this Intrusion Set. Open Vocab - attack-motivation-ov")
    @Redactable
    public Optional<@Vocab(value=AttackMotivations.class) String> getPrimaryMotivation();

    @NotNull
    @Vocab(value=AttackMotivations.class)
    @JsonProperty(value="secondary_motivations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The secondary reasons, motivations, or purposes behind this Intrusion Set. Open Vocab - attack-motivation-ov")
    @Redactable
    @Value.Default
    default public Set<String> getSecondaryMotivations() {
        return Collections.emptySet();
    }
}

