/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.objects.LocationSdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sro.objects.RelationshipSro;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="location")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="LocationSdo", generator="Immutables")
@Immutable
public final class Location
implements LocationSdo {
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final Double latitude;
    @Nullable
    private final Double longitude;
    @Nullable
    private final Double precision;
    @Nullable
    private final String region;
    @Nullable
    private final String country;
    @Nullable
    private final String administrativeArea;
    @Nullable
    private final String city;
    @Nullable
    private final String streetAddress;
    @Nullable
    private final String postalCode;
    private final ImmutableSet<RelationshipSro> relationships;
    private final boolean hydrated;
    private final String type;
    private final String id;
    @Nullable
    private final IdentitySdo createdByRef;
    private final StixInstant created;
    @Nullable
    private final String lang;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<String> labels;
    private final StixInstant modified;
    private final StixBoolean revoked;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_STRING_LAZY_INIT_BIT = 1L;
    private transient String toJsonString;
    private static final long SPEC_VERSION_LAZY_INIT_BIT = 2L;
    private transient String specVersion;
    private static final long serialVersionUID = 1L;

    private Location(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.precision = builder.precision;
        this.region = builder.region;
        this.country = builder.country;
        this.administrativeArea = builder.administrativeArea;
        this.city = builder.city;
        this.streetAddress = builder.streetAddress;
        this.postalCode = builder.postalCode;
        this.type = builder.type;
        this.id = builder.id;
        this.createdByRef = builder.createdByRef;
        this.lang = builder.lang;
        this.customProperties = builder.customProperties.build();
        if (builder.relationshipsIsSet()) {
            this.initShim.relationships((ImmutableSet<RelationshipSro>)builder.relationships.build());
        }
        if (builder.hydratedIsSet()) {
            this.initShim.hydrated(builder.hydrated);
        }
        if (builder.created != null) {
            this.initShim.created(builder.created);
        }
        if (builder.externalReferencesIsSet()) {
            this.initShim.externalReferences((ImmutableSet<ExternalReferenceType>)builder.externalReferences.build());
        }
        if (builder.objectMarkingRefsIsSet()) {
            this.initShim.objectMarkingRefs((ImmutableSet<MarkingDefinitionDm>)builder.objectMarkingRefs.build());
        }
        if (builder.granularMarkingsIsSet()) {
            this.initShim.granularMarkings((ImmutableSet<GranularMarkingDm>)builder.granularMarkings.build());
        }
        if (builder.labelsIsSet()) {
            this.initShim.labels((ImmutableSet<String>)builder.labels.build());
        }
        if (builder.modified != null) {
            this.initShim.modified(builder.modified);
        }
        if (builder.revoked != null) {
            this.initShim.revoked(builder.revoked);
        }
        this.relationships = this.initShim.getRelationships();
        this.hydrated = this.initShim.getHydrated();
        this.created = this.initShim.getCreated();
        this.externalReferences = this.initShim.getExternalReferences();
        this.objectMarkingRefs = this.initShim.getObjectMarkingRefs();
        this.granularMarkings = this.initShim.getGranularMarkings();
        this.labels = this.initShim.getLabels();
        this.modified = this.initShim.getModified();
        this.revoked = this.initShim.getRevoked();
        this.initShim = null;
    }

    private Location(@Nullable String name, @Nullable String description, @Nullable Double latitude, @Nullable Double longitude, @Nullable Double precision, @Nullable String region, @Nullable String country, @Nullable String administrativeArea, @Nullable String city, @Nullable String streetAddress, @Nullable String postalCode, ImmutableSet<RelationshipSro> relationships, boolean hydrated, String type, String id, @Nullable IdentitySdo createdByRef, StixInstant created, @Nullable String lang, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, ImmutableMap<String, Object> customProperties, ImmutableSet<String> labels, StixInstant modified, StixBoolean revoked) {
        this.name = name;
        this.description = description;
        this.latitude = latitude;
        this.longitude = longitude;
        this.precision = precision;
        this.region = region;
        this.country = country;
        this.administrativeArea = administrativeArea;
        this.city = city;
        this.streetAddress = streetAddress;
        this.postalCode = postalCode;
        this.relationships = relationships;
        this.hydrated = hydrated;
        this.type = type;
        this.id = id;
        this.createdByRef = createdByRef;
        this.created = created;
        this.lang = lang;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.customProperties = customProperties;
        this.labels = labels;
        this.modified = modified;
        this.revoked = revoked;
        this.initShim = null;
    }

    private Set<RelationshipSro> getRelationshipsInitialize() {
        return LocationSdo.super.getRelationships();
    }

    private boolean getHydratedInitialize() {
        return LocationSdo.super.getHydrated();
    }

    private StixInstant getCreatedInitialize() {
        return LocationSdo.super.getCreated();
    }

    private Set<ExternalReferenceType> getExternalReferencesInitialize() {
        return LocationSdo.super.getExternalReferences();
    }

    private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
        return LocationSdo.super.getObjectMarkingRefs();
    }

    private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
        return LocationSdo.super.getGranularMarkings();
    }

    private Set<String> getLabelsInitialize() {
        return LocationSdo.super.getLabels();
    }

    private StixInstant getModifiedInitialize() {
        return LocationSdo.super.getModified();
    }

    private StixBoolean getRevokedInitialize() {
        return LocationSdo.super.getRevoked();
    }

    @Override
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A name used to identify the Location.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A textual description of the Location.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="latitude")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The latitude of the Location in decimal degrees.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Double> getLatitude() {
        return Optional.ofNullable(this.latitude);
    }

    @Override
    @JsonProperty(value="longitude")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The longitude of the Location in decimal degrees.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Double> getLongitude() {
        return Optional.ofNullable(this.longitude);
    }

    @Override
    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Defines the precision of the coordinates specified by the latitude and longitude properties in meters.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<Double> getPrecision() {
        return Optional.ofNullable(this.precision);
    }

    @Override
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The region that this Location describes. Open Vocabulary: region-ov")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getRegion() {
        return Optional.ofNullable(this.region);
    }

    @Override
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The country that this Location describes (ISO 3166-1 ALPHA-2 Code).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getCountry() {
        return Optional.ofNullable(this.country);
    }

    @Override
    @JsonProperty(value="administrative_area")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The state, province, or other sub-national administrative area that this Location describes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getAdministrativeArea() {
        return Optional.ofNullable(this.administrativeArea);
    }

    @Override
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The city that this Location describes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getCity() {
        return Optional.ofNullable(this.city);
    }

    @Override
    @JsonProperty(value="street_address")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The street address that this Location describes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getStreetAddress() {
        return Optional.ofNullable(this.streetAddress);
    }

    @Override
    @JsonProperty(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The postal code for this Location.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(this.postalCode);
    }

    @JsonProperty(value="relationships")
    @JsonIgnore
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<RelationshipSro> getRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRelationships() : this.relationships;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public boolean getHydrated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHydrated() : this.hydrated;
    }

    @Override
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
    @Redactable(useMask=true, redactionMask="identity--__REDACTED__")
    public Optional<IdentitySdo> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreated() : this.created;
    }

    @Override
    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getLang() {
        return Optional.ofNullable(this.lang);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExternalReferences() : this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMarkingRefs() : this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGranularMarkings() : this.granularMarkings;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabels() : this.labels;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getModified() : this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixBoolean getRevoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRevoked() : this.revoked;
    }

    public final Location withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return Location.validate(new Location(newValue, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return Location.validate(new Location(value, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, newValue, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, value, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withLatitude(double value) {
        Double newValue = value;
        if (Objects.equals(this.latitude, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, newValue, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withLatitude(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.latitude, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, value, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withLongitude(double value) {
        Double newValue = value;
        if (Objects.equals(this.longitude, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, newValue, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withLongitude(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.longitude, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, value, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withPrecision(double value) {
        Double newValue = value;
        if (Objects.equals(this.precision, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, newValue, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withPrecision(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.precision, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, value, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (Objects.equals(this.region, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, newValue, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withRegion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.region, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, value, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCountry(String value) {
        String newValue = Objects.requireNonNull(value, "country");
        if (Objects.equals(this.country, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, newValue, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCountry(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.country, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, value, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withAdministrativeArea(String value) {
        String newValue = Objects.requireNonNull(value, "administrativeArea");
        if (Objects.equals(this.administrativeArea, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, newValue, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withAdministrativeArea(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.administrativeArea, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, value, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCity(String value) {
        String newValue = Objects.requireNonNull(value, "city");
        if (Objects.equals(this.city, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, newValue, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCity(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.city, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, value, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withStreetAddress(String value) {
        String newValue = Objects.requireNonNull(value, "streetAddress");
        if (Objects.equals(this.streetAddress, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, newValue, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withStreetAddress(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.streetAddress, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, value, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withPostalCode(String value) {
        String newValue = Objects.requireNonNull(value, "postalCode");
        if (Objects.equals(this.postalCode, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withPostalCode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.postalCode, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, value, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withRelationships(RelationshipSro ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withRelationships(Iterable<? extends RelationshipSro> elements) {
        if (this.relationships == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, value, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, value, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, value, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCreatedByRef(IdentitySdo value) {
        IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
        if (this.createdByRef == newValue) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, newValue, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCreatedByRef(Optional<? extends IdentitySdo> optional) {
        IdentitySdo value = optional.orElse(null);
        if (this.createdByRef == value) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, value, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "created");
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, newValue, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withLang(String value) {
        String newValue = Objects.requireNonNull(value, "lang");
        if (Objects.equals(this.lang, newValue)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withLang(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lang, value)) {
            return this;
        }
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final Location withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, (ImmutableMap<String, Object>)newValue, this.labels, this.modified, this.revoked));
    }

    public final Location withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final Location withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final Location withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "modified");
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, newValue, this.revoked));
    }

    public final Location withRevoked(StixBoolean value) {
        if (this.revoked == value) {
            return this;
        }
        StixBoolean newValue = Objects.requireNonNull(value, "revoked");
        return Location.validate(new Location(this.name, this.description, this.latitude, this.longitude, this.precision, this.region, this.country, this.administrativeArea, this.city, this.streetAddress, this.postalCode, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Location && this.equalTo((Location)another);
    }

    private boolean equalTo(Location another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.latitude, another.latitude) && Objects.equals(this.longitude, another.longitude) && Objects.equals(this.precision, another.precision) && Objects.equals(this.region, another.region) && Objects.equals(this.country, another.country) && Objects.equals(this.administrativeArea, another.administrativeArea) && Objects.equals(this.city, another.city) && Objects.equals(this.streetAddress, another.streetAddress) && Objects.equals(this.postalCode, another.postalCode) && this.relationships.equals(another.relationships) && this.hydrated == another.hydrated && Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.createdByRef, another.createdByRef) && this.created.equals(another.created) && Objects.equals(this.lang, another.lang) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.customProperties.equals(another.customProperties) && this.labels.equals(another.labels) && this.modified.equals(another.modified) && this.revoked.equals(another.revoked);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.latitude);
        h += (h << 5) + Objects.hashCode(this.longitude);
        h += (h << 5) + Objects.hashCode(this.precision);
        h += (h << 5) + Objects.hashCode(this.region);
        h += (h << 5) + Objects.hashCode(this.country);
        h += (h << 5) + Objects.hashCode(this.administrativeArea);
        h += (h << 5) + Objects.hashCode(this.city);
        h += (h << 5) + Objects.hashCode(this.streetAddress);
        h += (h << 5) + Objects.hashCode(this.postalCode);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.lang);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.revoked.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Location").omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("latitude", (Object)this.latitude).add("longitude", (Object)this.longitude).add("precision", (Object)this.precision).add("region", (Object)this.region).add("country", (Object)this.country).add("administrativeArea", (Object)this.administrativeArea).add("city", (Object)this.city).add("streetAddress", (Object)this.streetAddress).add("postalCode", (Object)this.postalCode).add("relationships", this.relationships).add("hydrated", this.hydrated).add("type", (Object)this.type).add("id", (Object)this.id).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("lang", (Object)this.lang).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("customProperties", this.customProperties).add("labels", this.labels).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String toJsonString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Location location = this;
            synchronized (location) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJsonString = Objects.requireNonNull(LocationSdo.super.toJsonString(), "toJsonString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getSpecVersion() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Location location = this;
            synchronized (location) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.specVersion = Objects.requireNonNull(LocationSdo.super.getSpecVersion(), "specVersion");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.specVersion;
    }

    private static Location validate(Location instance) {
        instance.checkHydrationValidation();
        return instance;
    }

    public static Location copyOf(LocationSdo instance) {
        if (instance instanceof Location) {
            return (Location)instance;
        }
        return Location.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Location.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="location")
    @JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "latitude", "longitude", "precision", "region", "country", "administrative_area", "city", "street_address", "postal_code"})
    @Generated(from="LocationSdo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_RELATIONSHIPS = 1L;
        private static final long OPT_BIT_HYDRATED = 2L;
        private static final long OPT_BIT_EXTERNAL_REFERENCES = 4L;
        private static final long OPT_BIT_OBJECT_MARKING_REFS = 8L;
        private static final long OPT_BIT_GRANULAR_MARKINGS = 16L;
        private static final long OPT_BIT_LABELS = 32L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private Double latitude;
        @Nullable
        private Double longitude;
        @Nullable
        private Double precision;
        @Nullable
        private String region;
        @Nullable
        private String country;
        @Nullable
        private String administrativeArea;
        @Nullable
        private String city;
        @Nullable
        private String streetAddress;
        @Nullable
        private String postalCode;
        private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private IdentitySdo createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private String lang;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        @Nullable
        private StixInstant modified;
        @Nullable
        private StixBoolean revoked;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixRevoked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(LocationSdo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixLabels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DomainObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                if ((bits & 8L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
            }
            if (object instanceof StixCommonProperties) {
                Optional<String> langOptional;
                Optional<IdentitySdo> createdByRefOptional;
                instance = (StixCommonProperties)object;
                this.addAllExternalReferences(instance.getExternalReferences());
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                this.created(instance.getCreated());
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 8L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((langOptional = instance.getLang()).isPresent()) {
                    this.lang(langOptional);
                }
            }
            if (object instanceof StixRevoked) {
                instance = (StixRevoked)object;
                this.revoked(instance.getRevoked());
            }
            if (object instanceof LocationSdo) {
                Optional<Double> longitudeOptional;
                Optional<String> regionOptional;
                Optional<String> administrativeAreaOptional;
                Optional<String> descriptionOptional;
                Optional<String> nameOptional;
                Optional<String> postalCodeOptional;
                Optional<Double> precisionOptional;
                Optional<Double> latitudeOptional;
                Optional<String> streetAddressOptional;
                Optional<String> cityOptional;
                instance = (LocationSdo)object;
                Optional<String> countryOptional = instance.getCountry();
                if (countryOptional.isPresent()) {
                    this.country(countryOptional);
                }
                if ((cityOptional = instance.getCity()).isPresent()) {
                    this.city(cityOptional);
                }
                if ((streetAddressOptional = instance.getStreetAddress()).isPresent()) {
                    this.streetAddress(streetAddressOptional);
                }
                if ((latitudeOptional = instance.getLatitude()).isPresent()) {
                    this.latitude(latitudeOptional);
                }
                if ((precisionOptional = instance.getPrecision()).isPresent()) {
                    this.precision(precisionOptional);
                }
                if ((postalCodeOptional = instance.getPostalCode()).isPresent()) {
                    this.postalCode(postalCodeOptional);
                }
                if ((nameOptional = instance.getName()).isPresent()) {
                    this.name(nameOptional);
                }
                if ((descriptionOptional = instance.getDescription()).isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((administrativeAreaOptional = instance.getAdministrativeArea()).isPresent()) {
                    this.administrativeArea(administrativeAreaOptional);
                }
                if ((regionOptional = instance.getRegion()).isPresent()) {
                    this.region(regionOptional);
                }
                if ((longitudeOptional = instance.getLongitude()).isPresent()) {
                    this.longitude(longitudeOptional);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof StixLabels) {
                instance = (StixLabels)object;
                this.addAllLabels(instance.getLabels());
            }
            if (object instanceof StixModified) {
                instance = (StixModified)object;
                this.modified(instance.getModified());
            }
            if (object instanceof DomainObject) {
                instance = (DomainObject)object;
                this.addAllRelationships(instance.getRelationships());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="name")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A name used to identify the Location.")
        @CanIgnoreReturnValue
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A textual description of the Location.")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        @JsonProperty(value="latitude")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The latitude of the Location in decimal degrees.")
        @CanIgnoreReturnValue
        public final Builder latitude(Optional<Double> latitude) {
            this.latitude = latitude.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        @JsonProperty(value="longitude")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The longitude of the Location in decimal degrees.")
        @CanIgnoreReturnValue
        public final Builder longitude(Optional<Double> longitude) {
            this.longitude = longitude.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder precision(double precision) {
            this.precision = precision;
            return this;
        }

        @JsonProperty(value="precision")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Defines the precision of the coordinates specified by the latitude and longitude properties in meters.")
        @CanIgnoreReturnValue
        public final Builder precision(Optional<Double> precision) {
            this.precision = precision.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            return this;
        }

        @JsonProperty(value="region")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The region that this Location describes. Open Vocabulary: region-ov")
        @CanIgnoreReturnValue
        public final Builder region(Optional<String> region) {
            this.region = region.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder country(String country) {
            this.country = Objects.requireNonNull(country, "country");
            return this;
        }

        @JsonProperty(value="country")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The country that this Location describes (ISO 3166-1 ALPHA-2 Code).")
        @CanIgnoreReturnValue
        public final Builder country(Optional<String> country) {
            this.country = country.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder administrativeArea(String administrativeArea) {
            this.administrativeArea = Objects.requireNonNull(administrativeArea, "administrativeArea");
            return this;
        }

        @JsonProperty(value="administrative_area")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The state, province, or other sub-national administrative area that this Location describes.")
        @CanIgnoreReturnValue
        public final Builder administrativeArea(Optional<String> administrativeArea) {
            this.administrativeArea = administrativeArea.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder city(String city) {
            this.city = Objects.requireNonNull(city, "city");
            return this;
        }

        @JsonProperty(value="city")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The city that this Location describes.")
        @CanIgnoreReturnValue
        public final Builder city(Optional<String> city) {
            this.city = city.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder streetAddress(String streetAddress) {
            this.streetAddress = Objects.requireNonNull(streetAddress, "streetAddress");
            return this;
        }

        @JsonProperty(value="street_address")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The street address that this Location describes.")
        @CanIgnoreReturnValue
        public final Builder streetAddress(Optional<String> streetAddress) {
            this.streetAddress = streetAddress.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder postalCode(String postalCode) {
            this.postalCode = Objects.requireNonNull(postalCode, "postalCode");
            return this;
        }

        @JsonProperty(value="postal_code")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The postal code for this Location.")
        @CanIgnoreReturnValue
        public final Builder postalCode(Optional<String> postalCode) {
            this.postalCode = postalCode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationship(@Nullable RelationshipSro element) {
            this.relationships.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationships(RelationshipSro ... elements) {
            this.relationships.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="relationships")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships = ImmutableSet.builder();
            return this.addAllRelationships(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="type")
        @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(IdentitySdo createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lang(String lang) {
            this.lang = Objects.requireNonNull(lang, "lang");
            return this;
        }

        @JsonProperty(value="lang")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
        @CanIgnoreReturnValue
        public final Builder lang(Optional<String> lang) {
            this.lang = lang.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(StixBoolean revoked) {
            this.revoked = Objects.requireNonNull(revoked, "revoked");
            return this;
        }

        public Location build() {
            return Location.validate(new Location(this));
        }

        private boolean relationshipsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean hydratedIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean externalReferencesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean objectMarkingRefsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean granularMarkingsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean labelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    @Generated(from="LocationSdo", generator="Immutables")
    private final class InitShim {
        private byte relationshipsBuildStage = 0;
        private ImmutableSet<RelationshipSro> relationships;
        private byte hydratedBuildStage = 0;
        private boolean hydrated;
        private byte createdBuildStage = 0;
        private StixInstant created;
        private byte externalReferencesBuildStage = 0;
        private ImmutableSet<ExternalReferenceType> externalReferences;
        private byte objectMarkingRefsBuildStage = 0;
        private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
        private byte granularMarkingsBuildStage = 0;
        private ImmutableSet<GranularMarkingDm> granularMarkings;
        private byte labelsBuildStage = 0;
        private ImmutableSet<String> labels;
        private byte modifiedBuildStage = 0;
        private StixInstant modified;
        private byte revokedBuildStage = 0;
        private StixBoolean revoked;

        private InitShim() {
        }

        ImmutableSet<RelationshipSro> getRelationships() {
            if (this.relationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipsBuildStage == 0) {
                this.relationshipsBuildStage = (byte)-1;
                this.relationships = ImmutableSet.copyOf((Collection)Location.this.getRelationshipsInitialize());
                this.relationshipsBuildStage = 1;
            }
            return this.relationships;
        }

        void relationships(ImmutableSet<RelationshipSro> relationships) {
            this.relationships = relationships;
            this.relationshipsBuildStage = 1;
        }

        boolean getHydrated() {
            if (this.hydratedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hydratedBuildStage == 0) {
                this.hydratedBuildStage = (byte)-1;
                this.hydrated = Location.this.getHydratedInitialize();
                this.hydratedBuildStage = 1;
            }
            return this.hydrated;
        }

        void hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.hydratedBuildStage = 1;
        }

        StixInstant getCreated() {
            if (this.createdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdBuildStage == 0) {
                this.createdBuildStage = (byte)-1;
                this.created = Objects.requireNonNull(Location.this.getCreatedInitialize(), "created");
                this.createdBuildStage = 1;
            }
            return this.created;
        }

        void created(StixInstant created) {
            this.created = created;
            this.createdBuildStage = 1;
        }

        ImmutableSet<ExternalReferenceType> getExternalReferences() {
            if (this.externalReferencesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.externalReferencesBuildStage == 0) {
                this.externalReferencesBuildStage = (byte)-1;
                this.externalReferences = ImmutableSet.copyOf((Collection)Location.this.getExternalReferencesInitialize());
                this.externalReferencesBuildStage = 1;
            }
            return this.externalReferences;
        }

        void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
            this.externalReferences = externalReferences;
            this.externalReferencesBuildStage = 1;
        }

        ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
            if (this.objectMarkingRefsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMarkingRefsBuildStage == 0) {
                this.objectMarkingRefsBuildStage = (byte)-1;
                this.objectMarkingRefs = ImmutableSet.copyOf((Collection)Location.this.getObjectMarkingRefsInitialize());
                this.objectMarkingRefsBuildStage = 1;
            }
            return this.objectMarkingRefs;
        }

        void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
            this.objectMarkingRefs = objectMarkingRefs;
            this.objectMarkingRefsBuildStage = 1;
        }

        ImmutableSet<GranularMarkingDm> getGranularMarkings() {
            if (this.granularMarkingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.granularMarkingsBuildStage == 0) {
                this.granularMarkingsBuildStage = (byte)-1;
                this.granularMarkings = ImmutableSet.copyOf((Collection)Location.this.getGranularMarkingsInitialize());
                this.granularMarkingsBuildStage = 1;
            }
            return this.granularMarkings;
        }

        void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
            this.granularMarkings = granularMarkings;
            this.granularMarkingsBuildStage = 1;
        }

        ImmutableSet<String> getLabels() {
            if (this.labelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelsBuildStage == 0) {
                this.labelsBuildStage = (byte)-1;
                this.labels = ImmutableSet.copyOf((Collection)Location.this.getLabelsInitialize());
                this.labelsBuildStage = 1;
            }
            return this.labels;
        }

        void labels(ImmutableSet<String> labels) {
            this.labels = labels;
            this.labelsBuildStage = 1;
        }

        StixInstant getModified() {
            if (this.modifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedBuildStage == 0) {
                this.modifiedBuildStage = (byte)-1;
                this.modified = Objects.requireNonNull(Location.this.getModifiedInitialize(), "modified");
                this.modifiedBuildStage = 1;
            }
            return this.modified;
        }

        void modified(StixInstant modified) {
            this.modified = modified;
            this.modifiedBuildStage = 1;
        }

        StixBoolean getRevoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = Objects.requireNonNull(Location.this.getRevokedInitialize(), "revoked");
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(StixBoolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.relationshipsBuildStage == -1) {
                attributes.add("relationships");
            }
            if (this.hydratedBuildStage == -1) {
                attributes.add("hydrated");
            }
            if (this.createdBuildStage == -1) {
                attributes.add("created");
            }
            if (this.externalReferencesBuildStage == -1) {
                attributes.add("externalReferences");
            }
            if (this.objectMarkingRefsBuildStage == -1) {
                attributes.add("objectMarkingRefs");
            }
            if (this.granularMarkingsBuildStage == -1) {
                attributes.add("granularMarkings");
            }
            if (this.labelsBuildStage == -1) {
                attributes.add("labels");
            }
            if (this.modifiedBuildStage == -1) {
                attributes.add("modified");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build Location, attribute initializers form cycle " + attributes;
        }
    }
}

