/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Location;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@JsonTypeName(value="location")
@DefaultTypeValue(value="location", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Location.class)
@JsonDeserialize(builder=Location.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "latitude", "longitude", "precision", "region", "country", "administrative_area", "city", "street_address", "postal_code"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface LocationSdo
extends DomainObject {
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A name used to identify the Location.")
    @Redactable
    public Optional<String> getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A textual description of the Location.")
    @Redactable
    public Optional<String> getDescription();

    @JsonProperty(value="latitude")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The latitude of the Location in decimal degrees.")
    @Redactable
    public Optional<Double> getLatitude();

    @JsonProperty(value="longitude")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The longitude of the Location in decimal degrees.")
    @Redactable
    public Optional<Double> getLongitude();

    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Defines the precision of the coordinates specified by the latitude and longitude properties in meters.")
    @Redactable
    public Optional<Double> getPrecision();

    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The region that this Location describes. Open Vocabulary: region-ov")
    @Redactable
    public Optional<String> getRegion();

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The country that this Location describes (ISO 3166-1 ALPHA-2 Code).")
    @Redactable
    public Optional<String> getCountry();

    @JsonProperty(value="administrative_area")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The state, province, or other sub-national administrative area that this Location describes.")
    @Redactable
    public Optional<String> getAdministrativeArea();

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The city that this Location describes.")
    @Redactable
    public Optional<String> getCity();

    @JsonProperty(value="street_address")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The street address that this Location describes.")
    @Redactable
    public Optional<String> getStreetAddress();

    @JsonProperty(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The postal code for this Location.")
    @Redactable
    public Optional<String> getPostalCode();
}

