/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.objects.MalwareAnalysisSdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sro.objects.RelationshipSro;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="malware-analysis")
@Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
@Generated(from="MalwareAnalysisSdo", generator="Immutables")
@Immutable
public final class MalwareAnalysis
implements MalwareAnalysisSdo {
    private final String product;
    @Nullable
    private final String version;
    @Nullable
    private final String hostVmRef;
    @Nullable
    private final String operatingSystemRef;
    private final ImmutableSet<String> installedSoftwareRefs;
    @Nullable
    private final String configurationVersion;
    @Nullable
    private final String module;
    @Nullable
    private final String analysisEngineVersion;
    @Nullable
    private final String analysisDefinitionVersion;
    @Nullable
    private final StixInstant submitted;
    @Nullable
    private final StixInstant analysisStarted;
    @Nullable
    private final StixInstant analysisEnded;
    @Nullable
    private final String avResult;
    private final ImmutableSet<String> analysisScoRefs;
    @Nullable
    private final String sampleRef;
    private final ImmutableSet<RelationshipSro> relationships;
    private final boolean hydrated;
    private final String type;
    private final String id;
    @Nullable
    private final IdentitySdo createdByRef;
    private final StixInstant created;
    @Nullable
    private final String lang;
    private final ImmutableSet<ExternalReferenceType> externalReferences;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<String> labels;
    private final StixInstant modified;
    private final StixBoolean revoked;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_STRING_LAZY_INIT_BIT = 1L;
    private transient String toJsonString;
    private static final long SPEC_VERSION_LAZY_INIT_BIT = 2L;
    private transient String specVersion;
    private static final long serialVersionUID = 1L;

    private MalwareAnalysis(Builder builder) {
        this.product = builder.product;
        this.version = builder.version;
        this.hostVmRef = builder.hostVmRef;
        this.operatingSystemRef = builder.operatingSystemRef;
        this.installedSoftwareRefs = builder.installedSoftwareRefs.build();
        this.configurationVersion = builder.configurationVersion;
        this.module = builder.module;
        this.analysisEngineVersion = builder.analysisEngineVersion;
        this.analysisDefinitionVersion = builder.analysisDefinitionVersion;
        this.submitted = builder.submitted;
        this.analysisStarted = builder.analysisStarted;
        this.analysisEnded = builder.analysisEnded;
        this.avResult = builder.avResult;
        this.analysisScoRefs = builder.analysisScoRefs.build();
        this.sampleRef = builder.sampleRef;
        this.type = builder.type;
        this.id = builder.id;
        this.createdByRef = builder.createdByRef;
        this.lang = builder.lang;
        this.customProperties = builder.customProperties.build();
        if (builder.relationshipsIsSet()) {
            this.initShim.relationships((ImmutableSet<RelationshipSro>)builder.relationships.build());
        }
        if (builder.hydratedIsSet()) {
            this.initShim.hydrated(builder.hydrated);
        }
        if (builder.created != null) {
            this.initShim.created(builder.created);
        }
        if (builder.externalReferencesIsSet()) {
            this.initShim.externalReferences((ImmutableSet<ExternalReferenceType>)builder.externalReferences.build());
        }
        if (builder.objectMarkingRefsIsSet()) {
            this.initShim.objectMarkingRefs((ImmutableSet<MarkingDefinitionDm>)builder.objectMarkingRefs.build());
        }
        if (builder.granularMarkingsIsSet()) {
            this.initShim.granularMarkings((ImmutableSet<GranularMarkingDm>)builder.granularMarkings.build());
        }
        if (builder.labelsIsSet()) {
            this.initShim.labels((ImmutableSet<String>)builder.labels.build());
        }
        if (builder.modified != null) {
            this.initShim.modified(builder.modified);
        }
        if (builder.revoked != null) {
            this.initShim.revoked(builder.revoked);
        }
        this.relationships = this.initShim.getRelationships();
        this.hydrated = this.initShim.getHydrated();
        this.created = this.initShim.getCreated();
        this.externalReferences = this.initShim.getExternalReferences();
        this.objectMarkingRefs = this.initShim.getObjectMarkingRefs();
        this.granularMarkings = this.initShim.getGranularMarkings();
        this.labels = this.initShim.getLabels();
        this.modified = this.initShim.getModified();
        this.revoked = this.initShim.getRevoked();
        this.initShim = null;
    }

    private MalwareAnalysis(String product, @Nullable String version, @Nullable String hostVmRef, @Nullable String operatingSystemRef, ImmutableSet<String> installedSoftwareRefs, @Nullable String configurationVersion, @Nullable String module, @Nullable String analysisEngineVersion, @Nullable String analysisDefinitionVersion, @Nullable StixInstant submitted, @Nullable StixInstant analysisStarted, @Nullable StixInstant analysisEnded, @Nullable String avResult, ImmutableSet<String> analysisScoRefs, @Nullable String sampleRef, ImmutableSet<RelationshipSro> relationships, boolean hydrated, String type, String id, @Nullable IdentitySdo createdByRef, StixInstant created, @Nullable String lang, ImmutableSet<ExternalReferenceType> externalReferences, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, ImmutableMap<String, Object> customProperties, ImmutableSet<String> labels, StixInstant modified, StixBoolean revoked) {
        this.product = product;
        this.version = version;
        this.hostVmRef = hostVmRef;
        this.operatingSystemRef = operatingSystemRef;
        this.installedSoftwareRefs = installedSoftwareRefs;
        this.configurationVersion = configurationVersion;
        this.module = module;
        this.analysisEngineVersion = analysisEngineVersion;
        this.analysisDefinitionVersion = analysisDefinitionVersion;
        this.submitted = submitted;
        this.analysisStarted = analysisStarted;
        this.analysisEnded = analysisEnded;
        this.avResult = avResult;
        this.analysisScoRefs = analysisScoRefs;
        this.sampleRef = sampleRef;
        this.relationships = relationships;
        this.hydrated = hydrated;
        this.type = type;
        this.id = id;
        this.createdByRef = createdByRef;
        this.created = created;
        this.lang = lang;
        this.externalReferences = externalReferences;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.customProperties = customProperties;
        this.labels = labels;
        this.modified = modified;
        this.revoked = revoked;
        this.initShim = null;
    }

    private Set<RelationshipSro> getRelationshipsInitialize() {
        return MalwareAnalysisSdo.super.getRelationships();
    }

    private boolean getHydratedInitialize() {
        return MalwareAnalysisSdo.super.getHydrated();
    }

    private StixInstant getCreatedInitialize() {
        return MalwareAnalysisSdo.super.getCreated();
    }

    private Set<ExternalReferenceType> getExternalReferencesInitialize() {
        return MalwareAnalysisSdo.super.getExternalReferences();
    }

    private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
        return MalwareAnalysisSdo.super.getObjectMarkingRefs();
    }

    private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
        return MalwareAnalysisSdo.super.getGranularMarkings();
    }

    private Set<String> getLabelsInitialize() {
        return MalwareAnalysisSdo.super.getLabels();
    }

    private StixInstant getModifiedInitialize() {
        return MalwareAnalysisSdo.super.getModified();
    }

    private StixBoolean getRevokedInitialize() {
        return MalwareAnalysisSdo.super.getRevoked();
    }

    @Override
    @JsonProperty(value="product")
    @JsonPropertyDescription(value="The name of the analysis product that was used to perform the analysis.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getProduct() {
        return this.product;
    }

    @Override
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the analysis product that was used to perform the analysis.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="host_vm_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A reference to a SCO Software object for the VM that hosted the malware during the analysis.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getHostVmRef() {
        return Optional.ofNullable(this.hostVmRef);
    }

    @Override
    @JsonProperty(value="operating_system_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A reference to a SCO Software object for the operating system used for the analysis VM.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getOperatingSystemRef() {
        return Optional.ofNullable(this.operatingSystemRef);
    }

    @JsonProperty(value="installed_software_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of references to SCO Software objects for the operating system software installed on the analysis VM.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getInstalledSoftwareRefs() {
        return this.installedSoftwareRefs;
    }

    @Override
    @JsonProperty(value="configuration_version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the configuration used for the analysis.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getConfigurationVersion() {
        return Optional.ofNullable(this.configurationVersion);
    }

    @Override
    @JsonProperty(value="module")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The name of the specific analysis module that was used, if different from the product.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getModule() {
        return Optional.ofNullable(this.module);
    }

    @Override
    @JsonProperty(value="analysis_engine_version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the analysis engine or runtime environment.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getAnalysisEngineVersion() {
        return Optional.ofNullable(this.analysisEngineVersion);
    }

    @Override
    @JsonProperty(value="analysis_definition_version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the analysis definitions used (e.g., virus definition version).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getAnalysisDefinitionVersion() {
        return Optional.ofNullable(this.analysisDefinitionVersion);
    }

    @Override
    @JsonProperty(value="submitted")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The date and time that the malware sample was submitted for analysis.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<StixInstant> getSubmitted() {
        return Optional.ofNullable(this.submitted);
    }

    @Override
    @JsonProperty(value="analysis_started")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The date and time that the malware analysis started.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<StixInstant> getAnalysisStarted() {
        return Optional.ofNullable(this.analysisStarted);
    }

    @Override
    @JsonProperty(value="analysis_ended")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The date and time that the malware analysis ended.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<StixInstant> getAnalysisEnded() {
        return Optional.ofNullable(this.analysisEnded);
    }

    @Override
    @JsonProperty(value="av_result")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The result of the anti-virus analysis. Open vocabulary - malware-av-result-ov")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getAvResult() {
        return Optional.ofNullable(this.avResult);
    }

    @JsonProperty(value="analysis_sco_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of references to SCOs that were captured during the analysis process.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getAnalysisScoRefs() {
        return this.analysisScoRefs;
    }

    @Override
    @JsonProperty(value="sample_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A reference to the SCO file, malware or artifact object that was analyzed.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getSampleRef() {
        return Optional.ofNullable(this.sampleRef);
    }

    @JsonProperty(value="relationships")
    @JsonIgnore
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<RelationshipSro> getRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRelationships() : this.relationships;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public boolean getHydrated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHydrated() : this.hydrated;
    }

    @Override
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
    @Redactable(useMask=true, redactionMask="identity--__REDACTED__")
    public Optional<IdentitySdo> getCreatedByRef() {
        return Optional.ofNullable(this.createdByRef);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=true, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getCreated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreated() : this.created;
    }

    @Override
    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public Optional<String> getLang() {
        return Optional.ofNullable(this.lang);
    }

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<ExternalReferenceType> getExternalReferences() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExternalReferences() : this.externalReferences;
    }

    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMarkingRefs() : this.objectMarkingRefs;
    }

    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGranularMarkings() : this.granularMarkings;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public ImmutableSet<String> getLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabels() : this.labels;
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixInstant getModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getModified() : this.modified;
    }

    @Override
    @JsonProperty(value="revoked")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public StixBoolean getRevoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRevoked() : this.revoked;
    }

    public final MalwareAnalysis withProduct(String value) {
        if (Objects.equals(this.product, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(value, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, newValue, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, value, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withHostVmRef(String value) {
        String newValue = Objects.requireNonNull(value, "hostVmRef");
        if (Objects.equals(this.hostVmRef, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, newValue, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withHostVmRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hostVmRef, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, value, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withOperatingSystemRef(String value) {
        String newValue = Objects.requireNonNull(value, "operatingSystemRef");
        if (Objects.equals(this.operatingSystemRef, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, newValue, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withOperatingSystemRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.operatingSystemRef, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, value, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withInstalledSoftwareRefs(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, (ImmutableSet<String>)newValue, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withInstalledSoftwareRefs(Iterable<String> elements) {
        if (this.installedSoftwareRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, (ImmutableSet<String>)newValue, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withConfigurationVersion(String value) {
        String newValue = Objects.requireNonNull(value, "configurationVersion");
        if (Objects.equals(this.configurationVersion, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, newValue, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withConfigurationVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.configurationVersion, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, value, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withModule(String value) {
        String newValue = Objects.requireNonNull(value, "module");
        if (Objects.equals(this.module, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, newValue, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withModule(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.module, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, value, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisEngineVersion(String value) {
        String newValue = Objects.requireNonNull(value, "analysisEngineVersion");
        if (Objects.equals(this.analysisEngineVersion, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, newValue, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisEngineVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.analysisEngineVersion, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, value, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisDefinitionVersion(String value) {
        String newValue = Objects.requireNonNull(value, "analysisDefinitionVersion");
        if (Objects.equals(this.analysisDefinitionVersion, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, newValue, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisDefinitionVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.analysisDefinitionVersion, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, value, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withSubmitted(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "submitted");
        if (this.submitted == newValue) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, newValue, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withSubmitted(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.submitted == value) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, value, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisStarted(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "analysisStarted");
        if (this.analysisStarted == newValue) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, newValue, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisStarted(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.analysisStarted == value) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, value, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisEnded(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "analysisEnded");
        if (this.analysisEnded == newValue) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, newValue, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisEnded(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.analysisEnded == value) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, value, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAvResult(String value) {
        String newValue = Objects.requireNonNull(value, "avResult");
        if (Objects.equals(this.avResult, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, newValue, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAvResult(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.avResult, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, value, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisScoRefs(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, (ImmutableSet<String>)newValue, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withAnalysisScoRefs(Iterable<String> elements) {
        if (this.analysisScoRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, (ImmutableSet<String>)newValue, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withSampleRef(String value) {
        String newValue = Objects.requireNonNull(value, "sampleRef");
        if (Objects.equals(this.sampleRef, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, newValue, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withSampleRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sampleRef, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, value, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withRelationships(RelationshipSro ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withRelationships(Iterable<? extends RelationshipSro> elements) {
        if (this.relationships == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, (ImmutableSet<RelationshipSro>)newValue, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, value, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, value, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, value, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withCreatedByRef(IdentitySdo value) {
        IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
        if (this.createdByRef == newValue) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, newValue, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withCreatedByRef(Optional<? extends IdentitySdo> optional) {
        IdentitySdo value = optional.orElse(null);
        if (this.createdByRef == value) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, value, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withCreated(StixInstant value) {
        if (this.created == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "created");
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, newValue, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withLang(String value) {
        String newValue = Objects.requireNonNull(value, "lang");
        if (Objects.equals(this.lang, newValue)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, newValue, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withLang(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lang, value)) {
            return this;
        }
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, value, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withExternalReferences(ExternalReferenceType ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
        if (this.externalReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, (ImmutableSet<ExternalReferenceType>)newValue, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.customProperties, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, (ImmutableMap<String, Object>)newValue, this.labels, this.modified, this.revoked));
    }

    public final MalwareAnalysis withLabels(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final MalwareAnalysis withLabels(Iterable<String> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, (ImmutableSet<String>)newValue, this.modified, this.revoked));
    }

    public final MalwareAnalysis withModified(StixInstant value) {
        if (this.modified == value) {
            return this;
        }
        StixInstant newValue = Objects.requireNonNull(value, "modified");
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, newValue, this.revoked));
    }

    public final MalwareAnalysis withRevoked(StixBoolean value) {
        if (this.revoked == value) {
            return this;
        }
        StixBoolean newValue = Objects.requireNonNull(value, "revoked");
        return MalwareAnalysis.validate(new MalwareAnalysis(this.product, this.version, this.hostVmRef, this.operatingSystemRef, this.installedSoftwareRefs, this.configurationVersion, this.module, this.analysisEngineVersion, this.analysisDefinitionVersion, this.submitted, this.analysisStarted, this.analysisEnded, this.avResult, this.analysisScoRefs, this.sampleRef, this.relationships, this.hydrated, this.type, this.id, this.createdByRef, this.created, this.lang, this.externalReferences, this.objectMarkingRefs, this.granularMarkings, this.customProperties, this.labels, this.modified, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MalwareAnalysis && this.equalTo((MalwareAnalysis)another);
    }

    private boolean equalTo(MalwareAnalysis another) {
        return Objects.equals(this.product, another.product) && Objects.equals(this.version, another.version) && Objects.equals(this.hostVmRef, another.hostVmRef) && Objects.equals(this.operatingSystemRef, another.operatingSystemRef) && this.installedSoftwareRefs.equals(another.installedSoftwareRefs) && Objects.equals(this.configurationVersion, another.configurationVersion) && Objects.equals(this.module, another.module) && Objects.equals(this.analysisEngineVersion, another.analysisEngineVersion) && Objects.equals(this.analysisDefinitionVersion, another.analysisDefinitionVersion) && Objects.equals(this.submitted, another.submitted) && Objects.equals(this.analysisStarted, another.analysisStarted) && Objects.equals(this.analysisEnded, another.analysisEnded) && Objects.equals(this.avResult, another.avResult) && this.analysisScoRefs.equals(another.analysisScoRefs) && Objects.equals(this.sampleRef, another.sampleRef) && this.relationships.equals(another.relationships) && this.hydrated == another.hydrated && Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.createdByRef, another.createdByRef) && this.created.equals(another.created) && Objects.equals(this.lang, another.lang) && this.externalReferences.equals(another.externalReferences) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.customProperties.equals(another.customProperties) && this.labels.equals(another.labels) && this.modified.equals(another.modified) && this.revoked.equals(another.revoked);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.product);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.hostVmRef);
        h += (h << 5) + Objects.hashCode(this.operatingSystemRef);
        h += (h << 5) + this.installedSoftwareRefs.hashCode();
        h += (h << 5) + Objects.hashCode(this.configurationVersion);
        h += (h << 5) + Objects.hashCode(this.module);
        h += (h << 5) + Objects.hashCode(this.analysisEngineVersion);
        h += (h << 5) + Objects.hashCode(this.analysisDefinitionVersion);
        h += (h << 5) + Objects.hashCode(this.submitted);
        h += (h << 5) + Objects.hashCode(this.analysisStarted);
        h += (h << 5) + Objects.hashCode(this.analysisEnded);
        h += (h << 5) + Objects.hashCode(this.avResult);
        h += (h << 5) + this.analysisScoRefs.hashCode();
        h += (h << 5) + Objects.hashCode(this.sampleRef);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.createdByRef);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.lang);
        h += (h << 5) + this.externalReferences.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.revoked.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MalwareAnalysis").omitNullValues().add("product", (Object)this.product).add("version", (Object)this.version).add("hostVmRef", (Object)this.hostVmRef).add("operatingSystemRef", (Object)this.operatingSystemRef).add("installedSoftwareRefs", this.installedSoftwareRefs).add("configurationVersion", (Object)this.configurationVersion).add("module", (Object)this.module).add("analysisEngineVersion", (Object)this.analysisEngineVersion).add("analysisDefinitionVersion", (Object)this.analysisDefinitionVersion).add("submitted", (Object)this.submitted).add("analysisStarted", (Object)this.analysisStarted).add("analysisEnded", (Object)this.analysisEnded).add("avResult", (Object)this.avResult).add("analysisScoRefs", this.analysisScoRefs).add("sampleRef", (Object)this.sampleRef).add("relationships", this.relationships).add("hydrated", this.hydrated).add("type", (Object)this.type).add("id", (Object)this.id).add("createdByRef", (Object)this.createdByRef).add("created", (Object)this.created).add("lang", (Object)this.lang).add("externalReferences", this.externalReferences).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("customProperties", this.customProperties).add("labels", this.labels).add("modified", (Object)this.modified).add("revoked", (Object)this.revoked).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String toJsonString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            MalwareAnalysis malwareAnalysis = this;
            synchronized (malwareAnalysis) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJsonString = Objects.requireNonNull(MalwareAnalysisSdo.super.toJsonString(), "toJsonString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Redactable(useMask=false, redactionMask="\u2588\u2588REDACTED\u2588\u2588")
    public String getSpecVersion() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            MalwareAnalysis malwareAnalysis = this;
            synchronized (malwareAnalysis) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.specVersion = Objects.requireNonNull(MalwareAnalysisSdo.super.getSpecVersion(), "specVersion");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.specVersion;
    }

    private static MalwareAnalysis validate(MalwareAnalysis instance) {
        instance.checkHydrationValidation();
        return instance;
    }

    public static MalwareAnalysis copyOf(MalwareAnalysisSdo instance) {
        if (instance instanceof MalwareAnalysis) {
            return (MalwareAnalysis)instance;
        }
        return MalwareAnalysis.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return MalwareAnalysis.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="malware-analysis")
    @JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "product", "version", "host_vm_ref", "operating_system_ref", "installed_software_refs", "configuration_version", "module", "analysis_engine_version", "analysis_definition_version", "submitted", "analysis_started", "analysis_ended", "av_result", "analysis_sco_refs", "sample_ref"})
    @Generated(from="MalwareAnalysisSdo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_RELATIONSHIPS = 1L;
        private static final long OPT_BIT_HYDRATED = 2L;
        private static final long OPT_BIT_EXTERNAL_REFERENCES = 4L;
        private static final long OPT_BIT_OBJECT_MARKING_REFS = 8L;
        private static final long OPT_BIT_GRANULAR_MARKINGS = 16L;
        private static final long OPT_BIT_LABELS = 32L;
        private long optBits;
        @Nullable
        private String product;
        @Nullable
        private String version;
        @Nullable
        private String hostVmRef;
        @Nullable
        private String operatingSystemRef;
        private ImmutableSet.Builder<String> installedSoftwareRefs = ImmutableSet.builder();
        @Nullable
        private String configurationVersion;
        @Nullable
        private String module;
        @Nullable
        private String analysisEngineVersion;
        @Nullable
        private String analysisDefinitionVersion;
        @Nullable
        private StixInstant submitted;
        @Nullable
        private StixInstant analysisStarted;
        @Nullable
        private StixInstant analysisEnded;
        @Nullable
        private String avResult;
        private ImmutableSet.Builder<String> analysisScoRefs = ImmutableSet.builder();
        @Nullable
        private String sampleRef;
        private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private IdentitySdo createdByRef;
        @Nullable
        private StixInstant created;
        @Nullable
        private String lang;
        private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
        @Nullable
        private StixInstant modified;
        @Nullable
        private StixBoolean revoked;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixRevoked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixLabels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MalwareAnalysisSdo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DomainObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                if ((bits & 8L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
            }
            if (object instanceof StixCommonProperties) {
                Optional<String> langOptional;
                Optional<IdentitySdo> createdByRefOptional;
                instance = (StixCommonProperties)object;
                this.addAllExternalReferences(instance.getExternalReferences());
                if ((bits & 2L) == 0L) {
                    this.hydrated(instance.getHydrated());
                    bits |= 2L;
                }
                this.created(instance.getCreated());
                if ((bits & 4L) == 0L) {
                    this.addAllGranularMarkings(instance.getGranularMarkings());
                    bits |= 4L;
                }
                if ((createdByRefOptional = instance.getCreatedByRef()).isPresent()) {
                    this.createdByRef(createdByRefOptional);
                }
                if ((bits & 8L) == 0L) {
                    String idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    String typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                if ((langOptional = instance.getLang()).isPresent()) {
                    this.lang(langOptional);
                }
            }
            if (object instanceof StixRevoked) {
                instance = (StixRevoked)object;
                this.revoked(instance.getRevoked());
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof StixLabels) {
                instance = (StixLabels)object;
                this.addAllLabels(instance.getLabels());
            }
            if (object instanceof StixModified) {
                instance = (StixModified)object;
                this.modified(instance.getModified());
            }
            if (object instanceof MalwareAnalysisSdo) {
                Optional<String> sampleRefOptional;
                Optional<StixInstant> analysisStartedOptional;
                Optional<StixInstant> analysisEndedOptional;
                Optional<String> avResultOptional;
                Optional<StixInstant> submittedOptional;
                Optional<String> versionOptional;
                Optional<String> operatingSystemRefOptional;
                Optional<String> hostVmRefOptional;
                Optional<String> moduleOptional;
                Optional<String> analysisEngineVersionOptional;
                Optional<String> analysisDefinitionVersionOptional;
                instance = (MalwareAnalysisSdo)object;
                this.addAllInstalledSoftwareRefs(instance.getInstalledSoftwareRefs());
                String productValue = instance.getProduct();
                if (productValue != null) {
                    this.product(productValue);
                }
                if ((analysisDefinitionVersionOptional = instance.getAnalysisDefinitionVersion()).isPresent()) {
                    this.analysisDefinitionVersion(analysisDefinitionVersionOptional);
                }
                if ((analysisEngineVersionOptional = instance.getAnalysisEngineVersion()).isPresent()) {
                    this.analysisEngineVersion(analysisEngineVersionOptional);
                }
                if ((moduleOptional = instance.getModule()).isPresent()) {
                    this.module(moduleOptional);
                }
                if ((hostVmRefOptional = instance.getHostVmRef()).isPresent()) {
                    this.hostVmRef(hostVmRefOptional);
                }
                if ((operatingSystemRefOptional = instance.getOperatingSystemRef()).isPresent()) {
                    this.operatingSystemRef(operatingSystemRefOptional);
                }
                if ((versionOptional = instance.getVersion()).isPresent()) {
                    this.version(versionOptional);
                }
                this.addAllAnalysisScoRefs(instance.getAnalysisScoRefs());
                Optional<String> configurationVersionOptional = instance.getConfigurationVersion();
                if (configurationVersionOptional.isPresent()) {
                    this.configurationVersion(configurationVersionOptional);
                }
                if ((submittedOptional = instance.getSubmitted()).isPresent()) {
                    this.submitted(submittedOptional);
                }
                if ((avResultOptional = instance.getAvResult()).isPresent()) {
                    this.avResult(avResultOptional);
                }
                if ((analysisEndedOptional = instance.getAnalysisEnded()).isPresent()) {
                    this.analysisEnded(analysisEndedOptional);
                }
                if ((analysisStartedOptional = instance.getAnalysisStarted()).isPresent()) {
                    this.analysisStarted(analysisStartedOptional);
                }
                if ((sampleRefOptional = instance.getSampleRef()).isPresent()) {
                    this.sampleRef(sampleRefOptional);
                }
            }
            if (object instanceof DomainObject) {
                instance = (DomainObject)object;
                this.addAllRelationships(instance.getRelationships());
            }
        }

        @JsonProperty(value="product")
        @JsonPropertyDescription(value="The name of the analysis product that was used to perform the analysis.")
        @CanIgnoreReturnValue
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="version")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The version of the analysis product that was used to perform the analysis.")
        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hostVmRef(String hostVmRef) {
            this.hostVmRef = Objects.requireNonNull(hostVmRef, "hostVmRef");
            return this;
        }

        @JsonProperty(value="host_vm_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A reference to a SCO Software object for the VM that hosted the malware during the analysis.")
        @CanIgnoreReturnValue
        public final Builder hostVmRef(Optional<String> hostVmRef) {
            this.hostVmRef = hostVmRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder operatingSystemRef(String operatingSystemRef) {
            this.operatingSystemRef = Objects.requireNonNull(operatingSystemRef, "operatingSystemRef");
            return this;
        }

        @JsonProperty(value="operating_system_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A reference to a SCO Software object for the operating system used for the analysis VM.")
        @CanIgnoreReturnValue
        public final Builder operatingSystemRef(Optional<String> operatingSystemRef) {
            this.operatingSystemRef = operatingSystemRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstalledSoftwareRef(@Nullable String element) {
            this.installedSoftwareRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstalledSoftwareRefs(String ... elements) {
            this.installedSoftwareRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="installed_software_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of references to SCO Software objects for the operating system software installed on the analysis VM.")
        @CanIgnoreReturnValue
        public final Builder installedSoftwareRefs(Iterable<String> elements) {
            this.installedSoftwareRefs = ImmutableSet.builder();
            return this.addAllInstalledSoftwareRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInstalledSoftwareRefs(Iterable<String> elements) {
            this.installedSoftwareRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = Objects.requireNonNull(configurationVersion, "configurationVersion");
            return this;
        }

        @JsonProperty(value="configuration_version")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The version of the configuration used for the analysis.")
        @CanIgnoreReturnValue
        public final Builder configurationVersion(Optional<String> configurationVersion) {
            this.configurationVersion = configurationVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder module(String module) {
            this.module = Objects.requireNonNull(module, "module");
            return this;
        }

        @JsonProperty(value="module")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The name of the specific analysis module that was used, if different from the product.")
        @CanIgnoreReturnValue
        public final Builder module(Optional<String> module) {
            this.module = module.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analysisEngineVersion(String analysisEngineVersion) {
            this.analysisEngineVersion = Objects.requireNonNull(analysisEngineVersion, "analysisEngineVersion");
            return this;
        }

        @JsonProperty(value="analysis_engine_version")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The version of the analysis engine or runtime environment.")
        @CanIgnoreReturnValue
        public final Builder analysisEngineVersion(Optional<String> analysisEngineVersion) {
            this.analysisEngineVersion = analysisEngineVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analysisDefinitionVersion(String analysisDefinitionVersion) {
            this.analysisDefinitionVersion = Objects.requireNonNull(analysisDefinitionVersion, "analysisDefinitionVersion");
            return this;
        }

        @JsonProperty(value="analysis_definition_version")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The version of the analysis definitions used (e.g., virus definition version).")
        @CanIgnoreReturnValue
        public final Builder analysisDefinitionVersion(Optional<String> analysisDefinitionVersion) {
            this.analysisDefinitionVersion = analysisDefinitionVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder submitted(StixInstant submitted) {
            this.submitted = Objects.requireNonNull(submitted, "submitted");
            return this;
        }

        @JsonProperty(value="submitted")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The date and time that the malware sample was submitted for analysis.")
        @CanIgnoreReturnValue
        public final Builder submitted(Optional<? extends StixInstant> submitted) {
            this.submitted = submitted.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analysisStarted(StixInstant analysisStarted) {
            this.analysisStarted = Objects.requireNonNull(analysisStarted, "analysisStarted");
            return this;
        }

        @JsonProperty(value="analysis_started")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The date and time that the malware analysis started.")
        @CanIgnoreReturnValue
        public final Builder analysisStarted(Optional<? extends StixInstant> analysisStarted) {
            this.analysisStarted = analysisStarted.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder analysisEnded(StixInstant analysisEnded) {
            this.analysisEnded = Objects.requireNonNull(analysisEnded, "analysisEnded");
            return this;
        }

        @JsonProperty(value="analysis_ended")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The date and time that the malware analysis ended.")
        @CanIgnoreReturnValue
        public final Builder analysisEnded(Optional<? extends StixInstant> analysisEnded) {
            this.analysisEnded = analysisEnded.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder avResult(String avResult) {
            this.avResult = Objects.requireNonNull(avResult, "avResult");
            return this;
        }

        @JsonProperty(value="av_result")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The result of the anti-virus analysis. Open vocabulary - malware-av-result-ov")
        @CanIgnoreReturnValue
        public final Builder avResult(Optional<String> avResult) {
            this.avResult = avResult.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnalysisScoRef(@Nullable String element) {
            this.analysisScoRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAnalysisScoRefs(String ... elements) {
            this.analysisScoRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="analysis_sco_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of references to SCOs that were captured during the analysis process.")
        @CanIgnoreReturnValue
        public final Builder analysisScoRefs(Iterable<String> elements) {
            this.analysisScoRefs = ImmutableSet.builder();
            return this.addAllAnalysisScoRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAnalysisScoRefs(Iterable<String> elements) {
            this.analysisScoRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sampleRef(String sampleRef) {
            this.sampleRef = Objects.requireNonNull(sampleRef, "sampleRef");
            return this;
        }

        @JsonProperty(value="sample_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A reference to the SCO file, malware or artifact object that was analyzed.")
        @CanIgnoreReturnValue
        public final Builder sampleRef(Optional<String> sampleRef) {
            this.sampleRef = sampleRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationship(@Nullable RelationshipSro element) {
            this.relationships.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelationships(RelationshipSro ... elements) {
            this.relationships.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="relationships")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships = ImmutableSet.builder();
            return this.addAllRelationships(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
            this.relationships.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="type")
        @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdByRef(IdentitySdo createdByRef) {
            this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
            return this;
        }

        @JsonProperty(value="created_by_ref")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
        @CanIgnoreReturnValue
        public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
            this.createdByRef = createdByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lang(String lang) {
            this.lang = Objects.requireNonNull(lang, "lang");
            return this;
        }

        @JsonProperty(value="lang")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
        @CanIgnoreReturnValue
        public final Builder lang(Optional<String> lang) {
            this.lang = lang.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
            this.externalReferences.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExternalReferences(ExternalReferenceType ... elements) {
            this.externalReferences.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="external_references")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
        @CanIgnoreReturnValue
        public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences = ImmutableSet.builder();
            return this.addAllExternalReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
            this.externalReferences.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="object_marking_refs")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
        @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
        @JsonIdentityReference(alwaysAsId=true)
        @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="granular_markings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            this.optBits |= 0x10L;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabel(@Nullable String element) {
            this.labels.add((Object)element);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(String ... elements) {
            this.labels.add((Object[])elements);
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="labels")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The labels property specifies a set of classifications.")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<String> elements) {
            this.labels = ImmutableSet.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<String> elements) {
            this.labels.addAll(elements);
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            return this;
        }

        @JsonProperty(value="revoked")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="The revoked property indicates whether the object has been revoked.")
        @CanIgnoreReturnValue
        public final Builder revoked(StixBoolean revoked) {
            this.revoked = Objects.requireNonNull(revoked, "revoked");
            return this;
        }

        public MalwareAnalysis build() {
            return MalwareAnalysis.validate(new MalwareAnalysis(this));
        }

        private boolean relationshipsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean hydratedIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean externalReferencesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean objectMarkingRefsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean granularMarkingsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean labelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    @Generated(from="MalwareAnalysisSdo", generator="Immutables")
    private final class InitShim {
        private byte relationshipsBuildStage = 0;
        private ImmutableSet<RelationshipSro> relationships;
        private byte hydratedBuildStage = 0;
        private boolean hydrated;
        private byte createdBuildStage = 0;
        private StixInstant created;
        private byte externalReferencesBuildStage = 0;
        private ImmutableSet<ExternalReferenceType> externalReferences;
        private byte objectMarkingRefsBuildStage = 0;
        private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
        private byte granularMarkingsBuildStage = 0;
        private ImmutableSet<GranularMarkingDm> granularMarkings;
        private byte labelsBuildStage = 0;
        private ImmutableSet<String> labels;
        private byte modifiedBuildStage = 0;
        private StixInstant modified;
        private byte revokedBuildStage = 0;
        private StixBoolean revoked;

        private InitShim() {
        }

        ImmutableSet<RelationshipSro> getRelationships() {
            if (this.relationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipsBuildStage == 0) {
                this.relationshipsBuildStage = (byte)-1;
                this.relationships = ImmutableSet.copyOf((Collection)MalwareAnalysis.this.getRelationshipsInitialize());
                this.relationshipsBuildStage = 1;
            }
            return this.relationships;
        }

        void relationships(ImmutableSet<RelationshipSro> relationships) {
            this.relationships = relationships;
            this.relationshipsBuildStage = 1;
        }

        boolean getHydrated() {
            if (this.hydratedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hydratedBuildStage == 0) {
                this.hydratedBuildStage = (byte)-1;
                this.hydrated = MalwareAnalysis.this.getHydratedInitialize();
                this.hydratedBuildStage = 1;
            }
            return this.hydrated;
        }

        void hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            this.hydratedBuildStage = 1;
        }

        StixInstant getCreated() {
            if (this.createdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdBuildStage == 0) {
                this.createdBuildStage = (byte)-1;
                this.created = Objects.requireNonNull(MalwareAnalysis.this.getCreatedInitialize(), "created");
                this.createdBuildStage = 1;
            }
            return this.created;
        }

        void created(StixInstant created) {
            this.created = created;
            this.createdBuildStage = 1;
        }

        ImmutableSet<ExternalReferenceType> getExternalReferences() {
            if (this.externalReferencesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.externalReferencesBuildStage == 0) {
                this.externalReferencesBuildStage = (byte)-1;
                this.externalReferences = ImmutableSet.copyOf((Collection)MalwareAnalysis.this.getExternalReferencesInitialize());
                this.externalReferencesBuildStage = 1;
            }
            return this.externalReferences;
        }

        void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
            this.externalReferences = externalReferences;
            this.externalReferencesBuildStage = 1;
        }

        ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
            if (this.objectMarkingRefsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMarkingRefsBuildStage == 0) {
                this.objectMarkingRefsBuildStage = (byte)-1;
                this.objectMarkingRefs = ImmutableSet.copyOf((Collection)MalwareAnalysis.this.getObjectMarkingRefsInitialize());
                this.objectMarkingRefsBuildStage = 1;
            }
            return this.objectMarkingRefs;
        }

        void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
            this.objectMarkingRefs = objectMarkingRefs;
            this.objectMarkingRefsBuildStage = 1;
        }

        ImmutableSet<GranularMarkingDm> getGranularMarkings() {
            if (this.granularMarkingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.granularMarkingsBuildStage == 0) {
                this.granularMarkingsBuildStage = (byte)-1;
                this.granularMarkings = ImmutableSet.copyOf((Collection)MalwareAnalysis.this.getGranularMarkingsInitialize());
                this.granularMarkingsBuildStage = 1;
            }
            return this.granularMarkings;
        }

        void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
            this.granularMarkings = granularMarkings;
            this.granularMarkingsBuildStage = 1;
        }

        ImmutableSet<String> getLabels() {
            if (this.labelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelsBuildStage == 0) {
                this.labelsBuildStage = (byte)-1;
                this.labels = ImmutableSet.copyOf((Collection)MalwareAnalysis.this.getLabelsInitialize());
                this.labelsBuildStage = 1;
            }
            return this.labels;
        }

        void labels(ImmutableSet<String> labels) {
            this.labels = labels;
            this.labelsBuildStage = 1;
        }

        StixInstant getModified() {
            if (this.modifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedBuildStage == 0) {
                this.modifiedBuildStage = (byte)-1;
                this.modified = Objects.requireNonNull(MalwareAnalysis.this.getModifiedInitialize(), "modified");
                this.modifiedBuildStage = 1;
            }
            return this.modified;
        }

        void modified(StixInstant modified) {
            this.modified = modified;
            this.modifiedBuildStage = 1;
        }

        StixBoolean getRevoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = Objects.requireNonNull(MalwareAnalysis.this.getRevokedInitialize(), "revoked");
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(StixBoolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.relationshipsBuildStage == -1) {
                attributes.add("relationships");
            }
            if (this.hydratedBuildStage == -1) {
                attributes.add("hydrated");
            }
            if (this.createdBuildStage == -1) {
                attributes.add("created");
            }
            if (this.externalReferencesBuildStage == -1) {
                attributes.add("externalReferences");
            }
            if (this.objectMarkingRefsBuildStage == -1) {
                attributes.add("objectMarkingRefs");
            }
            if (this.granularMarkingsBuildStage == -1) {
                attributes.add("granularMarkings");
            }
            if (this.labelsBuildStage == -1) {
                attributes.add("labels");
            }
            if (this.modifiedBuildStage == -1) {
                attributes.add("modified");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            return "Cannot build MalwareAnalysis, attribute initializers form cycle " + attributes;
        }
    }
}

