/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.MalwareAnalysis;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.MalwareResult;

@JsonTypeName(value="malware-analysis")
@DefaultTypeValue(value="malware-analysis", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=MalwareAnalysis.class)
@JsonDeserialize(builder=MalwareAnalysis.Builder.class)
@JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "product", "version", "host_vm_ref", "operating_system_ref", "installed_software_refs", "configuration_version", "module", "analysis_engine_version", "analysis_definition_version", "submitted", "analysis_started", "analysis_ended", "av_result", "analysis_sco_refs", "sample_ref"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface MalwareAnalysisSdo
extends DomainObject {
    @NotBlank
    @JsonProperty(value="product")
    @JsonPropertyDescription(value="The name of the analysis product that was used to perform the analysis.")
    @Redactable
    public String getProduct();

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the analysis product that was used to perform the analysis.")
    @Redactable
    public Optional<String> getVersion();

    @JsonProperty(value="host_vm_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A reference to a SCO Software object for the VM that hosted the malware during the analysis.")
    @Redactable
    public Optional<String> getHostVmRef();

    @JsonProperty(value="operating_system_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A reference to a SCO Software object for the operating system used for the analysis VM.")
    @Redactable
    public Optional<String> getOperatingSystemRef();

    @JsonProperty(value="installed_software_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of references to SCO Software objects for the operating system software installed on the analysis VM.")
    @Redactable
    public Set<String> getInstalledSoftwareRefs();

    @JsonProperty(value="configuration_version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the configuration used for the analysis.")
    @Redactable
    public Optional<String> getConfigurationVersion();

    @JsonProperty(value="module")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The name of the specific analysis module that was used, if different from the product.")
    @Redactable
    public Optional<String> getModule();

    @JsonProperty(value="analysis_engine_version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the analysis engine or runtime environment.")
    @Redactable
    public Optional<String> getAnalysisEngineVersion();

    @JsonProperty(value="analysis_definition_version")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The version of the analysis definitions used (e.g., virus definition version).")
    @Redactable
    public Optional<String> getAnalysisDefinitionVersion();

    @JsonProperty(value="submitted")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The date and time that the malware sample was submitted for analysis.")
    @Redactable
    public Optional<StixInstant> getSubmitted();

    @JsonProperty(value="analysis_started")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The date and time that the malware analysis started.")
    @Redactable
    public Optional<StixInstant> getAnalysisStarted();

    @JsonProperty(value="analysis_ended")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The date and time that the malware analysis ended.")
    @Redactable
    public Optional<StixInstant> getAnalysisEnded();

    @JsonProperty(value="av_result")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The result of the anti-virus analysis. Open vocabulary - malware-av-result-ov")
    @Vocab(value=MalwareResult.class)
    @Redactable
    public Optional<String> getAvResult();

    @JsonProperty(value="analysis_sco_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of references to SCOs that were captured during the analysis process.")
    @Redactable
    public Set<String> getAnalysisScoRefs();

    @JsonProperty(value="sample_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A reference to the SCO file, malware or artifact object that was analyzed.")
    @Redactable
    public Optional<String> getSampleRef();
}

