/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Malware;
import security.whisper.javastix.sdo.types.KillChainPhaseType;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.MalwareLabels;

@DefaultTypeValue(value="malware", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="malware")
@JsonSerialize(as=Malware.class)
@JsonDeserialize(builder=Malware.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "kill_chain_phases"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface MalwareSdo
extends DomainObject {
    @Override
    @Vocab(value=MalwareLabels.class)
    @JsonPropertyDescription(value="The type of malware being described. Open Vocab - malware-label-ov")
    @NotNull
    @Size(min=1, message="At least one label from malware-label-ov must be used")
    @Redactable(useMask=true)
    @Value.Default
    default public @Vocab(value=MalwareLabels.class) @NotNull @Size(min=1, message="At least one label from malware-label-ov must be used") Set<@Length(min=1) String> getLabels() {
        return Collections.emptySet();
    }

    @NotBlank
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name used to identify the Malware.")
    @Redactable(useMask=true)
    public String getName();

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Provides more context and details about the Malware object.")
    @Redactable
    public Optional<String> getDescription();

    @NotNull
    @JsonProperty(value="kill_chain_phases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of kill chain phases for which this Malware instance can be used.")
    @Redactable
    @Value.Default
    default public Set<KillChainPhaseType> getKillChainPhases() {
        return Collections.emptySet();
    }
}

