/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Range;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.json.observables.CyberObservableSetFieldDeserializer;
import security.whisper.javastix.coo.json.observables.CyberObservableSetFieldSerializer;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.ObservedData;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@JsonTypeName(value="observed-data")
@DefaultTypeValue(value="observed-data", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=ObservedData.class)
@JsonDeserialize(builder=ObservedData.Builder.class)
@JsonPropertyOrder(value={"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "first_observed", "last_observed", "number_observed", "objects"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface ObservedDataSdo
extends DomainObject {
    @NotNull
    @JsonProperty(value="first_observed")
    @JsonPropertyDescription(value="The beginning of the time window that the data was observed during.")
    @Redactable(useMask=true)
    public StixInstant getFirstObserved();

    @NotNull
    @JsonProperty(value="last_observed")
    @JsonPropertyDescription(value="The end of the time window that the data was observed during.")
    @Redactable(useMask=true)
    public StixInstant getLastObserved();

    @NotNull
    @Positive
    @JsonProperty(value="number_observed")
    @JsonPropertyDescription(value="The number of times the data represented in the objects property was observed. This MUST be an integer between 1 and 999,999,999 inclusive.")
    @Redactable(useMask=true)
    @Range(min=1L, max=999999999L)
    public @NotNull @Positive @Range(min=1L, max=999999999L) Integer getNumberObserved();

    @NotNull
    @Size(min=1, message="At least one Cyber Observable Reference must be provided")
    @JsonProperty(value="objects")
    @JsonPropertyDescription(value="A dictionary of Cyber Observable Objects that describes the single 'fact' that was observed.")
    @Redactable(useMask=true)
    @JsonSerialize(using=CyberObservableSetFieldSerializer.class)
    @JsonDeserialize(using=CyberObservableSetFieldDeserializer.class)
    @Value.Default
    default public @NotNull @Size(min=1, message="At least one Cyber Observable Reference must be provided") Set<CyberObservableObject> getObjects() {
        return Collections.emptySet();
    }
}

