/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.objects.Opinion;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.OpinionEnum;

@JsonTypeName(value="opinion")
@DefaultTypeValue(value="opinion", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Opinion.class)
@JsonDeserialize(builder=Opinion.Builder.class)
@JsonPropertyOrder(value={"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "opinion", "explanation", "authors", "object_refs"})
@Redactable
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Sdo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface OpinionSdo
extends DomainObject {
    @NotBlank
    @JsonProperty(value="opinion")
    @JsonPropertyDescription(value="The opinion that the producing organization has about the correctness of the information.")
    @Vocab(value=OpinionEnum.class)
    @Redactable
    public String getOpinion();

    @JsonProperty(value="explanation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="An explanation of why the producer has this opinion.")
    @Redactable
    public Optional<String> getExplanation();

    @JsonProperty(value="authors")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The name of the author(s) of this opinion (e.g., the analyst(s) that created it).")
    @Redactable
    public Set<String> getAuthors();

    @NotNull
    @Size(min=1)
    @JsonProperty(value="object_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The STIX Objects that this opinion is being applied to.")
    @Redactable
    public @NotNull @Size(min=1) Set<BundleableObject> getObjectRefs();
}

